/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.exceptions;

import java.awt.EventQueue;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.openide.util.NbBundle;

public class ExceptionsSettings {
    private static final String userProp = "UserName";
    private static final String passwdProp = "Passwd";
    private static final String passwdKey = "exceptionreporter";
    private static final String guestProp = "Guest";
    private static final String rememberProp = "RememberPasswd";
    private String userName;
    private char[] passwd;
    private boolean changed = false;

    public ExceptionsSettings() {
        assert (!EventQueue.isDispatchThread());
        this.userName = this.prefs().get(userProp, "");
        String old = this.prefs().get(passwdProp, null);
        char[] keyringPasswd = Keyring.read((String)passwdKey);
        if (old != null) {
            this.passwd = old.toCharArray();
            this.changed = true;
            this.prefs().remove(passwdProp);
        } else if (keyringPasswd != null) {
            this.passwd = keyringPasswd;
        }
        if (this.passwd == null) {
            this.passwd = new char[0];
        }
        if (this.userName == null) {
            this.userName = new String();
        }
    }

    public void save() {
        assert (!EventQueue.isDispatchThread());
        if (!this.changed) {
            return;
        }
        this.prefs().put(userProp, this.userName);
        Keyring.save((String)passwdKey, (char[])this.passwd, (String)NbBundle.getMessage(ExceptionsSettings.class, (String)"ExceptionsSettings.password.description"));
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.changed = true;
    }

    public char[] getPasswd() {
        return this.passwd;
    }

    public void setPasswd(char[] passwd) {
        this.changed = true;
        this.passwd = passwd;
    }

    public boolean isGuest() {
        return this.prefs().getBoolean(guestProp, false);
    }

    public void setGuest(Boolean guest) {
        this.prefs().putBoolean(guestProp, guest);
    }

    public boolean rememberPasswd() {
        return this.prefs().getBoolean(rememberProp, true);
    }

    public void setRememberPasswd(boolean remember) {
        this.prefs().putBoolean(rememberProp, remember);
    }

    private Preferences prefs() {
        return Preferences.userRoot().node("org/netbeans/modules/exceptions");
    }
}

