/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.InstDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class InstDBAdapterV0
extends InstDBAdapter {
    private Table instTable;
    private AddressMap addrMap;

    InstDBAdapterV0(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.instTable = handle.getTable("Instructions");
        if (this.instTable == null) {
            throw new VersionException("Missing Table: Instructions");
        }
        if (this.instTable.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    @Override
    void createInstruction(long addr, int protoID, byte flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteRecord(long addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteAll() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord getRecordAtOrAfter(Address start) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, start, true);
        return this.adaptRecord(it.next());
    }

    @Override
    DBRecord getRecordAtOrBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, false);
        return this.adaptRecord(it.previous());
    }

    @Override
    DBRecord getRecord(Address addr) throws IOException {
        return this.getRecord(this.addrMap.getKey(addr, false));
    }

    @Override
    DBRecord getRecord(long addr) throws IOException {
        return this.adaptRecord(this.instTable.getRecord(addr));
    }

    @Override
    DBRecord getRecordAfter(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, false);
        return this.adaptRecord(it.next());
    }

    @Override
    DBRecord getRecordBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, true);
        return this.adaptRecord(it.previous());
    }

    @Override
    RecordIterator getRecords(Address addr, boolean forward) throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, forward));
    }

    @Override
    RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.instTable, this.addrMap, atStart ? start : end, atStart));
    }

    @Override
    int getRecordCount() throws IOException {
        return this.instTable.getRecordCount();
    }

    @Override
    AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.instTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.instTable, this.addrMap, start, end, end, false);
    }

    @Override
    AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.instTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.instTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    boolean deleteRecords(Address start, Address end) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void putRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.instTable, this.addrMap));
    }

    @Override
    RecordIterator getRecords(AddressSetView set, boolean forward) throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.instTable, this.addrMap, set, forward ? set.getMinAddress() : set.getMaxAddress(), forward));
    }

    private DBRecord adaptRecord(DBRecord rec) {
        if (rec == null) {
            return null;
        }
        DBRecord newRec = INSTRUCTION_SCHEMA.createRecord(rec.getKey());
        newRec.setIntValue(0, rec.getIntValue(0));
        newRec.setByteValue(1, (byte)0);
        return newRec;
    }

    @Override
    void updateFlags(long addr, byte flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    class RecordIteratorAdapter
    implements RecordIterator {
        RecordIterator it;

        RecordIteratorAdapter(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            return false;
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return InstDBAdapterV0.this.adaptRecord(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return InstDBAdapterV0.this.adaptRecord(rec);
        }
    }
}

