/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.VectorResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExecutableScorer {
    protected DescriptionManager executableSet = new DescriptionManager();
    protected Map<Integer, ExecutableRecord> index2ExeMap = null;
    private float[][] score = null;
    protected double simThreshold = -1.0;
    protected double sigThreshold = -1.0;
    protected ExecutableRecord singleExe = null;
    protected int singleExeXref = -1;

    public double getSimThreshold() {
        return this.simThreshold;
    }

    public double getSigThreshold() {
        return this.sigThreshold;
    }

    public void setSingleExecutable(String md5) throws LSHException {
        this.singleExe = this.executableSet.findExecutable(md5);
        this.singleExeXref = this.singleExe.getXrefIndex();
    }

    public int countSelfScores() {
        return this.executableSet.numExecutables();
    }

    public void resetStorage(double simThresh, double sigThresh) throws LSHException {
        this.simThreshold = simThresh;
        this.sigThreshold = sigThresh;
        this.score = null;
    }

    public int numExecutables() {
        return this.executableSet.numExecutables();
    }

    public ExecutableRecord getSingularExecutable() {
        return this.singleExe;
    }

    public float getSingularSelfScore() {
        return this.score[this.singleExeXref - 1][this.singleExeXref - 1];
    }

    public ExecutableRecord getExecutable(String md5) throws LSHException {
        return this.executableSet.findExecutable(md5);
    }

    public ExecutableRecord getExecutable(int index) {
        if (this.index2ExeMap == null) {
            this.index2ExeMap = this.executableSet.generateExecutableXrefMap();
        }
        return this.index2ExeMap.get(index);
    }

    protected void transferSettings(DatabaseInformation info) {
        this.executableSet.setVersion(info.major, info.minor);
        this.executableSet.setSettings(info.settings);
    }

    protected void addExecutable(ExecutableRecord exeRecord) throws LSHException {
        this.executableSet.transferExecutable(exeRecord);
    }

    protected void populateExecutableIndex() {
        this.executableSet.populateExecutableXref();
    }

    protected void labelAndFilter(DescriptionManager manage) {
        manage.matchAndSetXrefs(this.executableSet);
    }

    protected void initializeScores() {
        int size = this.executableSet.numExecutables();
        this.score = new float[size][];
        for (int i = 0; i < size; ++i) {
            this.score[i] = new float[i + 1];
            float[] row = this.score[i];
            for (int j = 0; j <= i; ++j) {
                row[j] = 0.0f;
            }
        }
    }

    protected void scorePair(FunctionPair pair) {
        int indexA = pair.funcA.getExecutableRecord().getXrefIndex();
        int indexB = pair.funcB.getExecutableRecord().getXrefIndex();
        if (indexB > indexA) {
            int tmp = indexA;
            indexA = indexB;
            indexB = tmp;
        }
        float[] fArray = this.score[indexA - 1];
        int n = indexB - 1;
        fArray[n] = (float)((double)fArray[n] + pair.significance);
    }

    public float getScore(int a, int b) {
        if (b > a) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        return this.score[a - 1][b - 1];
    }

    public float getSelfScore(int a) throws LSHException {
        return this.score[a - 1][a - 1];
    }

    public void commitSelfScore() throws LSHException {
        throw new LSHException("Cannot commit self-score with the matrix scorer");
    }

    protected void commitSelfScore(String md5, float selfScore) throws LSHException {
        throw new LSHException("Cannot commit self-score with the matrix scorer");
    }

    public float getScore(int a) {
        return this.getScore(this.singleExeXref, a);
    }

    public float getNormalizedScore(int a, int b, boolean useLibrary) throws LSHException {
        float selfB;
        float baseScore = this.getScore(a, b);
        float selfA = this.getSelfScore(a);
        if (selfA < (selfB = this.getSelfScore(b))) {
            boolean bl = useLibrary = !useLibrary;
        }
        if (useLibrary) {
            if (selfB == 0.0f) {
                return -1.0f;
            }
            return baseScore / selfB;
        }
        if ((double)selfA == 0.0) {
            return -1.0f;
        }
        return baseScore / selfA;
    }

    public float getNormalizedScore(int a, boolean useLibrary) throws LSHException {
        return this.getNormalizedScore(a, this.singleExeXref, useLibrary);
    }

    protected List<FunctionPair> pairFunctions(LSHVectorFactory vectorFactory, List<DescriptionManager> vec2func, List<VectorResult> vectors, int hitcount, int pairThreshold) {
        int totalSize = hitcount * (hitcount + 1) / 2;
        if (totalSize > pairThreshold) {
            return null;
        }
        ArrayList<FunctionPair> result = new ArrayList<FunctionPair>(totalSize);
        VectorCompare vectorCompare = new VectorCompare();
        for (int v1 = 0; v1 < vec2func.size(); ++v1) {
            for (int v2 = v1; v2 < vec2func.size(); ++v2) {
                int func2Index;
                int func1Index;
                FunctionDescription func1;
                Iterator<FunctionDescription> iter1;
                double significance;
                double similarity = vectors.get((int)v1).vec.compare(vectors.get((int)v2).vec, vectorCompare);
                if (similarity < this.simThreshold || (significance = vectorFactory.calculateSignificance(vectorCompare)) < this.sigThreshold) continue;
                if (v1 == v2) {
                    iter1 = vec2func.get(v1).listAllFunctions();
                    while (iter1.hasNext()) {
                        FunctionDescription func2;
                        func1 = iter1.next();
                        func1Index = func1.getExecutableRecord().getXrefIndex();
                        if (func1Index == 0) continue;
                        Iterator<FunctionDescription> iter2 = vec2func.get(v1).listAllFunctions();
                        do {
                            if ((func2Index = (func2 = iter2.next()).getExecutableRecord().getXrefIndex()) == 0) continue;
                            result.add(new FunctionPair(func1, func2, similarity, significance));
                        } while (func2 != func1);
                    }
                    continue;
                }
                iter1 = vec2func.get(v1).listAllFunctions();
                while (iter1.hasNext()) {
                    func1 = iter1.next();
                    func1Index = func1.getExecutableRecord().getXrefIndex();
                    if (func1Index == 0) continue;
                    Iterator<FunctionDescription> iter2 = vec2func.get(v2).listAllFunctions();
                    while (iter2.hasNext()) {
                        FunctionDescription func2 = iter2.next();
                        func2Index = func2.getExecutableRecord().getXrefIndex();
                        if (func2Index == 0) continue;
                        result.add(new FunctionPair(func1, func2, similarity, significance));
                    }
                }
            }
        }
        return result;
    }

    private void scoreAcrossExecutablePair(List<FunctionPair> pairs, int i, int j) {
        int size = j - i;
        FunctionPair pair1 = pairs.get(i);
        if (size == 1) {
            this.scorePair(pair1);
        } else if (size == 2) {
            FunctionPair pair2 = pairs.get(i + 1);
            if (pair1.funcA == pair2.funcA || pair1.funcB == pair2.funcB) {
                this.scorePair(pair1);
            } else {
                this.scorePair(pair1);
                this.scorePair(pair2);
            }
        } else if (pair1.funcA.getExecutableRecord().getXrefIndex() == pair1.funcB.getExecutableRecord().getXrefIndex()) {
            while (i < j) {
                FunctionPair pair = pairs.get(i);
                if (pair.funcA == pair.funcB) {
                    this.scorePair(pair);
                }
                ++i;
            }
        } else {
            HashSet<Long> aUsed = new HashSet<Long>();
            HashSet<Long> bUsed = new HashSet<Long>();
            while (i < j) {
                Long bAddress;
                FunctionPair pair = pairs.get(i);
                Long aAddress = pair.funcA.getAddress();
                if (!aUsed.contains(aAddress) && !bUsed.contains(bAddress = Long.valueOf(pair.funcB.getAddress()))) {
                    aUsed.add(aAddress);
                    bUsed.add(bAddress);
                    this.scorePair(pair);
                }
                ++i;
            }
        }
    }

    protected boolean checkPreliminaryPairThreshold(int hitcount, int pairThreshold) {
        int totalSize = hitcount * (hitcount + 1) / 2;
        return totalSize <= pairThreshold;
    }

    protected boolean scoreCluster(LSHVectorFactory vectorFactory, List<DescriptionManager> vec2Functions, List<VectorResult> vectors, int hitcount, int pairThreshold) {
        List<FunctionPair> pairs = this.pairFunctions(vectorFactory, vec2Functions, vectors, hitcount, pairThreshold);
        if (pairs == null) {
            return false;
        }
        Collections.sort(pairs);
        int i = 0;
        while (i < pairs.size()) {
            int j;
            ExecutableRecord rec1 = pairs.get((int)i).funcA.getExecutableRecord();
            ExecutableRecord rec2 = pairs.get((int)i).funcB.getExecutableRecord();
            for (j = i + 1; j < pairs.size(); ++j) {
                FunctionPair currentPair = pairs.get(j);
                if (!rec2.equals(currentPair.funcB.getExecutableRecord()) || !rec1.equals(currentPair.funcA.getExecutableRecord())) break;
            }
            this.scoreAcrossExecutablePair(pairs, i, j);
            i = j;
        }
        return true;
    }

    public static class FunctionPair
    implements Comparable<FunctionPair> {
        protected FunctionDescription funcA;
        protected FunctionDescription funcB;
        protected double similarity;
        protected double significance;

        public FunctionPair(FunctionDescription a, FunctionDescription b, double sim, double sig) {
            if (a.getExecutableRecord().getXrefIndex() <= b.getExecutableRecord().getXrefIndex()) {
                this.funcA = a;
                this.funcB = b;
            } else {
                this.funcA = b;
                this.funcB = a;
            }
            this.similarity = sim;
            this.significance = sig;
        }

        @Override
        public int compareTo(FunctionPair o) {
            int comp = Integer.compare(this.funcA.getExecutableRecord().getXrefIndex(), o.funcA.getExecutableRecord().getXrefIndex());
            if (comp != 0) {
                return comp;
            }
            comp = Integer.compare(this.funcB.getExecutableRecord().getXrefIndex(), o.funcB.getExecutableRecord().getXrefIndex());
            if (comp != 0) {
                return comp;
            }
            comp = Double.compare(this.similarity, o.similarity);
            if (comp != 0) {
                return -comp;
            }
            comp = Long.compare(this.funcA.getAddress(), o.funcA.getAddress());
            if (comp != 0) {
                return comp;
            }
            comp = Long.compare(this.funcB.getAddress(), o.funcB.getAddress());
            return comp;
        }
    }
}

