/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.datatypes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledList;
import ghidra.app.util.demangler.DemangledParameter;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.program.model.data.CategoryPath;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SwiftDataTypeUtils {
    public static final CategoryPath SWIFT_CATEGORY = new CategoryPath("/Demangler");

    public static boolean isSwiftNamespace(Demangled namespace) {
        return namespace != null && namespace.getName().equals("Swift");
    }

    public static Demangled getSwiftNamespace() {
        return new DemangledUnknown("", "Swift", "Swift");
    }

    public static CategoryPath getCategoryPath(Demangled namespace) {
        if (namespace == null) {
            return SWIFT_CATEGORY;
        }
        LinkedList<String> path = new LinkedList<String>();
        while (namespace != null) {
            path.addFirst(namespace.getNamespaceName());
            namespace = namespace.getNamespace();
        }
        return new CategoryPath(SWIFT_CATEGORY, path);
    }

    public static List<DemangledParameter> extractParameters(Demangled demangled) {
        ArrayList<DemangledParameter> params = new ArrayList<DemangledParameter>();
        if (demangled instanceof DemangledVariable) {
            DemangledVariable variable = (DemangledVariable)demangled;
            demangled = variable.getDataType();
        }
        if (demangled instanceof DemangledList) {
            DemangledList list = (DemangledList)demangled;
            for (Demangled d : list) {
                if (!(d instanceof DemangledDataType)) continue;
                DemangledDataType type = (DemangledDataType)d;
                params.add(new DemangledParameter(type));
            }
        } else if (demangled instanceof DemangledDataType) {
            DemangledDataType type = (DemangledDataType)demangled;
            params.add(new DemangledParameter(type));
        }
        return params;
    }
}

