/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.merge;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.merge.MergeStrategy;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLEntityRenamer;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;

public class MergeEntitiesChangeListGenerator {
    @Nonnull
    private final OWLOntology rootOntology;
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final ImmutableSet<OWLEntity> sourceEntities;
    @Nonnull
    private final OWLEntity targetEntity;
    @Nonnull
    private final MergeStrategy mergeStrategy;

    public MergeEntitiesChangeListGenerator(@Nonnull OWLOntology rootOntology, @Nonnull OWLDataFactory dataFactory, @Nonnull ImmutableSet<OWLEntity> sourceEntities, @Nonnull OWLEntity targetEntity, @Nonnull MergeStrategy mergeStrategy) {
        this.rootOntology = (OWLOntology)Preconditions.checkNotNull((Object)rootOntology);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
        this.sourceEntities = (ImmutableSet)Preconditions.checkNotNull(sourceEntities);
        this.targetEntity = (OWLEntity)Preconditions.checkNotNull((Object)targetEntity);
        this.mergeStrategy = (MergeStrategy)((Object)Preconditions.checkNotNull((Object)((Object)mergeStrategy)));
    }

    public List<OWLOntologyChange> generateChanges() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.replaceUsage((ImmutableList.Builder<OWLOntologyChange>)builder);
        this.replaceLabels((ImmutableList.Builder<OWLOntologyChange>)builder);
        this.replaceId((ImmutableList.Builder<OWLOntologyChange>)builder);
        this.deprecateSourceEntities((ImmutableList.Builder<OWLOntologyChange>)builder);
        return builder.build();
    }

    private void deprecateSourceEntities(ImmutableList.Builder<OWLOntologyChange> builder) {
        if (this.mergeStrategy == MergeStrategy.DELETE_SOURCE_ENTITY) {
            return;
        }
        this.sourceEntities.forEach(sourceEntity -> {
            OWLAnnotationAssertionAxiom depAx = this.dataFactory.getDeprecatedOWLAnnotationAssertionAxiom(sourceEntity.getIRI());
            builder.add((Object)new AddAxiom(this.rootOntology, (OWLAxiom)depAx));
        });
    }

    private void replaceUsage(ImmutableList.Builder<OWLOntologyChange> builder) {
        this.sourceEntities.forEach(sourceEntity -> {
            OWLEntityRenamer renamer = new OWLEntityRenamer(this.rootOntology.getOWLOntologyManager(), this.rootOntology.getImportsClosure());
            List renameChanges = renamer.changeIRI(sourceEntity.getIRI(), this.targetEntity.getIRI());
            builder.addAll((Iterable)renameChanges);
        });
    }

    private void replaceLabels(@Nonnull ImmutableList.Builder<OWLOntologyChange> builder) {
        MergeEntitiesChangeListGenerator.ontologyStream(this.rootOntology, Imports.INCLUDED).forEach(ont -> this.sourceEntities.forEach(sourceEntity -> ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)sourceEntity.getIRI()).stream().filter(ax -> this.isRdfsLabelAnnotation((OWLAnnotationAssertionAxiom)ax) || this.isSkosPrefLabelAnnotation((OWLAnnotationAssertionAxiom)ax)).forEach(ax -> this.replaceWithLabelReplacement((OWLAnnotationAssertionAxiom)ax, (OWLOntology)ont, builder))));
    }

    private void replaceWithLabelReplacement(@Nonnull OWLAnnotationAssertionAxiom ax, @Nonnull OWLOntology ont, @Nonnull ImmutableList.Builder<OWLOntologyChange> builder) {
        OWLAnnotationAssertionAxiom origAx = this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.targetEntity.getIRI(), ax.getAnnotation(), ax.getAnnotations());
        builder.add((Object)new RemoveAxiom(ont, (OWLAxiom)origAx));
        OWLAnnotation replAnno = this.dataFactory.getOWLAnnotation(this.getLabelReplacementProperty(), ax.getAnnotation().getValue(), ax.getAnnotation().getAnnotations());
        OWLAnnotationAssertionAxiom replAx = this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.targetEntity.getIRI(), replAnno, ax.getAnnotations());
        builder.add((Object)new AddAxiom(ont, (OWLAxiom)replAx));
    }

    private boolean isRdfsLabelAnnotation(@Nonnull OWLAnnotationAssertionAxiom ax) {
        return ax.getProperty().isLabel();
    }

    private boolean isSkosPrefLabelAnnotation(@Nonnull OWLAnnotationAssertionAxiom ax) {
        return SKOSVocabulary.PREFLABEL.getIRI().equals((Object)ax.getProperty().getIRI());
    }

    @Nonnull
    private OWLAnnotationProperty getLabelReplacementProperty() {
        if (OboUtilities.isOboIri(this.targetEntity.getIRI())) {
            return this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasRelatedSynonym.getIRI());
        }
        return this.dataFactory.getOWLAnnotationProperty(SKOSVocabulary.ALTLABEL.getIRI());
    }

    private void replaceId(@Nonnull ImmutableList.Builder<OWLOntologyChange> builder) {
        if (!OboUtilities.isOboIri(this.targetEntity.getIRI())) {
            return;
        }
        MergeEntitiesChangeListGenerator.ontologyStream(this.rootOntology, Imports.INCLUDED).forEach(ontology -> this.sourceEntities.forEach(sourceEntity -> ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)sourceEntity.getIRI()).stream().filter(this::isOboIdAnnotationAssertion).map(this::toTargetAnnotationAssertion).peek(ax -> builder.add((Object)new RemoveAxiom(ontology, (OWLAxiom)ax))).map(this::toOboAltIdAnnotationAssertion).forEach(ax -> builder.add((Object)new AddAxiom(ontology, (OWLAxiom)ax)))));
    }

    private static Stream<OWLOntology> ontologyStream(OWLOntology ontology, Imports imports) {
        if (imports == Imports.INCLUDED) {
            return ontology.getImportsClosure().stream();
        }
        return Stream.of(ontology);
    }

    private boolean isOboIdAnnotationAssertion(OWLAnnotationAssertionAxiom axiom) {
        return axiom.getProperty().getIRI().equals((Object)IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#id"));
    }

    private OWLAnnotationAssertionAxiom toTargetAnnotationAssertion(OWLAnnotationAssertionAxiom axiom) {
        return this.dataFactory.getOWLAnnotationAssertionAxiom(axiom.getProperty(), (OWLAnnotationSubject)this.targetEntity.getIRI(), axiom.getValue(), axiom.getAnnotations());
    }

    @Nonnull
    private OWLAnnotationAssertionAxiom toOboAltIdAnnotationAssertion(@Nonnull OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationProperty prop = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.hasAlternativeId.getIRI());
        return this.dataFactory.getOWLAnnotationAssertionAxiom(prop, ax.getSubject(), ax.getValue(), ax.getAnnotations());
    }
}

