/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import java.util.HashMap;

public class TextRegionUtil {
    public final int renderModes;
    public static final int DEFAULT_CACHE_LIMIT = 256;
    public final AffineTransform tempT1 = new AffineTransform();
    public final AffineTransform tempT2 = new AffineTransform();
    private final HashMap<Key, GLRegion> stringCacheMap = new HashMap(256);
    private final ArrayList<Key> stringCacheArray = new ArrayList(256);
    private int stringCacheLimit = 256;

    public TextRegionUtil(int n) {
        this.renderModes = n;
    }

    public static int getCharCount(String string, char c) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != c) continue;
            ++n2;
        }
        return n2;
    }

    public static AABBox addStringToRegion(Region region, Font font, AffineTransform affineTransform, CharSequence charSequence, Vec4f vec4f) {
        return TextRegionUtil.addStringToRegion(true, region, font, affineTransform, charSequence, vec4f, new AffineTransform(), new AffineTransform());
    }

    public static AABBox addStringToRegion(Region region, Font font, AffineTransform affineTransform, CharSequence charSequence, Vec4f vec4f, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        return TextRegionUtil.addStringToRegion(true, region, font, affineTransform, charSequence, vec4f, affineTransform2, affineTransform3);
    }

    public static AABBox addStringToRegion(boolean bl, final Region region, Font font, AffineTransform affineTransform, CharSequence charSequence, final Vec4f vec4f, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            @Override
            public void visit(char c, Font.Glyph glyph, AffineTransform affineTransform) {
                if (glyph.isWhiteSpace()) {
                    return;
                }
                region.addOutlineShape(glyph.getShape(), affineTransform, vec4f);
            }
        };
        if (bl) {
            int[] nArray = TextRegionUtil.countStringRegion(font, charSequence, new int[2]);
            region.growBuffer(nArray[0], nArray[1]);
        }
        return font.processString(glyphVisitor, affineTransform, charSequence, affineTransform2, affineTransform3);
    }

    public static int[] countStringRegion(Font font, CharSequence charSequence, final int[] nArray) {
        Font.GlyphVisitor2 glyphVisitor2 = new Font.GlyphVisitor2(){

            @Override
            public final void visit(char c, Font.Glyph glyph) {
                Region.countOutlineShape(glyph.getShape(), nArray);
            }
        };
        font.processString(glyphVisitor2, charSequence);
        return nArray;
    }

    public AABBox drawString3D(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Font font, CharSequence charSequence, Vec4f vec4f, int[] nArray) {
        AABBox aABBox;
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = this.getCachedRegion(font, charSequence);
        if (null == gLRegion) {
            gLRegion = GLRegion.create(gL2ES2.getGLProfile(), this.renderModes, null, font, charSequence);
            aABBox = TextRegionUtil.addStringToRegion(false, gLRegion, font, null, charSequence, vec4f, this.tempT1, this.tempT2);
            this.addCachedRegion(gL2ES2, font, charSequence, gLRegion);
        } else {
            aABBox = new AABBox();
            aABBox.copy(gLRegion.getBounds());
        }
        if (!gLRegion.hasColorChannel()) {
            if (null != vec4f) {
                regionRenderer.setColorStatic(vec4f);
            }
        } else {
            regionRenderer.setColorStatic(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
        return aABBox;
    }

    public static AABBox drawString3D(GL2ES2 gL2ES2, int n, RegionRenderer regionRenderer, Font font, CharSequence charSequence, Vec4f vec4f, int[] nArray) {
        return TextRegionUtil.drawString3D(gL2ES2, n, regionRenderer, font, charSequence, vec4f, nArray, new AffineTransform(), new AffineTransform());
    }

    public static AABBox drawString3D(GL2ES2 gL2ES2, int n, RegionRenderer regionRenderer, Font font, CharSequence charSequence, Vec4f vec4f, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = GLRegion.create(gL2ES2.getGLProfile(), n, null, font, charSequence);
        AABBox aABBox = TextRegionUtil.addStringToRegion(false, gLRegion, font, null, charSequence, vec4f, affineTransform, affineTransform2);
        if (!gLRegion.hasColorChannel()) {
            if (null != vec4f) {
                regionRenderer.setColorStatic(vec4f);
            }
        } else {
            regionRenderer.setColorStatic(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
        gLRegion.destroy(gL2ES2);
        return aABBox;
    }

    public static AABBox drawString3D(GL2ES2 gL2ES2, GLRegion gLRegion, RegionRenderer regionRenderer, Font font, CharSequence charSequence, Vec4f vec4f, int[] nArray) {
        return TextRegionUtil.drawString3D(gL2ES2, gLRegion, regionRenderer, font, charSequence, vec4f, nArray, new AffineTransform(), new AffineTransform());
    }

    public static AABBox drawString3D(GL2ES2 gL2ES2, GLRegion gLRegion, RegionRenderer regionRenderer, Font font, CharSequence charSequence, Vec4f vec4f, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        AABBox aABBox = TextRegionUtil.addStringToRegion(true, gLRegion, font, null, charSequence, vec4f, affineTransform, affineTransform2);
        if (!gLRegion.hasColorChannel()) {
            if (null != vec4f) {
                regionRenderer.setColorStatic(vec4f);
            }
        } else {
            regionRenderer.setColorStatic(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
        return aABBox;
    }

    public void clear(GL2ES2 gL2ES2) {
        for (GLRegion gLRegion : this.stringCacheMap.values()) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheMap.clear();
        this.stringCacheArray.clear();
    }

    public final void setCacheLimit(int n) {
        this.stringCacheLimit = n;
    }

    public final void setCacheLimit(GL2ES2 gL2ES2, int n) {
        this.stringCacheLimit = n;
        this.validateCache(gL2ES2, 0);
    }

    public final int getCacheLimit() {
        return this.stringCacheLimit;
    }

    public final int getCacheSize() {
        return this.stringCacheArray.size();
    }

    private final void validateCache(GL2ES2 gL2ES2, int n) {
        if (this.getCacheLimit() > 0) {
            while (this.getCacheSize() + n > this.getCacheLimit()) {
                this.removeCachedRegion(gL2ES2, 0);
            }
        }
    }

    private final GLRegion getCachedRegion(Font font, CharSequence charSequence) {
        return this.stringCacheMap.get(new Key(font, charSequence));
    }

    private final void addCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence, GLRegion gLRegion) {
        Key key;
        GLRegion gLRegion2;
        if (0 != this.getCacheLimit() && null == (gLRegion2 = this.stringCacheMap.put(key = new Key(font, charSequence), gLRegion))) {
            this.validateCache(gL2ES2, 1);
            this.stringCacheArray.add(this.stringCacheArray.size(), key);
        }
    }

    private final void removeCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence) {
        Key key = new Key(font, charSequence);
        GLRegion gLRegion = this.stringCacheMap.remove(key);
        if (null != gLRegion) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheArray.remove(key);
    }

    private final void removeCachedRegion(GL2ES2 gL2ES2, int n) {
        GLRegion gLRegion;
        Key key = this.stringCacheArray.remove(n);
        if (null != key && null != (gLRegion = this.stringCacheMap.remove(key))) {
            gLRegion.destroy(gL2ES2);
        }
    }

    private class Key {
        private final String fontName;
        private final CharSequence text;
        public final int hash;

        public Key(Font font, CharSequence charSequence) {
            this.fontName = font.getName(3);
            this.text = charSequence;
            int n = 31 + this.fontName.hashCode();
            this.hash = (n << 5) - n + charSequence.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                return key.fontName.equals(this.fontName) && key.text.equals(this.text);
            }
            return false;
        }
    }
}

