"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const utils_1 = require("../utils");
function create() {
    return {
        name: 'vue-compiler-dom-errors',
        capabilities: {
            diagnosticProvider: {
                interFileDependencies: false,
                workspaceDiagnostics: false,
            },
        },
        create(context) {
            return {
                provideDiagnostics(document) {
                    const info = (0, utils_1.resolveEmbeddedCode)(context, document.uri);
                    if (info?.code.id !== 'template') {
                        return;
                    }
                    const { template } = info.root.sfc;
                    if (!template) {
                        return;
                    }
                    const diagnostics = [];
                    for (const [errors, severity] of [
                        [template.errors, 1],
                        [template.warnings, 2],
                    ]) {
                        for (const error of errors) {
                            diagnostics.push({
                                range: {
                                    start: document.positionAt(error.loc?.start.offset ?? 0),
                                    end: document.positionAt(error.loc?.end.offset ?? 0),
                                },
                                severity,
                                code: error.code,
                                source: 'vue',
                                message: error.message,
                            });
                        }
                    }
                    return diagnostics;
                },
            };
        },
    };
}
//# sourceMappingURL=vue-compiler-dom-errors.js.map