# BRP-PACU - An Audio Configuration utility
BRP-PACU is a dual channel FFT audio analysis tool. It is designed to aid in the equalization and time alignment of a sound system. It compares the output of the system to the input of the system to obtain the transfer function of the system. It is similar to commercial products like [Smaart](https://en.wikipedia.org/wiki/Smaart).

## Dependencies
Development versions of the following packages:
* `build-essential` for build tools
* [jack2](http://jackaudio.org/)
  * Tip: If jack is not already installed on your system, try to install the package `qjackctl` which depends on JACK and provides an easy way to manage JACK connections.
* [GtK+](https://www.gtk.org/) and [Glade](https://glade.gnome.org/)
* [GTKdatabox for GTK3](https://sourceforge.net/u/felipo/gtkdatabox/ci/master/tree)
  * `git clone https://git.code.sf.net/u/felipo/gtkdatabox gtkdatabox3`
  * Run `./scripts/myAutogen.sh` and then the traditional `./configure`, `make`, and `make install` since this is not a release, but coming straight from the repo.
  * The original library on SourceForge claims GTK3 support on the [git master branch](https://sourceforge.net/p/gtkdatabox/git/ci/master/tree/) but this has not been tested with BRP-PACU; while the fork from `felipo` indicated above has been tested OK.
* [FFTW version 3](http://www.fftw.org/)

### On Ubuntu 16.04:  
```
sudo apt install build-essential libfftw3-dev libc6 libglade2-dev libglib2.0-dev libgtk2.0-dev libjack-jackd2-dev
```
You can likely tweak this if you are on a different distribution. GTKDatabox must still be installed from the source following the instructions above.

## Building

When you first checkout the repo you must first run `./autogen.sh` to generate some Autotools files. If configure.ac or Makefile.am are changed you must run this script again.

Run the traditional `./configure`, `make`, and `make install` to build BRP-PACU.

You can start BRP-PACU with `./BRP-PACU`.

When BRP-PACU is installed on your system using `make install`, the executable is named “BRP_PACU”. It can be started from the Run dialog (that comes up when pressing ALt-F2), or from a command line which will give extra debugging information.

## Usage
See [docs/Usage.md](docs/Usage.md)
