# CiviCRM 4.7.27

Released November 1, 2017

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                     |         |
|:----------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                               |   no    |
| **Change the database schema?**                             | **yes** |
| **Alter the API?**                                          | **yes** |
| **Require attention to configuration options?**             | **yes** |
| Fix problems installing or upgrading to a previous version? |   no    |
| **Introduce features?**                                     | **yes** |
| **Fix bugs?**                                               | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21234](https://issues.civicrm.org/jira/browse/CRM-21234) Missing
  subdivisions of Tajikistan
  ([11041](https://github.com/civicrm/civicrm-core/pull/11041))**

  The list of states and provinces now contains the capital territory and
  districts under republic administration of Tajikistan, which were added to ISO
  3166-2 recently.

- **[CRM-21195](https://issues.civicrm.org/jira/browse/CRM-21195) Adding the
  ability to add icons to menu items
  ([11028](https://github.com/civicrm/civicrm-core/pull/11028),
  [11025](https://github.com/civicrm/civicrm-core/pull/11025), and
  [10996](https://github.com/civicrm/civicrm-core/pull/10996))**

  When editing navigation menu items, you may now choose to display an icon from
  the Font Awesome library.

- **[CRM-21157](https://issues.civicrm.org/jira/browse/CRM-21157) Convert
  civicrm_subscription_history.date to timestamp from datetime for new installs
  ([10954](https://github.com/civicrm/civicrm-core/pull/10954))**

  The group subscription date field will now be created as a timestamp field
  when installing CiviCRM.  Upgrading sites will be left as-is but may use the
  Doctor When utility to convert dates.

- **[CRM-20630](https://issues.civicrm.org/jira/browse/CRM-20630) Find
  Activities: search criteria passing with URL parameters
  ([10957](https://github.com/civicrm/civicrm-core/pull/10957))**

  Query parameters in the Activity Search may now be populated using URL
  parameters along with `force=1`.  This allows a direct link to a listing of a
  subset of activities.

- **[CRM-21086](https://issues.civicrm.org/jira/browse/CRM-21086) Allow Inline
  View of Files Instead of Download
  ([10883](https://github.com/civicrm/civicrm-core/pull/10883))**

  Adding the URL parameter `download=0` to a file link will now display the file
  within the browser rather than downloading it.  This allows for files to be
  rendered inline.

- **[CRM-21170](https://issues.civicrm.org/jira/browse/CRM-21170) Provide option
  to filter by contact id & external id
  ([10966](https://github.com/civicrm/civicrm-core/pull/10966))**

  Contact selection boxes on other entities (such as backend contribution or
  membership forms) now offer the ability to filter by contact ID or external
  identifier.

- **[CRM-21125](https://issues.civicrm.org/jira/browse/CRM-21125) permit class
  assignment on links in reports
  ([10922](https://github.com/civicrm/civicrm-core/pull/10922))**

  Report developers can now set a variable class name for linked fields in
  reports.

- **[CRM-21109](https://issues.civicrm.org/jira/browse/CRM-21109) Creating
  contacts is slow, part 2 of 2: Smart group caching
  ([10943](https://github.com/civicrm/civicrm-core/pull/10943))**

  CSV imports through the command line now clear the smart group cache once per
  import rather than once per line.

### CiviCampaign

- **[CRM-21063](https://issues.civicrm.org/jira/browse/CRM-21063) Survey detail
  report lacks date options
  ([10857](https://github.com/civicrm/civicrm-core/pull/10857)) (partially
  complete)**

  The interview date is now available as a column, filter, and ordering option
  on the Survey Detail report.  However, the date display localization is still
  forthcoming.

### CiviCase

- **[CRM-21182](https://issues.civicrm.org/jira/browse/CRM-21182) Activity API -
  fetch case details
  ([10979](https://github.com/civicrm/civicrm-core/pull/10979))**

  Results of an `Activity.get` API request can now return data about a case that
  the activity is filed to.

- **[CRM-21113](https://issues.civicrm.org/jira/browse/CRM-21113) find cases:
  search by case ID and subject
  ([10911](https://github.com/civicrm/civicrm-core/pull/10911))**

  You can now search by case ID or case subject in the Find Cases and Advanced
  Search forms.  The layout of the case search fields is also modified.

### CiviContribute

- **[CRM-21189](https://issues.civicrm.org/jira/browse/CRM-21189) Add permission
  for Close and reopen Batch
  ([10983](https://github.com/civicrm/civicrm-core/pull/10983))**

  Four new permissions are added to control access to accounting batches:

  - close own manual batches
  - close all manual batches
  - reopen own manual batches
  - reopen own manual batches

  Administrators should consider whether to grant these permissions to users who
  have the "edit all manual batches" or "edit own manual batches" permissions,
  which handled access to close and reopen batches.

- **[CRM-12167](https://issues.civicrm.org/jira/browse/CRM-12167) Add support
  for admin-only fee / price field value options
  ([10902](https://github.com/civicrm/civicrm-core/pull/10902))**

  Individual options within a price field can now be restricted so that they can
  only be chosen by administrators.

- **[CRM-20852](https://issues.civicrm.org/jira/browse/CRM-20852) Show tax term
  in UI (eg. VAT)
  ([10640](https://github.com/civicrm/civicrm-core/pull/10640))**

  The term describing the tax (e.g. "VAT", "HST") is now displayed in
  contribution details when tax is applied.

- **[CRM-20889](https://issues.civicrm.org/jira/browse/CRM-20889) Toggle
  check_number field on backoffice form as payment form fields
  ([10680](https://github.com/civicrm/civicrm-core/pull/10680))**

  Check number now appears as a detail of the payment when paying by check rather than an attribute
  of the contribution as a whole.

- **[CRM-21106](https://issues.civicrm.org/jira/browse/CRM-21106) Move financial
  type ACL clause for reports into extension
  ([10904](https://github.com/civicrm/civicrm-core/pull/10904)) (preliminary
  work)**

  A system check and upgrade message now alert users who use financial type ACLs
  but have not yet installed the "Access Control by Financial Type for Reports"
  extension.  These features will soon be removed from core CiviCRM.

### CiviEvent

- **[CRM-21160](https://issues.civicrm.org/jira/browse/CRM-21160) Make
  event_type_id available in event message templates.
  ([10977](https://github.com/civicrm/civicrm-core/pull/10977))**

  Event message templates now can include `{$event_type_id}` to display the ID
  of the event type.

### CiviMember

- **[CRM-21236](https://issues.civicrm.org/jira/browse/CRM-21236) Make contact
  custom fields available in Membership Detail report
  ([11042](https://github.com/civicrm/civicrm-core/pull/11042))**

  Custom fields about contacts can now be included as columns and filters on the
  Membership Detail report.

### Backdrop Integration

- **[CRM-21217](https://issues.civicrm.org/jira/browse/CRM-21217) Enable E2E
  tests for Backdrop CMS
  ([11021](https://github.com/civicrm/civicrm-core/pull/11021))**

  End-to-end tests now include Backdrop.

### WordPress Integration

- **[CRM-17633](https://issues.civicrm.org/jira/browse/CRM-17633) WordPress in
  own directory breaks CiviCRM
  ([11031](https://github.com/civicrm/civicrm-core/pull/11031) and
  [105](https://github.com/civicrm/civicrm-wordpress/pull/105))**

  CiviCRM now supports a non-default but acceptable WordPress configuration
  where WordPress files are in a subdirectory of the site root.

- **[CRM-21243](https://issues.civicrm.org/jira/browse/CRM-21243) Logo in WP
  menu doesn't follow standard
  ([118](https://github.com/civicrm/civicrm-wordpress/pull/118))**

  The CiviCRM icon in the WordPress left-side menu now is a SVG that adopts the
  appropriate colors as the menu item is highlighted or selected.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21229](https://issues.civicrm.org/jira/browse/CRM-21229) Manage Group
  page is slow if you have smart groups
  ([11033](https://github.com/civicrm/civicrm-core/pull/11033)) (partially
  resolved)**

  The Manage Groups page now will display "Unknown" for the count of smart group
  members where the smart group cache is out of date.  You can click the button
  to regenerate the smart group cache if you want to see the up-to-date counts.

- **[CRM-21247](https://issues.civicrm.org/jira/browse/CRM-21247) User Record
  link (in the Actions section of a contact record summary) is broken
  ([11057](https://github.com/civicrm/civicrm-core/pull/11057))**

  This removes an extraneous `cid=` appended to the user record link.

- **[CRM-21241](https://issues.civicrm.org/jira/browse/CRM-21241) Spinning logo
  is too jumpy ([11046](https://github.com/civicrm/civicrm-core/pull/11046))**

  The CiviCRM logo in the navigation menu has been modified so that it is
  centered on its axis of rotation and spins smoothly.  The spinning logo that
  appears while pop-up windows load now is the actual CiviCRM logo and spins
  more slowly and smoothly.

- **[CRM-21110](https://issues.civicrm.org/jira/browse/CRM-21110) Relationships
  tab on contact summary runs query twice
  ([11009](https://github.com/civicrm/civicrm-core/pull/11009)) (improvement on
  previous resolution)**

  This further simplifies the query to get a contact's total number of
  relationships.

- **[CRM-21223](https://issues.civicrm.org/jira/browse/CRM-21223) Number and
  Money fields are not set to NULL in the database
  ([11037](https://github.com/civicrm/civicrm-core/pull/11037)) (preliminary
  work)**

  This adds tests to diagnose the handling of null default values for certain
  fields in the database.

- **[CRM-21227](https://issues.civicrm.org/jira/browse/CRM-21227) Fix issues in
  CRM_Core_Page_run test suite following merge of PR #10435
  ([11032](https://github.com/civicrm/civicrm-core/pull/11032))**

  This fixes some places where PHP notices would appear because keys had been
  presumed to be set in certain arrays of default values.

- **[CRM-21202](https://issues.civicrm.org/jira/browse/CRM-21202) DataTables
  warning: table id=dupePairs
  ([11004](https://github.com/civicrm/civicrm-core/pull/11004))**

  This prevents a warning that would pop up after batch merge of duplicates has
  run.

- **[CRM-16836](https://issues.civicrm.org/jira/browse/CRM-16836) Basic Search
  form group select does not respect ACLs
  ([11013](https://github.com/civicrm/civicrm-core/pull/11013))**

- **[CRM-21178](https://issues.civicrm.org/jira/browse/CRM-21178) Custom fields
  of type "Link" are no longer clickable
  ([10985](https://github.com/civicrm/civicrm-core/pull/10985))**

- **[CRM-21169](https://issues.civicrm.org/jira/browse/CRM-21169) Fix broken
  inline edit for profiles
  ([10964](https://github.com/civicrm/civicrm-core/pull/10964))**

  A Javascript error due to a function removed from jQuery UI caused the whole
  inline profile edit interface to break.

- **[CRM-21172](https://issues.civicrm.org/jira/browse/CRM-21172) Fix 'Edit
  Contact Information' link on contact dashboard
  ([10969](https://github.com/civicrm/civicrm-core/pull/10969))**

  A fatal exception would occur when clicking "Edit Contact Information" on a
  related contact in the user dashboard.

- **[CRM-20217](https://issues.civicrm.org/jira/browse/CRM-20217) phone based
  dedupe rule fails to match when importing
  ([9925](https://github.com/civicrm/civicrm-core/pull/9925))**

- **[CRM-16964](https://issues.civicrm.org/jira/browse/CRM-16964) Importing
  contact custom data doesn't respect the Fill option
  ([10838](https://github.com/civicrm/civicrm-core/pull/10838))**

  Custom fields with values would be overwritten by imported values even when
  the import is using the Fill mode for matched contacts.

- **[CRM-21330](https://issues.civicrm.org/jira/browse/CRM-21330) Create
  Activity gives fatal error on dmaster
  ([11157](https://github.com/civicrm/civicrm-core/pull/11157))**

- **[CRM-21267](https://issues.civicrm.org/jira/browse/CRM-21267) Error 500 -
  Call to undefined method CRM_Contact_Import_Parser::formatCustomDate
  ([11143](https://github.com/civicrm/civicrm-core/pull/11143))**

### CiviCase

- **[CRM-21114](https://issues.civicrm.org/jira/browse/CRM-21114) file to case
  doesn't transfer activity assignees
  ([10912](https://github.com/civicrm/civicrm-core/pull/10912))**

### CiviContribute

- **[CRM-21201](https://issues.civicrm.org/jira/browse/CRM-21201) Tax
  recalculated when pay later contribution is completed using Pay Now
  ([11026](https://github.com/civicrm/civicrm-core/pull/11026))**

  This resolves a problem when tax would be recalculated and tacked onto the
  amount due during the course of completing pay-later contributions.

- **[CRM-21205](https://issues.civicrm.org/jira/browse/CRM-21205) batch list
  does not display accurate currency
  ([11008](https://github.com/civicrm/civicrm-core/pull/11008))**

  Transactions listed in financial batches now display the specific
  transaction's currency rather than the default system currency.

- **[CRM-20276](https://issues.civicrm.org/jira/browse/CRM-20276) When editing a
  contribution the value in civicrm_financial_item_amount is not updated
  ([10970](https://github.com/civicrm/civicrm-core/pull/10970))**

- **[CRM-21220](https://issues.civicrm.org/jira/browse/CRM-21220) Invoice due
  date format spacing correction
  ([11024](https://github.com/civicrm/civicrm-core/pull/11024))**

- **[CRM-21199](https://issues.civicrm.org/jira/browse/CRM-21199) Remove
  dependancy for  'Default invoice payment page'
  ([11003](https://github.com/civicrm/civicrm-core/pull/11003))**

  The option to choose a default invoice payment page is no longer obscured if
  deferred revenue is disabled.

- **[CRM-21038](https://issues.civicrm.org/jira/browse/CRM-21038) Billing and CC
  fields shown when payment processor not selected.
  ([10826](https://github.com/civicrm/civicrm-core/pull/10826))**

  Contribution pages may have price sets where no option is selected by default.
  In this case, when the total contribution is zero, no payment processor is
  selected.  However, a bug would display credit card and billing address fields
  incorrectly.  This change resolves this bug.

- **[CRM-18367](https://issues.civicrm.org/jira/browse/CRM-18367) Fatal error on
  Contribution logging summary report (possibly remove - see comment)
  ([10987](https://github.com/civicrm/civicrm-core/pull/10987))**

  The Contribute Logging Report--both summary and detail--have been removed
  because they have not worked properly for years.

- **[CRM-20999](https://issues.civicrm.org/jira/browse/CRM-20999) Multiple
  elements share same id `auto_renew` value on live contribution page.
  ([10834](https://github.com/civicrm/civicrm-core/pull/10834))**

- **[CRM-21134](https://issues.civicrm.org/jira/browse/CRM-21134) e-notice
  errors when using a processor extension
  ([10935](https://github.com/civicrm/civicrm-core/pull/10935))**

  In some circumstances, PHP notices for undefined indexes would appear due to
  parameter names that were presumed to exist.

- **[CRM-21221](https://issues.civicrm.org/jira/browse/CRM-21221) Precedence
  order logic bug in Contribution.completetransaction
  ([11027](https://github.com/civicrm/civicrm-core/pull/11027))**

  This resolves a bug that was unlikely to cause real-life problems but could
  theoretically cause false failures of the `Contribution.completetransaction`
  API.

- **[CRM-20750](https://issues.civicrm.org/jira/browse/CRM-20750) Incorrect
  financial trxn entries when payment instrument is changed on backoffice
  Contribution edit form
  ([10980](https://github.com/civicrm/civicrm-core/pull/10980) and
  [10920](https://github.com/civicrm/civicrm-core/pull/10920))**

- **[CRM-21187](https://issues.civicrm.org/jira/browse/CRM-21187) Fix:
  Completing an existing contribution using completetransaction does not respect
  currency on financial_trxn record
  ([10982](https://github.com/civicrm/civicrm-core/pull/10982))**

  This resolves a bug where payments made against pending contributions would
  arrive as the default currency rather than the currency specified by the
  transaction.

### CiviEvent

- **[CRM-21196](https://issues.civicrm.org/jira/browse/CRM-21196) Event reports
  localization ([10997](https://github.com/civicrm/civicrm-core/pull/10997))**

  A number of previously unhandled strings are now sent through translation.

- **[CRM-20657](https://issues.civicrm.org/jira/browse/CRM-20657) Multiple
  events purchased from webform lists only single participant details in mail
  received ([10439](https://github.com/civicrm/civicrm-core/pull/10439))**

  The Participant BAO didn't accurately handle event registrations with multiple
  top-level participants.

- **[CRM-21127](https://issues.civicrm.org/jira/browse/CRM-21127) Event API
  return request params format is partially outdated
  ([10984](https://github.com/civicrm/civicrm-core/pull/10984))**

  The Event API would expect an old format for specifying the fields to return.

- **[CRM-21133](https://issues.civicrm.org/jira/browse/CRM-21133) Price set
  error with NULL financial types
  ([10947](https://github.com/civicrm/civicrm-core/pull/10947))**

  This resolves a bug where the newly-created price set's financial type would
  be set to `NULL` when converting an event's registration options to a price
  set.  This would cause the price set to be missing when managing the event.

### CiviGrant

- **[CRM-20460](https://issues.civicrm.org/jira/browse/CRM-20460) Grant Report
  incorrect where clause
  ([11036](https://github.com/civicrm/civicrm-core/pull/11036))**

### CiviMail

- **[CRM-20892](https://issues.civicrm.org/jira/browse/CRM-20892) Same mailing
  open in two windows can overwrite data on scheduled mailings
  ([11211](https://github.com/civicrm/civicrm-core/pull/11211) and
  [10953](https://github.com/civicrm/civicrm-core/pull/10953))**

  A new `modified_date` prevents a CiviMail window from saving mailing data if
  the mailing has been saved (in another tab or by another user) since the
  window loaded the mailing information.

### CiviMember

- **[CRM-20636](https://issues.civicrm.org/jira/browse/CRM-20636) Notice fix
  while updating membership without payment
  ([10412](https://github.com/civicrm/civicrm-core/pull/10412))**

  This prevents a PHP notice from appearing when updating a membership with no
  payments.

- **[CRM-15861](https://issues.civicrm.org/jira/browse/CRM-15861) Offline
  membership renewal doesn't display priceset choices
  ([10887](https://github.com/civicrm/civicrm-core/pull/10887)) (preliminary
  work)**

  This consolidates some code for choosing the default membership type.

- **[CRM-21198](https://issues.civicrm.org/jira/browse/CRM-21198) Completing
  payment for partially paid membership doesn't change membership status
  ([11006](https://github.com/civicrm/civicrm-core/pull/11006))**

- **[CRM-21183](https://issues.civicrm.org/jira/browse/CRM-21183) Updating
  Partially paid contribution to Completed doesn't update membership
  ([10981](https://github.com/civicrm/civicrm-core/pull/10981))**

- **[CRM-21117](https://issues.civicrm.org/jira/browse/CRM-21117) Line item not
  shown in mails when paying later for membership priceset
  ([10978](https://github.com/civicrm/civicrm-core/pull/10978))**

- **[CRM-20881](https://issues.civicrm.org/jira/browse/CRM-20881) Backend
  Membership status set to pending if contribution status label 'Completed' is
  renamed ([10670](https://github.com/civicrm/civicrm-core/pull/10670))**

- **[CRM-21314](https://issues.civicrm.org/jira/browse/CRM-21314) Credit card
  block missing from membership payment form
  ([11140](https://github.com/civicrm/civicrm-core/pull/11140))**

### Drupal Integration

- **[CRM-21156](https://issues.civicrm.org/jira/browse/CRM-21156) CiviCRM Rules
  does not show all available Groups
  ([478](https://github.com/civicrm/civicrm-drupal/pull/478))**

  The list of CiviCRM groups available in the Rules module was limited to 25.

- **[CRM-20937](https://issues.civicrm.org/jira/browse/CRM-20937) civicrm engage
  breaks birth date field
  ([464](https://github.com/civicrm/civicrm-drupal/pull/464))**

  The CiviEngage module ships with template overrides, and outdated templates
  broke the birth date field.

### Joomla Integration

- **[CRM-21300](https://issues.civicrm.org/jira/browse/CRM-21300) Joomla: Trying
  to get property of non-object in CRM/Core/Permission/Joomla.php
  ([11135](https://github.com/civicrm/civicrm-core/pull/11135))**

  This resolves an error that would appear due to the database object bing
  `null` in some cases.

### WordPress Integration

- **[CRM-21168](https://issues.civicrm.org/jira/browse/CRM-21168) WordPress
  plugin wiki/support links are incorrect
  ([116](https://github.com/civicrm/civicrm-wordpress/pull/116))**

- **[CRM-21166](https://issues.civicrm.org/jira/browse/CRM-21166) WP-CLI
  commands fail due to whitespace in regex
  ([115](https://github.com/civicrm/civicrm-wordpress/pull/115))**

## <a name="misc"></a>Miscellany

- **[CRM-21216](https://issues.civicrm.org/jira/browse/CRM-21216) Replace
  member_BAO_membershiptype_getMembershipTypesByOrg with API equivalent
  ([11029](https://github.com/civicrm/civicrm-core/pull/11029) and
  [11020](https://github.com/civicrm/civicrm-core/pull/11020))**

- **[CRM-20226](https://issues.civicrm.org/jira/browse/CRM-20226) Parent Group
  do not inherit child group contacts
  ([11011](https://github.com/civicrm/civicrm-core/pull/11011)) (follow-up
  work)**

  Comments were added to the code.

- **Fixing type (missing function call) in example for hook_civicrm_alterAngular
  ([10952](https://github.com/civicrm/civicrm-core/pull/10952))**

- **[NFC] comments clean up in test classes.
  ([10963](https://github.com/civicrm/civicrm-core/pull/10963))**

- **templates/CRM/PCP/Form/Campaign.tpl: remove comment (not relevant).
  ([10959](https://github.com/civicrm/civicrm-core/pull/10959))**

- **Correct spelling.
  ([10955](https://github.com/civicrm/civicrm-core/pull/10955))**

- **Civilint civicrm_og_sync module
  ([489](https://github.com/civicrm/civicrm-drupal/pull/489))**

- **Civilint civicrm_user.inc
  ([490](https://github.com/civicrm/civicrm-drupal/pull/490))**

- **Lint CiviCRM Rules module
  ([477](https://github.com/civicrm/civicrm-drupal/pull/477))**

- **Remove CiviTest.module.sample as been replaced with the CiviCRM Dev Docs
  ([492](https://github.com/civicrm/civicrm-drupal/pull/492))**

- **NFC Civilint civicrm_group_roles module
  ([479](https://github.com/civicrm/civicrm-drupal/pull/479))**

- **Run Civilint against first half of civicrm_handler_field files
  ([485](https://github.com/civicrm/civicrm-drupal/pull/485))**

- **Civilint views plugins files
  ([483](https://github.com/civicrm/civicrm-drupal/pull/483))**

- **Lint Civitheme module
  ([475](https://github.com/civicrm/civicrm-drupal/pull/475))**

- **Civilint civicrm_handler_field_website.inc
  ([484](https://github.com/civicrm/civicrm-drupal/pull/484))**

- **(NFC) Lint civicrm.config.php.drupal
  ([474](https://github.com/civicrm/civicrm-drupal/pull/474))**

- **Civilint Some views files and HookTest file
  ([476](https://github.com/civicrm/civicrm-drupal/pull/476))**

- **NFC Civilint civicrm_member_roles
  ([480](https://github.com/civicrm/civicrm-drupal/pull/480))**

- **NFC Civilint civicrm_contact_ref module
  ([481](https://github.com/civicrm/civicrm-drupal/pull/481))**

- **[CRM-21315](https://issues.civicrm.org/jira/browse/CRM-21315) (intra-rc
  regression) pay_later processor showing up in list of available processors
  ([11141](https://github.com/civicrm/civicrm-core/pull/11141))**

- **[CRM-21285](https://issues.civicrm.org/jira/browse/CRM-21285) Buildkit
  Installs failing for WordPress
  ([11112](https://github.com/civicrm/civicrm-core/pull/11112) and
  [11105](https://github.com/civicrm/civicrm-core/pull/11105))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel; Australian
Greens - Seamus Lee; Blackfly Solutions - Alan Dixon; Chris Burgess; Circle
Interactive - Dave Jenkins; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Sunil
Pawar, Yashodha Chaku; CompuCorp - Camilo Rodriguez, Kacper Warda, Michael
Devery, Omar Abu Hussein; Coop SymbioTIC - Mathieu Lutfy; Eli Lisseck; Francesc
Bassas i Bullich; Fuzion - Jitendra Purohit; Ginkgo Street Labs - Frank Gómez;
JMA Consulting - Monish Deb, Pradeep Nayak; Left Join Labs - Sean Madsen;
Lighthouse Design and Consulting - Brian Shaughnessy; MJW Consulting - Matthew
Wire; Pawel Nowak; Progressive Technology Project - Jamie McClelland; Skvare -
Mark Hanna; Tadpole Collective - Kevin Cristiano; Third Sector Design - Michael
McAndrew; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Adam Zilkie; Agileware - Agileware Team; Artful Robot - Rich Lott; Christian
Wach; Circle Interactive - Martin Castle; CiviDesk - Nicolas Ganivet; Coop
SymbioTIC - Guillaume Boudrias, Samuel Vanhove; Custom Websites to Go - Julie
Hall; CYIM - Matthias de Mauroy; Dave Greenberg; Freeform Solutions - Herb van
den Dool; JMA Consulting - Joe Murray; John Kingsnorth; Joinery - Allen Shaw;
Joseph Lacey; Korlon - Stuart Gaston; Marc Brazeau; MC3 - Graham Mitchell;
Megaphone Technology Consulting - Jon Goldberg; Mohamed Ziada; Olivier Tétard;
Openflows - Eric Goldhagen; Semper IT - Karin Gerritsen; Web Access - Kurund
Jalmi; XIMA - Philipp Michael

## <a name="feedback"></a>Feedback

These release notes are edited by Andrew Hunt.  If you'd like to provide
feedback on them, please login to https://chat.civicrm.org/civicrm and contact
`@agh1`.
