//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FavoriteProcessesClient contains the methods for the FavoriteProcesses group.
// Don't use this type directly, use NewFavoriteProcessesClient() instead.
type FavoriteProcessesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewFavoriteProcessesClient creates a new instance of FavoriteProcessesClient with the specified values.
// subscriptionID - The Azure subscription ID. This is a GUID-formatted string.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewFavoriteProcessesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FavoriteProcessesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &FavoriteProcessesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Create - Create or replace a favorite process for a Test Base Package.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
// that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
// name.
// parameters - Parameters supplied to create a favorite process in a package.
// options - FavoriteProcessesClientCreateOptions contains the optional parameters for the FavoriteProcessesClient.Create
// method.
func (client *FavoriteProcessesClient) Create(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, parameters FavoriteProcessResource, options *FavoriteProcessesClientCreateOptions) (FavoriteProcessesClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, parameters, options)
	if err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return FavoriteProcessesClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *FavoriteProcessesClient) createCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, parameters FavoriteProcessResource, options *FavoriteProcessesClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createHandleResponse handles the Create response.
func (client *FavoriteProcessesClient) createHandleResponse(resp *http.Response) (FavoriteProcessesClientCreateResponse, error) {
	result := FavoriteProcessesClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessResource); err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a favorite process for a specific package.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
// that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
// name.
// options - FavoriteProcessesClientDeleteOptions contains the optional parameters for the FavoriteProcessesClient.Delete
// method.
func (client *FavoriteProcessesClient) Delete(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientDeleteOptions) (FavoriteProcessesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, options)
	if err != nil {
		return FavoriteProcessesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FavoriteProcessesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return FavoriteProcessesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return FavoriteProcessesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FavoriteProcessesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a favorite process for a Test Base Package.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
// that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
// name.
// options - FavoriteProcessesClientGetOptions contains the optional parameters for the FavoriteProcessesClient.Get method.
func (client *FavoriteProcessesClient) Get(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientGetOptions) (FavoriteProcessesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, options)
	if err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return FavoriteProcessesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *FavoriteProcessesClient) getCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FavoriteProcessesClient) getHandleResponse(resp *http.Response) (FavoriteProcessesClientGetResponse, error) {
	result := FavoriteProcessesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessResource); err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the favorite processes for a specific package.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// options - FavoriteProcessesClientListOptions contains the optional parameters for the FavoriteProcessesClient.List method.
func (client *FavoriteProcessesClient) NewListPager(resourceGroupName string, testBaseAccountName string, packageName string, options *FavoriteProcessesClientListOptions) *runtime.Pager[FavoriteProcessesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FavoriteProcessesClientListResponse]{
		More: func(page FavoriteProcessesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FavoriteProcessesClientListResponse) (FavoriteProcessesClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return FavoriteProcessesClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FavoriteProcessesClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FavoriteProcessesClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *FavoriteProcessesClient) listCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *FavoriteProcessesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *FavoriteProcessesClient) listHandleResponse(resp *http.Response) (FavoriteProcessesClientListResponse, error) {
	result := FavoriteProcessesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessListResult); err != nil {
		return FavoriteProcessesClientListResponse{}, err
	}
	return result, nil
}
