// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/model_deployment_monitoring_job.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The Model Monitoring Objective types.
type ModelDeploymentMonitoringObjectiveType int32

const (
	// Default value, should not be set.
	ModelDeploymentMonitoringObjectiveType_MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED ModelDeploymentMonitoringObjectiveType = 0
	// Raw feature values' stats to detect skew between Training-Prediction
	// datasets.
	ModelDeploymentMonitoringObjectiveType_RAW_FEATURE_SKEW ModelDeploymentMonitoringObjectiveType = 1
	// Raw feature values' stats to detect drift between Serving-Prediction
	// datasets.
	ModelDeploymentMonitoringObjectiveType_RAW_FEATURE_DRIFT ModelDeploymentMonitoringObjectiveType = 2
	// Feature attribution scores to detect skew between Training-Prediction
	// datasets.
	ModelDeploymentMonitoringObjectiveType_FEATURE_ATTRIBUTION_SKEW ModelDeploymentMonitoringObjectiveType = 3
	// Feature attribution scores to detect skew between Prediction datasets
	// collected within different time windows.
	ModelDeploymentMonitoringObjectiveType_FEATURE_ATTRIBUTION_DRIFT ModelDeploymentMonitoringObjectiveType = 4
)

// Enum value maps for ModelDeploymentMonitoringObjectiveType.
var (
	ModelDeploymentMonitoringObjectiveType_name = map[int32]string{
		0: "MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED",
		1: "RAW_FEATURE_SKEW",
		2: "RAW_FEATURE_DRIFT",
		3: "FEATURE_ATTRIBUTION_SKEW",
		4: "FEATURE_ATTRIBUTION_DRIFT",
	}
	ModelDeploymentMonitoringObjectiveType_value = map[string]int32{
		"MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED": 0,
		"RAW_FEATURE_SKEW":          1,
		"RAW_FEATURE_DRIFT":         2,
		"FEATURE_ATTRIBUTION_SKEW":  3,
		"FEATURE_ATTRIBUTION_DRIFT": 4,
	}
)

func (x ModelDeploymentMonitoringObjectiveType) Enum() *ModelDeploymentMonitoringObjectiveType {
	p := new(ModelDeploymentMonitoringObjectiveType)
	*p = x
	return p
}

func (x ModelDeploymentMonitoringObjectiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelDeploymentMonitoringObjectiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[0].Descriptor()
}

func (ModelDeploymentMonitoringObjectiveType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[0]
}

func (x ModelDeploymentMonitoringObjectiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelDeploymentMonitoringObjectiveType.Descriptor instead.
func (ModelDeploymentMonitoringObjectiveType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{0}
}

// The state to Specify the monitoring pipeline.
type ModelDeploymentMonitoringJob_MonitoringScheduleState int32

const (
	// Unspecified state.
	ModelDeploymentMonitoringJob_MONITORING_SCHEDULE_STATE_UNSPECIFIED ModelDeploymentMonitoringJob_MonitoringScheduleState = 0
	// The pipeline is picked up and wait to run.
	ModelDeploymentMonitoringJob_PENDING ModelDeploymentMonitoringJob_MonitoringScheduleState = 1
	// The pipeline is offline and will be scheduled for next run.
	ModelDeploymentMonitoringJob_OFFLINE ModelDeploymentMonitoringJob_MonitoringScheduleState = 2
	// The pipeline is running.
	ModelDeploymentMonitoringJob_RUNNING ModelDeploymentMonitoringJob_MonitoringScheduleState = 3
)

// Enum value maps for ModelDeploymentMonitoringJob_MonitoringScheduleState.
var (
	ModelDeploymentMonitoringJob_MonitoringScheduleState_name = map[int32]string{
		0: "MONITORING_SCHEDULE_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "OFFLINE",
		3: "RUNNING",
	}
	ModelDeploymentMonitoringJob_MonitoringScheduleState_value = map[string]int32{
		"MONITORING_SCHEDULE_STATE_UNSPECIFIED": 0,
		"PENDING":                               1,
		"OFFLINE":                               2,
		"RUNNING":                               3,
	}
)

func (x ModelDeploymentMonitoringJob_MonitoringScheduleState) Enum() *ModelDeploymentMonitoringJob_MonitoringScheduleState {
	p := new(ModelDeploymentMonitoringJob_MonitoringScheduleState)
	*p = x
	return p
}

func (x ModelDeploymentMonitoringJob_MonitoringScheduleState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelDeploymentMonitoringJob_MonitoringScheduleState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[1].Descriptor()
}

func (ModelDeploymentMonitoringJob_MonitoringScheduleState) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[1]
}

func (x ModelDeploymentMonitoringJob_MonitoringScheduleState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelDeploymentMonitoringJob_MonitoringScheduleState.Descriptor instead.
func (ModelDeploymentMonitoringJob_MonitoringScheduleState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{0, 0}
}

// Indicates where does the log come from.
type ModelDeploymentMonitoringBigQueryTable_LogSource int32

const (
	// Unspecified source.
	ModelDeploymentMonitoringBigQueryTable_LOG_SOURCE_UNSPECIFIED ModelDeploymentMonitoringBigQueryTable_LogSource = 0
	// Logs coming from Training dataset.
	ModelDeploymentMonitoringBigQueryTable_TRAINING ModelDeploymentMonitoringBigQueryTable_LogSource = 1
	// Logs coming from Serving traffic.
	ModelDeploymentMonitoringBigQueryTable_SERVING ModelDeploymentMonitoringBigQueryTable_LogSource = 2
)

// Enum value maps for ModelDeploymentMonitoringBigQueryTable_LogSource.
var (
	ModelDeploymentMonitoringBigQueryTable_LogSource_name = map[int32]string{
		0: "LOG_SOURCE_UNSPECIFIED",
		1: "TRAINING",
		2: "SERVING",
	}
	ModelDeploymentMonitoringBigQueryTable_LogSource_value = map[string]int32{
		"LOG_SOURCE_UNSPECIFIED": 0,
		"TRAINING":               1,
		"SERVING":                2,
	}
)

func (x ModelDeploymentMonitoringBigQueryTable_LogSource) Enum() *ModelDeploymentMonitoringBigQueryTable_LogSource {
	p := new(ModelDeploymentMonitoringBigQueryTable_LogSource)
	*p = x
	return p
}

func (x ModelDeploymentMonitoringBigQueryTable_LogSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelDeploymentMonitoringBigQueryTable_LogSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[2].Descriptor()
}

func (ModelDeploymentMonitoringBigQueryTable_LogSource) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[2]
}

func (x ModelDeploymentMonitoringBigQueryTable_LogSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelDeploymentMonitoringBigQueryTable_LogSource.Descriptor instead.
func (ModelDeploymentMonitoringBigQueryTable_LogSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{1, 0}
}

// Indicates what type of traffic does the log belong to.
type ModelDeploymentMonitoringBigQueryTable_LogType int32

const (
	// Unspecified type.
	ModelDeploymentMonitoringBigQueryTable_LOG_TYPE_UNSPECIFIED ModelDeploymentMonitoringBigQueryTable_LogType = 0
	// Predict logs.
	ModelDeploymentMonitoringBigQueryTable_PREDICT ModelDeploymentMonitoringBigQueryTable_LogType = 1
	// Explain logs.
	ModelDeploymentMonitoringBigQueryTable_EXPLAIN ModelDeploymentMonitoringBigQueryTable_LogType = 2
)

// Enum value maps for ModelDeploymentMonitoringBigQueryTable_LogType.
var (
	ModelDeploymentMonitoringBigQueryTable_LogType_name = map[int32]string{
		0: "LOG_TYPE_UNSPECIFIED",
		1: "PREDICT",
		2: "EXPLAIN",
	}
	ModelDeploymentMonitoringBigQueryTable_LogType_value = map[string]int32{
		"LOG_TYPE_UNSPECIFIED": 0,
		"PREDICT":              1,
		"EXPLAIN":              2,
	}
)

func (x ModelDeploymentMonitoringBigQueryTable_LogType) Enum() *ModelDeploymentMonitoringBigQueryTable_LogType {
	p := new(ModelDeploymentMonitoringBigQueryTable_LogType)
	*p = x
	return p
}

func (x ModelDeploymentMonitoringBigQueryTable_LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelDeploymentMonitoringBigQueryTable_LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[3].Descriptor()
}

func (ModelDeploymentMonitoringBigQueryTable_LogType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes[3]
}

func (x ModelDeploymentMonitoringBigQueryTable_LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelDeploymentMonitoringBigQueryTable_LogType.Descriptor instead.
func (ModelDeploymentMonitoringBigQueryTable_LogType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{1, 1}
}

// Represents a job that runs periodically to monitor the deployed models in an
// endpoint. It will analyze the logged training & prediction data to detect any
// abnormal behaviors.
type ModelDeploymentMonitoringJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of a ModelDeploymentMonitoringJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-defined name of the ModelDeploymentMonitoringJob.
	// The name can be up to 128 characters long and can be consist of any UTF-8
	// characters.
	// Display name of a ModelDeploymentMonitoringJob.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Endpoint resource name.
	// Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The detailed state of the monitoring job.
	// When the job is still creating, the state will be 'PENDING'.
	// Once the job is successfully created, the state will be 'RUNNING'.
	// Pause the job, the state will be 'PAUSED'.
	// Resume the job, the state will return to 'RUNNING'.
	State JobState `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"state,omitempty"`
	// Output only. Schedule state when the monitoring job is in Running state.
	ScheduleState ModelDeploymentMonitoringJob_MonitoringScheduleState `protobuf:"varint,5,opt,name=schedule_state,json=scheduleState,proto3,enum=google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob_MonitoringScheduleState" json:"schedule_state,omitempty"`
	// Required. The config for monitoring objectives. This is a per DeployedModel config.
	// Each DeployedModel needs to be configed separately.
	ModelDeploymentMonitoringObjectiveConfigs []*ModelDeploymentMonitoringObjectiveConfig `protobuf:"bytes,6,rep,name=model_deployment_monitoring_objective_configs,json=modelDeploymentMonitoringObjectiveConfigs,proto3" json:"model_deployment_monitoring_objective_configs,omitempty"`
	// Required. Schedule config for running the monitoring job.
	ModelDeploymentMonitoringScheduleConfig *ModelDeploymentMonitoringScheduleConfig `protobuf:"bytes,7,opt,name=model_deployment_monitoring_schedule_config,json=modelDeploymentMonitoringScheduleConfig,proto3" json:"model_deployment_monitoring_schedule_config,omitempty"`
	// Required. Sample Strategy for logging.
	LoggingSamplingStrategy *SamplingStrategy `protobuf:"bytes,8,opt,name=logging_sampling_strategy,json=loggingSamplingStrategy,proto3" json:"logging_sampling_strategy,omitempty"`
	// Alert config for model monitoring.
	ModelMonitoringAlertConfig *ModelMonitoringAlertConfig `protobuf:"bytes,15,opt,name=model_monitoring_alert_config,json=modelMonitoringAlertConfig,proto3" json:"model_monitoring_alert_config,omitempty"`
	// YAML schema file uri describing the format of a single instance,
	// which are given to format this Endpoint's prediction (and explanation).
	// If not set, we will generate predict schema from collected predict
	// requests.
	PredictInstanceSchemaUri string `protobuf:"bytes,9,opt,name=predict_instance_schema_uri,json=predictInstanceSchemaUri,proto3" json:"predict_instance_schema_uri,omitempty"`
	// Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
	// this can be set as a replacement of
	// [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
	// we will generate predict schema from collected predict requests.
	SamplePredictInstance *structpb.Value `protobuf:"bytes,19,opt,name=sample_predict_instance,json=samplePredictInstance,proto3" json:"sample_predict_instance,omitempty"`
	// YAML schema file uri describing the format of a single instance that you
	// want Tensorflow Data Validation (TFDV) to analyze.
	//
	// If this field is empty, all the feature data types are inferred from
	// [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
	// meaning that TFDV will use the data in the exact format(data type) as
	// prediction request/response.
	// If there are any data type differences between predict instance and TFDV
	// instance, this field can be used to override the schema.
	// For models trained with Vertex AI, this field must be set as all the
	// fields in predict instance formatted as string.
	AnalysisInstanceSchemaUri string `protobuf:"bytes,16,opt,name=analysis_instance_schema_uri,json=analysisInstanceSchemaUri,proto3" json:"analysis_instance_schema_uri,omitempty"`
	// Output only. The created bigquery tables for the job under customer project. Customer
	// could do their own query & analysis. There could be 4 log tables in
	// maximum:
	// 1. Training data logging predict request/response
	// 2. Serving data logging predict request/response
	BigqueryTables []*ModelDeploymentMonitoringBigQueryTable `protobuf:"bytes,10,rep,name=bigquery_tables,json=bigqueryTables,proto3" json:"bigquery_tables,omitempty"`
	// The TTL of BigQuery tables in user projects which stores logs.
	// A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
	// day). e.g. { second: 3600} indicates ttl = 1 day.
	LogTtl *durationpb.Duration `protobuf:"bytes,17,opt,name=log_ttl,json=logTtl,proto3" json:"log_ttl,omitempty"`
	// The labels with user-defined metadata to organize your
	// ModelDeploymentMonitoringJob.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
	// next round.
	NextScheduleTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=next_schedule_time,json=nextScheduleTime,proto3" json:"next_schedule_time,omitempty"`
	// Stats anomalies base folder path.
	StatsAnomaliesBaseDirectory *GcsDestination `protobuf:"bytes,20,opt,name=stats_anomalies_base_directory,json=statsAnomaliesBaseDirectory,proto3" json:"stats_anomalies_base_directory,omitempty"`
}

func (x *ModelDeploymentMonitoringJob) Reset() {
	*x = ModelDeploymentMonitoringJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelDeploymentMonitoringJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelDeploymentMonitoringJob) ProtoMessage() {}

func (x *ModelDeploymentMonitoringJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelDeploymentMonitoringJob.ProtoReflect.Descriptor instead.
func (*ModelDeploymentMonitoringJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{0}
}

func (x *ModelDeploymentMonitoringJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModelDeploymentMonitoringJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ModelDeploymentMonitoringJob) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *ModelDeploymentMonitoringJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *ModelDeploymentMonitoringJob) GetScheduleState() ModelDeploymentMonitoringJob_MonitoringScheduleState {
	if x != nil {
		return x.ScheduleState
	}
	return ModelDeploymentMonitoringJob_MONITORING_SCHEDULE_STATE_UNSPECIFIED
}

func (x *ModelDeploymentMonitoringJob) GetModelDeploymentMonitoringObjectiveConfigs() []*ModelDeploymentMonitoringObjectiveConfig {
	if x != nil {
		return x.ModelDeploymentMonitoringObjectiveConfigs
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetModelDeploymentMonitoringScheduleConfig() *ModelDeploymentMonitoringScheduleConfig {
	if x != nil {
		return x.ModelDeploymentMonitoringScheduleConfig
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetLoggingSamplingStrategy() *SamplingStrategy {
	if x != nil {
		return x.LoggingSamplingStrategy
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetModelMonitoringAlertConfig() *ModelMonitoringAlertConfig {
	if x != nil {
		return x.ModelMonitoringAlertConfig
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetPredictInstanceSchemaUri() string {
	if x != nil {
		return x.PredictInstanceSchemaUri
	}
	return ""
}

func (x *ModelDeploymentMonitoringJob) GetSamplePredictInstance() *structpb.Value {
	if x != nil {
		return x.SamplePredictInstance
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetAnalysisInstanceSchemaUri() string {
	if x != nil {
		return x.AnalysisInstanceSchemaUri
	}
	return ""
}

func (x *ModelDeploymentMonitoringJob) GetBigqueryTables() []*ModelDeploymentMonitoringBigQueryTable {
	if x != nil {
		return x.BigqueryTables
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetLogTtl() *durationpb.Duration {
	if x != nil {
		return x.LogTtl
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetNextScheduleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextScheduleTime
	}
	return nil
}

func (x *ModelDeploymentMonitoringJob) GetStatsAnomaliesBaseDirectory() *GcsDestination {
	if x != nil {
		return x.StatsAnomaliesBaseDirectory
	}
	return nil
}

// ModelDeploymentMonitoringBigQueryTable specifies the BigQuery table name
// as well as some information of the logs stored in this table.
type ModelDeploymentMonitoringBigQueryTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of log.
	LogSource ModelDeploymentMonitoringBigQueryTable_LogSource `protobuf:"varint,1,opt,name=log_source,json=logSource,proto3,enum=google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable_LogSource" json:"log_source,omitempty"`
	// The type of log.
	LogType ModelDeploymentMonitoringBigQueryTable_LogType `protobuf:"varint,2,opt,name=log_type,json=logType,proto3,enum=google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable_LogType" json:"log_type,omitempty"`
	// The created BigQuery table to store logs. Customer could do their own query
	// & analysis. Format:
	// `bq://<project_id>.model_deployment_monitoring_<endpoint_id>.<tolower(log_source)>_<tolower(log_type)>`
	BigqueryTablePath string `protobuf:"bytes,3,opt,name=bigquery_table_path,json=bigqueryTablePath,proto3" json:"bigquery_table_path,omitempty"`
}

func (x *ModelDeploymentMonitoringBigQueryTable) Reset() {
	*x = ModelDeploymentMonitoringBigQueryTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelDeploymentMonitoringBigQueryTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelDeploymentMonitoringBigQueryTable) ProtoMessage() {}

func (x *ModelDeploymentMonitoringBigQueryTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelDeploymentMonitoringBigQueryTable.ProtoReflect.Descriptor instead.
func (*ModelDeploymentMonitoringBigQueryTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{1}
}

func (x *ModelDeploymentMonitoringBigQueryTable) GetLogSource() ModelDeploymentMonitoringBigQueryTable_LogSource {
	if x != nil {
		return x.LogSource
	}
	return ModelDeploymentMonitoringBigQueryTable_LOG_SOURCE_UNSPECIFIED
}

func (x *ModelDeploymentMonitoringBigQueryTable) GetLogType() ModelDeploymentMonitoringBigQueryTable_LogType {
	if x != nil {
		return x.LogType
	}
	return ModelDeploymentMonitoringBigQueryTable_LOG_TYPE_UNSPECIFIED
}

func (x *ModelDeploymentMonitoringBigQueryTable) GetBigqueryTablePath() string {
	if x != nil {
		return x.BigqueryTablePath
	}
	return ""
}

// ModelDeploymentMonitoringObjectiveConfig contains the pair of
// deployed_model_id to ModelMonitoringObjectiveConfig.
type ModelDeploymentMonitoringObjectiveConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DeployedModel ID of the objective config.
	DeployedModelId string `protobuf:"bytes,1,opt,name=deployed_model_id,json=deployedModelId,proto3" json:"deployed_model_id,omitempty"`
	// The objective config of for the modelmonitoring job of this deployed model.
	ObjectiveConfig *ModelMonitoringObjectiveConfig `protobuf:"bytes,2,opt,name=objective_config,json=objectiveConfig,proto3" json:"objective_config,omitempty"`
}

func (x *ModelDeploymentMonitoringObjectiveConfig) Reset() {
	*x = ModelDeploymentMonitoringObjectiveConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelDeploymentMonitoringObjectiveConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelDeploymentMonitoringObjectiveConfig) ProtoMessage() {}

func (x *ModelDeploymentMonitoringObjectiveConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelDeploymentMonitoringObjectiveConfig.ProtoReflect.Descriptor instead.
func (*ModelDeploymentMonitoringObjectiveConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{2}
}

func (x *ModelDeploymentMonitoringObjectiveConfig) GetDeployedModelId() string {
	if x != nil {
		return x.DeployedModelId
	}
	return ""
}

func (x *ModelDeploymentMonitoringObjectiveConfig) GetObjectiveConfig() *ModelMonitoringObjectiveConfig {
	if x != nil {
		return x.ObjectiveConfig
	}
	return nil
}

// The config for scheduling monitoring job.
type ModelDeploymentMonitoringScheduleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model monitoring job running interval. It will be rounded up to next
	// full hour.
	MonitorInterval *durationpb.Duration `protobuf:"bytes,1,opt,name=monitor_interval,json=monitorInterval,proto3" json:"monitor_interval,omitempty"`
}

func (x *ModelDeploymentMonitoringScheduleConfig) Reset() {
	*x = ModelDeploymentMonitoringScheduleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelDeploymentMonitoringScheduleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelDeploymentMonitoringScheduleConfig) ProtoMessage() {}

func (x *ModelDeploymentMonitoringScheduleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelDeploymentMonitoringScheduleConfig.ProtoReflect.Descriptor instead.
func (*ModelDeploymentMonitoringScheduleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{3}
}

func (x *ModelDeploymentMonitoringScheduleConfig) GetMonitorInterval() *durationpb.Duration {
	if x != nil {
		return x.MonitorInterval
	}
	return nil
}

// Statistics and anomalies generated by Model Monitoring.
type ModelMonitoringStatsAnomalies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model Monitoring Objective those stats and anomalies belonging to.
	Objective ModelDeploymentMonitoringObjectiveType `protobuf:"varint,1,opt,name=objective,proto3,enum=google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType" json:"objective,omitempty"`
	// Deployed Model ID.
	DeployedModelId string `protobuf:"bytes,2,opt,name=deployed_model_id,json=deployedModelId,proto3" json:"deployed_model_id,omitempty"`
	// Number of anomalies within all stats.
	AnomalyCount int32 `protobuf:"varint,3,opt,name=anomaly_count,json=anomalyCount,proto3" json:"anomaly_count,omitempty"`
	// A list of historical Stats and Anomalies generated for all Features.
	FeatureStats []*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies `protobuf:"bytes,4,rep,name=feature_stats,json=featureStats,proto3" json:"feature_stats,omitempty"`
}

func (x *ModelMonitoringStatsAnomalies) Reset() {
	*x = ModelMonitoringStatsAnomalies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringStatsAnomalies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStatsAnomalies) ProtoMessage() {}

func (x *ModelMonitoringStatsAnomalies) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStatsAnomalies.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStatsAnomalies) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{4}
}

func (x *ModelMonitoringStatsAnomalies) GetObjective() ModelDeploymentMonitoringObjectiveType {
	if x != nil {
		return x.Objective
	}
	return ModelDeploymentMonitoringObjectiveType_MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
}

func (x *ModelMonitoringStatsAnomalies) GetDeployedModelId() string {
	if x != nil {
		return x.DeployedModelId
	}
	return ""
}

func (x *ModelMonitoringStatsAnomalies) GetAnomalyCount() int32 {
	if x != nil {
		return x.AnomalyCount
	}
	return 0
}

func (x *ModelMonitoringStatsAnomalies) GetFeatureStats() []*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies {
	if x != nil {
		return x.FeatureStats
	}
	return nil
}

// Historical Stats (and Anomalies) for a specific Feature.
type ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display Name of the Feature.
	FeatureDisplayName string `protobuf:"bytes,1,opt,name=feature_display_name,json=featureDisplayName,proto3" json:"feature_display_name,omitempty"`
	// Threshold for anomaly detection.
	Threshold *ThresholdConfig `protobuf:"bytes,3,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Stats calculated for the Training Dataset.
	TrainingStats *FeatureStatsAnomaly `protobuf:"bytes,4,opt,name=training_stats,json=trainingStats,proto3" json:"training_stats,omitempty"`
	// A list of historical stats generated by different time window's
	// Prediction Dataset.
	PredictionStats []*FeatureStatsAnomaly `protobuf:"bytes,5,rep,name=prediction_stats,json=predictionStats,proto3" json:"prediction_stats,omitempty"`
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) Reset() {
	*x = ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) ProtoMessage() {}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) GetFeatureDisplayName() string {
	if x != nil {
		return x.FeatureDisplayName
	}
	return ""
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) GetThreshold() *ThresholdConfig {
	if x != nil {
		return x.Threshold
	}
	return nil
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) GetTrainingStats() *FeatureStatsAnomaly {
	if x != nil {
		return x.TrainingStats
	}
	return nil
}

func (x *ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies) GetPredictionStats() []*FeatureStatsAnomaly {
	if x != nil {
		return x.PredictionStats
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f,
	0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x10, 0x0a, 0x1c,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x0e,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0xb0, 0x01, 0x0a, 0x2d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x29, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0xab, 0x01, 0x0a, 0x2b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x27, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x72, 0x0a, 0x19, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x12, 0x7e, 0x0a, 0x1d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x1b, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x55, 0x72, 0x69, 0x12, 0x4e, 0x0a, 0x17, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x55, 0x72, 0x69, 0x12, 0x75, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x07, 0x6c,
	0x6f, 0x67, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x6c, 0x6f, 0x67, 0x54, 0x74, 0x6c, 0x12,
	0x61, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x74, 0x0a, 0x1e, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x61,
	0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69, 0x65, 0x73, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69, 0x65, 0x73, 0x42, 0x61,
	0x73, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6b, 0x0a, 0x17, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x29, 0x0a, 0x25, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x5f,
	0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x46, 0x46,
	0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x03, 0x3a, 0xa5, 0x01, 0xea, 0x41, 0xa1, 0x01, 0x0a, 0x36, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x12, 0x67, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xb9, 0x03, 0x0a, 0x26,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x70, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x6c,
	0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6a, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x22, 0x42, 0x0a, 0x09, 0x4c, 0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x3d, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x52, 0x45, 0x44, 0x49, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58,
	0x50, 0x4c, 0x41, 0x49, 0x4e, 0x10, 0x02, 0x22, 0xc2, 0x01, 0x0a, 0x28, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64,
	0x12, 0x6a, 0x0a, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x74, 0x0a, 0x27,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x10, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x22, 0xbd, 0x05, 0x0a, 0x1d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61,
	0x6c, 0x69, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x6f, 0x6d, 0x61,
	0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x81, 0x01, 0x0a,
	0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61,
	0x6c, 0x69, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x69, 0x63, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69,
	0x65, 0x73, 0x52, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x1a, 0xdf, 0x02, 0x0a, 0x1d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x69, 0x63, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69,
	0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x5b, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61,
	0x6c, 0x79, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x5f, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c,
	0x79, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x2a, 0xce, 0x01, 0x0a, 0x26, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a,
	0x36, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x41, 0x57,
	0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x53, 0x4b, 0x45, 0x57, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x52, 0x41, 0x57, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x44,
	0x52, 0x49, 0x46, 0x54, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52,
	0x45, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x4b,
	0x45, 0x57, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f,
	0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x52, 0x49, 0x46,
	0x54, 0x10, 0x04, 0x42, 0xfe, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x21, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0xaa, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_goTypes = []interface{}{
	(ModelDeploymentMonitoringObjectiveType)(0),                         // 0: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
	(ModelDeploymentMonitoringJob_MonitoringScheduleState)(0),           // 1: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
	(ModelDeploymentMonitoringBigQueryTable_LogSource)(0),               // 2: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.LogSource
	(ModelDeploymentMonitoringBigQueryTable_LogType)(0),                 // 3: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.LogType
	(*ModelDeploymentMonitoringJob)(nil),                                // 4: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
	(*ModelDeploymentMonitoringBigQueryTable)(nil),                      // 5: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
	(*ModelDeploymentMonitoringObjectiveConfig)(nil),                    // 6: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
	(*ModelDeploymentMonitoringScheduleConfig)(nil),                     // 7: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
	(*ModelMonitoringStatsAnomalies)(nil),                               // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
	nil,                                                                 // 9: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.LabelsEntry
	(*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies)(nil), // 10: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies
	(JobState)(0),                          // 11: google.cloud.aiplatform.v1beta1.JobState
	(*SamplingStrategy)(nil),               // 12: google.cloud.aiplatform.v1beta1.SamplingStrategy
	(*ModelMonitoringAlertConfig)(nil),     // 13: google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
	(*structpb.Value)(nil),                 // 14: google.protobuf.Value
	(*durationpb.Duration)(nil),            // 15: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),          // 16: google.protobuf.Timestamp
	(*GcsDestination)(nil),                 // 17: google.cloud.aiplatform.v1beta1.GcsDestination
	(*ModelMonitoringObjectiveConfig)(nil), // 18: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
	(*ThresholdConfig)(nil),                // 19: google.cloud.aiplatform.v1beta1.ThresholdConfig
	(*FeatureStatsAnomaly)(nil),            // 20: google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly
}
var file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_depIdxs = []int32{
	11, // 0: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	1,  // 1: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.schedule_state:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
	6,  // 2: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.model_deployment_monitoring_objective_configs:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
	7,  // 3: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.model_deployment_monitoring_schedule_config:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
	12, // 4: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.logging_sampling_strategy:type_name -> google.cloud.aiplatform.v1beta1.SamplingStrategy
	13, // 5: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.model_monitoring_alert_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
	14, // 6: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.sample_predict_instance:type_name -> google.protobuf.Value
	5,  // 7: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.bigquery_tables:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
	15, // 8: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.log_ttl:type_name -> google.protobuf.Duration
	9,  // 9: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.labels:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.LabelsEntry
	16, // 10: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.create_time:type_name -> google.protobuf.Timestamp
	16, // 11: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.update_time:type_name -> google.protobuf.Timestamp
	16, // 12: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.next_schedule_time:type_name -> google.protobuf.Timestamp
	17, // 13: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.stats_anomalies_base_directory:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	2,  // 14: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.log_source:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.LogSource
	3,  // 15: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.log_type:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.LogType
	18, // 16: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.objective_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
	15, // 17: google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.monitor_interval:type_name -> google.protobuf.Duration
	0,  // 18: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.objective:type_name -> google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
	10, // 19: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.feature_stats:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies
	19, // 20: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.threshold:type_name -> google.cloud.aiplatform.v1beta1.ThresholdConfig
	20, // 21: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.training_stats:type_name -> google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly
	20, // 22: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.prediction_stats:type_name -> google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_feature_monitoring_stats_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelDeploymentMonitoringJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelDeploymentMonitoringBigQueryTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelDeploymentMonitoringObjectiveConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelDeploymentMonitoringScheduleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringStatsAnomalies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringStatsAnomalies_FeatureHistoricStatsAnomalies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_deployment_monitoring_job_proto_depIdxs = nil
}
