// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
)

type issues struct {
	container
}

func (o *issues) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	pageSize := o.getPageSize()

	var err error
	var forgejoIssues []*forgejo_sdk.Issue

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())

	forgejoIssues, resp, err := o.getClient().ListRepoIssues(owner, project, forgejo_sdk.ListIssueOption{
		ListOptions: forgejo_sdk.ListOptions{Page: page, PageSize: pageSize},
		State:       forgejo_sdk.StateAll,
		Type:        forgejo_sdk.IssueTypeIssue,
	})
	if resp.StatusCode == 404 {
		return generic.NewChildrenSlice(0)
	}
	if err != nil {
		panic(fmt.Errorf("error while listing issues: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(forgejoIssues...)...)
}

func newIssues() generic.NodeDriverInterface {
	return &issues{}
}
