// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the contact
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_Contact.html)
// associated to the user.
type AgentContactReference struct {

	// The state of the contact
	// (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
	AgentContactState ContactState

	// The channel of the contact.
	Channel Channel

	// The time at which the contact was connected to an agent.
	ConnectedToAgentTimestamp *time.Time

	// The identifier of the contact in this instance of Amazon Connect.
	ContactId *string

	// How the contact was initiated.
	InitiationMethod ContactInitiationMethod

	// Contains information about a queue resource for which metrics are returned.
	Queue *QueueReference

	// The epoch timestamp when the contact state started.
	StateStartTimestamp *time.Time

	noSmithyDocumentSerde
}

// Information about the agent who accepted the contact.
type AgentInfo struct {

	// The timestamp when the contact was connected to the agent.
	ConnectedToAgentTimestamp *time.Time

	// The identifier of the agent who accepted the contact.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about an agent status.
type AgentStatus struct {

	// The Amazon Resource Name (ARN) of the agent status.
	AgentStatusARN *string

	// The identifier of the agent status.
	AgentStatusId *string

	// The description of the agent status.
	Description *string

	// The display order of the agent status.
	DisplayOrder *int32

	// The name of the agent status.
	Name *string

	// The state of the agent status.
	State AgentStatusState

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	// The type of agent status.
	Type AgentStatusType

	noSmithyDocumentSerde
}

// Information about the agent's status.
type AgentStatusReference struct {

	// The Amazon Resource Name (ARN) of the agent's status.
	StatusArn *string

	// The start timestamp of the agent's status.
	StatusStartTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summary information for an agent status.
type AgentStatusSummary struct {

	// The Amazon Resource Name (ARN) for the agent status.
	Arn *string

	// The identifier for an agent status.
	Id *string

	// The name of the agent status.
	Name *string

	// The type of the agent status.
	Type AgentStatusType

	noSmithyDocumentSerde
}

// Configuration of the answering machine detection.
type AnswerMachineDetectionConfig struct {

	// Wait for the answering machine prompt.
	AwaitAnswerMachinePrompt bool

	// The flag to indicate if answer machine detection analysis needs to be performed
	// for a voice call. If set to true, TrafficType must be set as CAMPAIGN.
	EnableAnswerMachineDetection bool

	noSmithyDocumentSerde
}

// Information about a reference when the referenceType is ATTACHMENT. Otherwise,
// null.
type AttachmentReference struct {

	// Identifier of the attachment reference.
	Name *string

	// Status of the attachment reference type.
	Status ReferenceStatus

	// The location path of the attachment reference.
	Value *string

	noSmithyDocumentSerde
}

// A toggle for an individual feature at the instance level.
type Attribute struct {

	// The type of attribute.
	AttributeType InstanceAttributeType

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// Information about available phone numbers.
type AvailableNumberSummary struct {

	// The phone number. Phone numbers are formatted [+] [country code] [subscriber
	// number including area code].
	PhoneNumber *string

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode

	// The type of phone number.
	PhoneNumberType PhoneNumberType

	noSmithyDocumentSerde
}

// A chat message.
type ChatMessage struct {

	// The content of the chat message.
	//
	// This member is required.
	Content *string

	// The type of the content. Supported types are text/plain.
	//
	// This member is required.
	ContentType *string

	noSmithyDocumentSerde
}

// The streaming configuration, such as the Amazon SNS streaming endpoint.
type ChatStreamingConfiguration struct {

	// The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon
	// Resource Name (ARN) of the streaming endpoint that is used to publish real-time
	// message streaming for chat conversations.
	//
	// This member is required.
	StreamingEndpointArn *string

	noSmithyDocumentSerde
}

// Information about a phone number that has been claimed to your Amazon Connect
// instance or traffic distribution group.
type ClaimedPhoneNumberSummary struct {

	// The phone number. Phone numbers are formatted [+] [country code] [subscriber
	// number including area code].
	PhoneNumber *string

	// The Amazon Resource Name (ARN) of the phone number.
	PhoneNumberArn *string

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode

	// The description of the phone number.
	PhoneNumberDescription *string

	// A unique identifier for the phone number.
	PhoneNumberId *string

	// The status of the phone number.
	//
	// * CLAIMED means the previous ClaimedPhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	// or UpdatePhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	// operation succeeded.
	//
	// * IN_PROGRESS means a ClaimedPhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	// or UpdatePhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	// operation is still in progress and has not yet completed. You can call
	// DescribePhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html)
	// at a later time to verify if the previous operation has completed.
	//
	// * FAILED
	// indicates that the previous ClaimedPhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	// or UpdatePhoneNumber
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	// operation has failed. It will include a message indicating the failure reason. A
	// common reason for a failure may be that the TargetArn value you are claiming or
	// updating a phone number to has reached its limit of total claimed numbers. If
	// you received a FAILED status from a ClaimPhoneNumber API call, you have one day
	// to retry claiming the phone number before the number is released back to the
	// inventory for other customers to claim.
	//
	// You will not be billed for the phone
	// number during the 1-day period if number claiming fails.
	PhoneNumberStatus *PhoneNumberStatus

	// The type of phone number.
	PhoneNumberType PhoneNumberType

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	// The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
	// distribution groups that phone numbers are claimed to.
	TargetArn *string

	noSmithyDocumentSerde
}

// Contains information about a contact.
type Contact struct {

	// Information about the agent who accepted the contact.
	AgentInfo *AgentInfo

	// The Amazon Resource Name (ARN) for the contact.
	Arn *string

	// How the contact reached your contact center.
	Channel Channel

	// The description of the contact.
	Description *string

	// The timestamp when the customer endpoint disconnected from Amazon Connect.
	DisconnectTimestamp *time.Time

	// The identifier for the contact.
	Id *string

	// If this contact is related to other contacts, this is the ID of the initial
	// contact.
	InitialContactId *string

	// Indicates how the contact was initiated.
	InitiationMethod ContactInitiationMethod

	// The date and time this contact was initiated, in UTC time. For INBOUND, this is
	// when the contact arrived. For OUTBOUND, this is when the agent began dialing.
	// For CALLBACK, this is when the callback contact was created. For TRANSFER and
	// QUEUE_TRANSFER, this is when the transfer was initiated. For API, this is when
	// the request arrived.
	InitiationTimestamp *time.Time

	// The timestamp when contact was last updated.
	LastUpdateTimestamp *time.Time

	// The name of the contact.
	Name *string

	// If this contact is not the first contact, this is the ID of the previous
	// contact.
	PreviousContactId *string

	// If this contact was queued, this contains information about the queue.
	QueueInfo *QueueInfo

	// The timestamp, in Unix epoch time format, at which to start running the inbound
	// flow.
	ScheduledTimestamp *time.Time

	noSmithyDocumentSerde
}

// Filters user data based on the contact information that is associated to the
// users. It contains a list of contact states
// (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
type ContactFilter struct {

	// A list of up to 9 contact states
	// (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
	ContactStates []ContactState

	noSmithyDocumentSerde
}

// Contains information about a flow.
type ContactFlow struct {

	// The Amazon Resource Name (ARN) of the flow.
	Arn *string

	// The content of the flow.
	Content *string

	// The description of the flow.
	Description *string

	// The identifier of the flow.
	Id *string

	// The name of the flow.
	Name *string

	// The type of flow.
	State ContactFlowState

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	// The type of the flow. For descriptions of the available types, see Choose a flow
	// type
	// (https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types)
	// in the Amazon Connect Administrator Guide.
	Type ContactFlowType

	noSmithyDocumentSerde
}

// Contains information about a flow module.
type ContactFlowModule struct {

	// The Amazon Resource Name (ARN).
	Arn *string

	// The content of the flow module.
	Content *string

	// The description of the flow module.
	Description *string

	// The identifier of the flow module.
	Id *string

	// The name of the flow module.
	Name *string

	// The type of flow module.
	State ContactFlowModuleState

	// The status of the flow module.
	Status ContactFlowModuleStatus

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains summary information about a flow.
type ContactFlowModuleSummary struct {

	// The Amazon Resource Name (ARN) of the flow module.
	Arn *string

	// The identifier of the flow module.
	Id *string

	// The name of the flow module.
	Name *string

	// The type of flow module.
	State ContactFlowModuleState

	noSmithyDocumentSerde
}

// Contains summary information about a flow. You can also create and update flows
// using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
type ContactFlowSummary struct {

	// The Amazon Resource Name (ARN) of the flow.
	Arn *string

	// The type of flow.
	ContactFlowState ContactFlowState

	// The type of flow.
	ContactFlowType ContactFlowType

	// The identifier of the flow.
	Id *string

	// The name of the flow.
	Name *string

	noSmithyDocumentSerde
}

// An object that can be used to specify Tag conditions inside the SearchFilter.
// This accepts an OR of AND (List of List) input where:
//
// * Top level list
// specifies conditions that need to be applied with OR operator
//
// * Inner list
// specifies conditions that need to be applied with AND operator.
type ControlPlaneTagFilter struct {

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []TagCondition

	// A list of conditions which would be applied together with an OR condition.
	OrConditions [][]TagCondition

	// A leaf node condition which can be used to specify a tag condition.
	TagCondition *TagCondition

	noSmithyDocumentSerde
}

// Contains credentials to use for federation.
type Credentials struct {

	// An access token generated for a federated user to access Amazon Connect.
	AccessToken *string

	// A token generated with an expiration time for the session a user is logged in to
	// Amazon Connect.
	AccessTokenExpiration *time.Time

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time

	noSmithyDocumentSerde
}

// Contains information about a real-time metric. For a description of each metric,
// see Real-time Metrics Definitions
// (https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
type CurrentMetric struct {

	// The name of the metric.
	Name CurrentMetricName

	// The unit for the metric.
	Unit Unit

	noSmithyDocumentSerde
}

// Contains the data for a real-time metric.
type CurrentMetricData struct {

	// Information about the metric.
	Metric *CurrentMetric

	// The value of the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Contains information about a set of real-time metrics.
type CurrentMetricResult struct {

	// The set of metrics.
	Collections []CurrentMetricData

	// The dimensions for the metrics.
	Dimensions *Dimensions

	noSmithyDocumentSerde
}

// Information about a reference when the referenceType is DATE. Otherwise, null.
type DateReference struct {

	// Identifier of the date reference.
	Name *string

	// A valid date.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about a default vocabulary.
type DefaultVocabulary struct {

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	//
	// This member is required.
	InstanceId *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	VocabularyId *string

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	VocabularyName *string

	noSmithyDocumentSerde
}

// Contains information about the dimensions for a set of metrics.
type Dimensions struct {

	// The channel used for grouping and filters.
	Channel Channel

	// Information about the queue for which metrics are returned.
	Queue *QueueReference

	noSmithyDocumentSerde
}

// Information about a traffic distribution.
type Distribution struct {

	// The percentage of the traffic that is distributed, in increments of 10.
	//
	// This member is required.
	Percentage int32

	// The Amazon Web Services Region where the traffic is distributed.
	//
	// This member is required.
	Region *string

	noSmithyDocumentSerde
}

// Information about a reference when the referenceType is EMAIL. Otherwise, null.
type EmailReference struct {

	// Identifier of the email reference.
	Name *string

	// A valid email address.
	Value *string

	noSmithyDocumentSerde
}

// The encryption configuration.
type EncryptionConfig struct {

	// The type of encryption.
	//
	// This member is required.
	EncryptionType EncryptionType

	// The full ARN of the encryption key. Be sure to provide the full ARN of the
	// encryption key, not just the ID.
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

// Contains the filter to apply when retrieving metrics.
type Filters struct {

	// The channel to use to filter the metrics.
	Channels []Channel

	// The queues to use to filter the metrics. You should specify at least one queue,
	// and can specify up to 100 queues per request. The GetCurrentMetricsData API in
	// particular requires a queue when you include a Filter in your request.
	Queues []string

	noSmithyDocumentSerde
}

// Contains information about a hierarchy group.
type HierarchyGroup struct {

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string

	// Information about the levels in the hierarchy group.
	HierarchyPath *HierarchyPath

	// The identifier of the hierarchy group.
	Id *string

	// The identifier of the level in the hierarchy group.
	LevelId *string

	// The name of the hierarchy group.
	Name *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A leaf node condition which can be used to specify a hierarchy group condition.
type HierarchyGroupCondition struct {

	// The type of hierarchy group match.
	HierarchyGroupMatchType HierarchyGroupMatchType

	// The value in the hierarchy group condition.
	Value *string

	noSmithyDocumentSerde
}

// Contains summary information about a hierarchy group.
type HierarchyGroupSummary struct {

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string

	// The identifier of the hierarchy group.
	Id *string

	// The name of the hierarchy group.
	Name *string

	noSmithyDocumentSerde
}

// Information about the hierarchy group.
type HierarchyGroupSummaryReference struct {

	// The Amazon Resource Name (ARN) for the hierarchy group.
	Arn *string

	// The unique identifier for the hierarchy group.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a hierarchy level.
type HierarchyLevel struct {

	// The Amazon Resource Name (ARN) of the hierarchy level.
	Arn *string

	// The identifier of the hierarchy level.
	Id *string

	// The name of the hierarchy level.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the hierarchy level to update.
type HierarchyLevelUpdate struct {

	// The name of the user hierarchy level. Must not be more than 50 characters.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the levels of a hierarchy group.
type HierarchyPath struct {

	// Information about level five.
	LevelFive *HierarchyGroupSummary

	// Information about level four.
	LevelFour *HierarchyGroupSummary

	// Information about level one.
	LevelOne *HierarchyGroupSummary

	// Information about level three.
	LevelThree *HierarchyGroupSummary

	// Information about level two.
	LevelTwo *HierarchyGroupSummary

	noSmithyDocumentSerde
}

// Information about the levels in the hierarchy group.
type HierarchyPathReference struct {

	// Information about level five.
	LevelFive *HierarchyGroupSummaryReference

	// Information about level four.
	LevelFour *HierarchyGroupSummaryReference

	// Information about level one.
	LevelOne *HierarchyGroupSummaryReference

	// Information about level three.
	LevelThree *HierarchyGroupSummaryReference

	// Information about level two.
	LevelTwo *HierarchyGroupSummaryReference

	noSmithyDocumentSerde
}

// Contains information about a hierarchy structure.
type HierarchyStructure struct {

	// Information about level five.
	LevelFive *HierarchyLevel

	// Information about level four.
	LevelFour *HierarchyLevel

	// Information about level one.
	LevelOne *HierarchyLevel

	// Information about level three.
	LevelThree *HierarchyLevel

	// Information about level two.
	LevelTwo *HierarchyLevel

	noSmithyDocumentSerde
}

// Contains information about the level hierarchy to update.
type HierarchyStructureUpdate struct {

	// The update for level five.
	LevelFive *HierarchyLevelUpdate

	// The update for level four.
	LevelFour *HierarchyLevelUpdate

	// The update for level one.
	LevelOne *HierarchyLevelUpdate

	// The update for level three.
	LevelThree *HierarchyLevelUpdate

	// The update for level two.
	LevelTwo *HierarchyLevelUpdate

	noSmithyDocumentSerde
}

// Contains information about a historical metric. For a description of each
// metric, see Historical Metrics Definitions
// (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
type HistoricalMetric struct {

	// The name of the metric.
	Name HistoricalMetricName

	// The statistic for the metric.
	Statistic Statistic

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold

	// The unit for the metric.
	Unit Unit

	noSmithyDocumentSerde
}

// Contains the data for a historical metric.
type HistoricalMetricData struct {

	// Information about the metric.
	Metric *HistoricalMetric

	// The value of the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Contains information about the historical metrics retrieved.
type HistoricalMetricResult struct {

	// The set of metrics.
	Collections []HistoricalMetricData

	// The dimension for the metrics.
	Dimensions *Dimensions

	noSmithyDocumentSerde
}

// Information about of the hours of operation.
type HoursOfOperation struct {

	// Configuration information for the hours of operation.
	Config []HoursOfOperationConfig

	// The description for the hours of operation.
	Description *string

	// The Amazon Resource Name (ARN) for the hours of operation.
	HoursOfOperationArn *string

	// The identifier for the hours of operation.
	HoursOfOperationId *string

	// The name for the hours of operation.
	Name *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	// The time zone for the hours of operation.
	TimeZone *string

	noSmithyDocumentSerde
}

// Contains information about the hours of operation.
type HoursOfOperationConfig struct {

	// The day that the hours of operation applies to.
	//
	// This member is required.
	Day HoursOfOperationDays

	// The end time that your contact center closes.
	//
	// This member is required.
	EndTime *HoursOfOperationTimeSlice

	// The start time that your contact center opens.
	//
	// This member is required.
	StartTime *HoursOfOperationTimeSlice

	noSmithyDocumentSerde
}

// Contains summary information about hours of operation for a contact center.
type HoursOfOperationSummary struct {

	// The Amazon Resource Name (ARN) of the hours of operation.
	Arn *string

	// The identifier of the hours of operation.
	Id *string

	// The name of the hours of operation.
	Name *string

	noSmithyDocumentSerde
}

// The start time or end time for an hours of operation.
type HoursOfOperationTimeSlice struct {

	// The hours.
	//
	// This member is required.
	Hours *int32

	// The minutes.
	//
	// This member is required.
	Minutes *int32

	noSmithyDocumentSerde
}

// The Amazon Connect instance.
type Instance struct {

	// The Amazon Resource Name (ARN) of the instance.
	Arn *string

	// When the instance was created.
	CreatedTime *time.Time

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	Id *string

	// The identity management type.
	IdentityManagementType DirectoryType

	// Whether inbound calls are enabled.
	InboundCallsEnabled *bool

	// The alias of instance.
	InstanceAlias *string

	// The state of the instance.
	InstanceStatus InstanceStatus

	// Whether outbound calls are enabled.
	OutboundCallsEnabled *bool

	// The service role of the instance.
	ServiceRole *string

	// Relevant details why the instance was not successfully created.
	StatusReason *InstanceStatusReason

	noSmithyDocumentSerde
}

// Relevant details why the instance was not successfully created.
type InstanceStatusReason struct {

	// The message.
	Message *string

	noSmithyDocumentSerde
}

// The storage configuration for the instance.
type InstanceStorageConfig struct {

	// A valid storage type.
	//
	// This member is required.
	StorageType StorageType

	// The existing association identifier that uniquely identifies the resource type
	// and storage config for the given instance ID.
	AssociationId *string

	// The configuration of the Kinesis Firehose delivery stream.
	KinesisFirehoseConfig *KinesisFirehoseConfig

	// The configuration of the Kinesis data stream.
	KinesisStreamConfig *KinesisStreamConfig

	// The configuration of the Kinesis video stream.
	KinesisVideoStreamConfig *KinesisVideoStreamConfig

	// The S3 bucket configuration.
	S3Config *S3Config

	noSmithyDocumentSerde
}

// Information about the instance.
type InstanceSummary struct {

	// The Amazon Resource Name (ARN) of the instance.
	Arn *string

	// When the instance was created.
	CreatedTime *time.Time

	// The identifier of the instance.
	Id *string

	// The identity management type of the instance.
	IdentityManagementType DirectoryType

	// Whether inbound calls are enabled.
	InboundCallsEnabled *bool

	// The alias of the instance.
	InstanceAlias *string

	// The state of the instance.
	InstanceStatus InstanceStatus

	// Whether outbound calls are enabled.
	OutboundCallsEnabled *bool

	// The service role of the instance.
	ServiceRole *string

	noSmithyDocumentSerde
}

// Contains summary information about the associated AppIntegrations.
type IntegrationAssociationSummary struct {

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	InstanceId *string

	// The Amazon Resource Name (ARN) for the AppIntegration.
	IntegrationArn *string

	// The Amazon Resource Name (ARN) for the AppIntegration association.
	IntegrationAssociationArn *string

	// The identifier for the AppIntegration association.
	IntegrationAssociationId *string

	// The integration type.
	IntegrationType IntegrationType

	// The user-provided, friendly name for the external application.
	SourceApplicationName *string

	// The URL for the external application.
	SourceApplicationUrl *string

	// The name of the source.
	SourceType SourceType

	noSmithyDocumentSerde
}

// A field that is invisible to an agent.
type InvisibleFieldInfo struct {

	// Identifier of the invisible field.
	Id *TaskTemplateFieldIdentifier

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis Data Firehose delivery stream.
type KinesisFirehoseConfig struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	FirehoseArn *string

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis data stream.
type KinesisStreamConfig struct {

	// The Amazon Resource Name (ARN) of the data stream.
	//
	// This member is required.
	StreamArn *string

	noSmithyDocumentSerde
}

// Configuration information of a Kinesis video stream.
type KinesisVideoStreamConfig struct {

	// The encryption configuration.
	//
	// This member is required.
	EncryptionConfig *EncryptionConfig

	// The prefix of the video stream.
	//
	// This member is required.
	Prefix *string

	// The number of hours data is retained in the stream. Kinesis Video Streams
	// retains the data in a data store that is associated with the stream. The default
	// value is 0, indicating that the stream does not persist data.
	//
	// This member is required.
	RetentionPeriodHours int32

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex bot.
type LexBot struct {

	// The Amazon Web Services Region where the Amazon Lex bot was created.
	LexRegion *string

	// The name of the Amazon Lex bot.
	Name *string

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex or Amazon Lex V2 bot.
type LexBotConfig struct {

	// Configuration information of an Amazon Lex bot.
	LexBot *LexBot

	// Configuration information of an Amazon Lex V2 bot.
	LexV2Bot *LexV2Bot

	noSmithyDocumentSerde
}

// Configuration information of an Amazon Lex V2 bot.
type LexV2Bot struct {

	// The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.
	AliasArn *string

	noSmithyDocumentSerde
}

// Information about phone numbers that have been claimed to your Amazon Connect
// instance or traffic distribution group.
type ListPhoneNumbersSummary struct {

	// The phone number. Phone numbers are formatted [+] [country code] [subscriber
	// number including area code].
	PhoneNumber *string

	// The Amazon Resource Name (ARN) of the phone number.
	PhoneNumberArn *string

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode

	// A unique identifier for the phone number.
	PhoneNumberId *string

	// The type of phone number.
	PhoneNumberType PhoneNumberType

	// The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
	// distribution groups that phone numbers are claimed to.
	TargetArn *string

	noSmithyDocumentSerde
}

// Contains information about which channels are supported, and how many contacts
// an agent can have on a channel simultaneously.
type MediaConcurrency struct {

	// The channels that agents can handle in the Contact Control Panel (CCP).
	//
	// This member is required.
	Channel Channel

	// The number of contacts an agent can have on a channel simultaneously. Valid
	// Range for VOICE: Minimum value of 1. Maximum value of 1. Valid Range for CHAT:
	// Minimum value of 1. Maximum value of 10. Valid Range for TASK: Minimum value of
	// 1. Maximum value of 10.
	//
	// This member is required.
	Concurrency int32

	noSmithyDocumentSerde
}

// Information about a reference when the referenceType is NUMBER. Otherwise, null.
type NumberReference struct {

	// Identifier of the number reference.
	Name *string

	// A valid number.
	Value *string

	noSmithyDocumentSerde
}

// The outbound caller ID name, number, and outbound whisper flow.
type OutboundCallerConfig struct {

	// The caller ID name.
	OutboundCallerIdName *string

	// The caller ID number.
	OutboundCallerIdNumberId *string

	// The outbound whisper flow to be used during an outbound call.
	OutboundFlowId *string

	noSmithyDocumentSerde
}

// The customer's details.
type ParticipantDetails struct {

	// Display name of the participant.
	//
	// This member is required.
	DisplayName *string

	noSmithyDocumentSerde
}

// Contains information about a phone number for a quick connect.
type PhoneNumberQuickConnectConfig struct {

	// The phone number in E.164 format.
	//
	// This member is required.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// The status of the phone number.
//
// * CLAIMED means the previous ClaimedPhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
// or UpdatePhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
// operation succeeded.
//
// * IN_PROGRESS means a ClaimedPhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
// or UpdatePhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
// operation is still in progress and has not yet completed. You can call
// DescribePhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html)
// at a later time to verify if the previous operation has completed.
//
// * FAILED
// indicates that the previous ClaimedPhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
// or UpdatePhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
// operation has failed. It will include a message indicating the failure reason. A
// common reason for a failure may be that the TargetArn value you are claiming or
// updating a phone number to has reached its limit of total claimed numbers. If
// you received a FAILED status from a ClaimPhoneNumber API call, you have one day
// to retry claiming the phone number before the number is released back to the
// inventory for other customers to claim.
type PhoneNumberStatus struct {

	// The status message.
	Message *string

	// The status.
	Status PhoneNumberWorkflowStatus

	noSmithyDocumentSerde
}

// Contains summary information about a phone number for a contact center.
type PhoneNumberSummary struct {

	// The Amazon Resource Name (ARN) of the phone number.
	Arn *string

	// The identifier of the phone number.
	Id *string

	// The phone number.
	PhoneNumber *string

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode

	// The type of phone number.
	PhoneNumberType PhoneNumberType

	noSmithyDocumentSerde
}

// Information about a problem detail.
type ProblemDetail struct {

	// The problem detail's message.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the prompt.
type PromptSummary struct {

	// The Amazon Resource Name (ARN) of the prompt.
	Arn *string

	// The identifier of the prompt.
	Id *string

	// The name of the prompt.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about why a property is not valid.
type PropertyValidationExceptionProperty struct {

	// A message describing why the property is not valid.
	//
	// This member is required.
	Message *string

	// The full property path.
	//
	// This member is required.
	PropertyPath *string

	// Why the property is not valid.
	//
	// This member is required.
	Reason PropertyValidationExceptionReason

	noSmithyDocumentSerde
}

// Contains information about a queue.
type Queue struct {

	// The description of the queue.
	Description *string

	// The identifier for the hours of operation.
	HoursOfOperationId *string

	// The maximum number of contacts that can be in the queue before it is considered
	// full.
	MaxContacts *int32

	// The name of the queue.
	Name *string

	// The outbound caller ID name, number, and outbound whisper flow.
	OutboundCallerConfig *OutboundCallerConfig

	// The Amazon Resource Name (ARN) for the queue.
	QueueArn *string

	// The identifier for the queue.
	QueueId *string

	// The status of the queue.
	Status QueueStatus

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// If this contact was queued, this contains information about the queue.
type QueueInfo struct {

	// The timestamp when the contact was added to the queue.
	EnqueueTimestamp *time.Time

	// The unique identifier for the queue.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a queue for a quick connect. The flow must be of type
// Transfer to Queue.
type QueueQuickConnectConfig struct {

	// The identifier of the flow.
	//
	// This member is required.
	ContactFlowId *string

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// Contains information about a queue resource for which metrics are returned.
type QueueReference struct {

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string

	// The identifier of the queue.
	Id *string

	noSmithyDocumentSerde
}

// The search criteria to be used to return queues.
type QueueSearchCriteria struct {

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []QueueSearchCriteria

	// A list of conditions which would be applied together with an OR condition.
	OrConditions []QueueSearchCriteria

	// The type of queue.
	QueueTypeCondition SearchableQueueType

	// A leaf node condition which can be used to specify a string condition. The
	// currently supported value for FieldName: name
	StringCondition *StringCondition

	noSmithyDocumentSerde
}

// Filters to be applied to search results.
type QueueSearchFilter struct {

	// An object that can be used to specify Tag conditions inside the SearchFilter.
	// This accepts an OR of AND (List of List) input where:
	//
	// * Top level list
	// specifies conditions that need to be applied with OR operator
	//
	// * Inner list
	// specifies conditions that need to be applied with AND operator.
	TagFilter *ControlPlaneTagFilter

	noSmithyDocumentSerde
}

// Contains summary information about a queue.
type QueueSummary struct {

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string

	// The identifier of the queue.
	Id *string

	// The name of the queue.
	Name *string

	// The type of queue.
	QueueType QueueType

	noSmithyDocumentSerde
}

// Contains information about a quick connect.
type QuickConnect struct {

	// The description.
	Description *string

	// The name of the quick connect.
	Name *string

	// The Amazon Resource Name (ARN) of the quick connect.
	QuickConnectARN *string

	// Contains information about the quick connect.
	QuickConnectConfig *QuickConnectConfig

	// The identifier for the quick connect.
	QuickConnectId *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains configuration settings for a quick connect.
type QuickConnectConfig struct {

	// The type of quick connect. In the Amazon Connect console, when you create a
	// quick connect, you are prompted to assign one of the following types: Agent
	// (USER), External (PHONE_NUMBER), or Queue (QUEUE).
	//
	// This member is required.
	QuickConnectType QuickConnectType

	// The phone configuration. This is required only if QuickConnectType is
	// PHONE_NUMBER.
	PhoneConfig *PhoneNumberQuickConnectConfig

	// The queue configuration. This is required only if QuickConnectType is QUEUE.
	QueueConfig *QueueQuickConnectConfig

	// The user configuration. This is required only if QuickConnectType is USER.
	UserConfig *UserQuickConnectConfig

	noSmithyDocumentSerde
}

// Contains summary information about a quick connect.
type QuickConnectSummary struct {

	// The Amazon Resource Name (ARN) of the quick connect.
	Arn *string

	// The identifier for the quick connect.
	Id *string

	// The name of the quick connect.
	Name *string

	// The type of quick connect. In the Amazon Connect console, when you create a
	// quick connect, you are prompted to assign one of the following types: Agent
	// (USER), External (PHONE_NUMBER), or Queue (QUEUE).
	QuickConnectType QuickConnectType

	noSmithyDocumentSerde
}

// Indicates a field that is read-only to an agent.
type ReadOnlyFieldInfo struct {

	// Identifier of the read-only field.
	Id *TaskTemplateFieldIdentifier

	noSmithyDocumentSerde
}

// Well-formed data on a contact, used by agents to complete a contact request. You
// can have up to 4,096 UTF-8 bytes across all references for a contact.
type Reference struct {

	// The type of the reference. DATE must be of type Epoch timestamp.
	//
	// This member is required.
	Type ReferenceType

	// A valid value for the reference. For example, for a URL reference, a formatted
	// URL that is displayed to an agent in the Contact Control Panel (CCP).
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains summary information about a reference. ReferenceSummary contains only
// one non null field between the URL and attachment based on the reference type.
//
// The following types satisfy this interface:
//
//	ReferenceSummaryMemberAttachment
//	ReferenceSummaryMemberDate
//	ReferenceSummaryMemberEmail
//	ReferenceSummaryMemberNumber
//	ReferenceSummaryMemberString
//	ReferenceSummaryMemberUrl
type ReferenceSummary interface {
	isReferenceSummary()
}

// Information about the reference when the referenceType is ATTACHMENT. Otherwise,
// null.
type ReferenceSummaryMemberAttachment struct {
	Value AttachmentReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberAttachment) isReferenceSummary() {}

// Information about a reference when the referenceType is DATE. Otherwise, null.
type ReferenceSummaryMemberDate struct {
	Value DateReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberDate) isReferenceSummary() {}

// Information about a reference when the referenceType is EMAIL. Otherwise, null.
type ReferenceSummaryMemberEmail struct {
	Value EmailReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberEmail) isReferenceSummary() {}

// Information about a reference when the referenceType is NUMBER. Otherwise, null.
type ReferenceSummaryMemberNumber struct {
	Value NumberReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberNumber) isReferenceSummary() {}

// Information about a reference when the referenceType is STRING. Otherwise, null.
type ReferenceSummaryMemberString struct {
	Value StringReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberString) isReferenceSummary() {}

// Information about the reference when the referenceType is URL. Otherwise, null.
type ReferenceSummaryMemberUrl struct {
	Value UrlReference

	noSmithyDocumentSerde
}

func (*ReferenceSummaryMemberUrl) isReferenceSummary() {}

// Information about a required field.
type RequiredFieldInfo struct {

	// The unique identifier for the field.
	Id *TaskTemplateFieldIdentifier

	noSmithyDocumentSerde
}

// Contains information about a routing profile.
type RoutingProfile struct {

	// The identifier of the default outbound queue for this routing profile.
	DefaultOutboundQueueId *string

	// The description of the routing profile.
	Description *string

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	InstanceId *string

	// The channels agents can handle in the Contact Control Panel (CCP) for this
	// routing profile.
	MediaConcurrencies []MediaConcurrency

	// The name of the routing profile.
	Name *string

	// The number of associated queues in routing profile.
	NumberOfAssociatedQueues *int64

	// The number of associated users in routing profile.
	NumberOfAssociatedUsers *int64

	// The Amazon Resource Name (ARN) of the routing profile.
	RoutingProfileArn *string

	// The identifier of the routing profile.
	RoutingProfileId *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about the queue and channel for which priority and delay
// can be set.
type RoutingProfileQueueConfig struct {

	// The delay, in seconds, a contact should be in the queue before they are routed
	// to an available agent. For more information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html)
	// in the Amazon Connect Administrator Guide.
	//
	// This member is required.
	Delay *int32

	// The order in which contacts are to be handled for the queue. For more
	// information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
	//
	// This member is required.
	Priority *int32

	// Contains information about a queue resource.
	//
	// This member is required.
	QueueReference *RoutingProfileQueueReference

	noSmithyDocumentSerde
}

// Contains summary information about a routing profile queue.
type RoutingProfileQueueConfigSummary struct {

	// The channels this queue supports.
	//
	// This member is required.
	Channel Channel

	// The delay, in seconds, that a contact should be in the queue before they are
	// routed to an available agent. For more information, see Queues: priority and
	// delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html)
	// in the Amazon Connect Administrator Guide.
	//
	// This member is required.
	Delay int32

	// The order in which contacts are to be handled for the queue. For more
	// information, see Queues: priority and delay
	// (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
	//
	// This member is required.
	Priority int32

	// The Amazon Resource Name (ARN) of the queue.
	//
	// This member is required.
	QueueArn *string

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	// The name of the queue.
	//
	// This member is required.
	QueueName *string

	noSmithyDocumentSerde
}

// Contains the channel and queue identifier for a routing profile.
type RoutingProfileQueueReference struct {

	// The channels agents can handle in the Contact Control Panel (CCP) for this
	// routing profile.
	//
	// This member is required.
	Channel Channel

	// The identifier for the queue.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// Information about the routing profile assigned to the user.
type RoutingProfileReference struct {

	// The Amazon Resource Name (ARN) of the routing profile.
	Arn *string

	// The identifier of the routing profile.
	Id *string

	noSmithyDocumentSerde
}

// The search criteria to be used to return routing profiles.
type RoutingProfileSearchCriteria struct {

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []RoutingProfileSearchCriteria

	// A list of conditions which would be applied together with an OR condition.
	OrConditions []RoutingProfileSearchCriteria

	// A leaf node condition which can be used to specify a string condition. The
	// currently supported value for FieldName: name
	StringCondition *StringCondition

	noSmithyDocumentSerde
}

// Filters to be applied to search results.
type RoutingProfileSearchFilter struct {

	// An object that can be used to specify Tag conditions inside the SearchFilter.
	// This accepts an OR of AND (List of List) input where:
	//
	// * Top level list
	// specifies conditions that need to be applied with OR operator
	//
	// * Inner list
	// specifies conditions that need to be applied with AND operator.
	TagFilter *ControlPlaneTagFilter

	noSmithyDocumentSerde
}

// Contains summary information about a routing profile.
type RoutingProfileSummary struct {

	// The Amazon Resource Name (ARN) of the routing profile.
	Arn *string

	// The identifier of the routing profile.
	Id *string

	// The name of the routing profile.
	Name *string

	noSmithyDocumentSerde
}

// Information about the Amazon Simple Storage Service (Amazon S3) storage type.
type S3Config struct {

	// The S3 bucket name.
	//
	// This member is required.
	BucketName *string

	// The S3 bucket prefix.
	//
	// This member is required.
	BucketPrefix *string

	// The Amazon S3 encryption configuration.
	EncryptionConfig *EncryptionConfig

	noSmithyDocumentSerde
}

// Configuration information of the security key.
type SecurityKey struct {

	// The existing association identifier that uniquely identifies the resource type
	// and storage config for the given instance ID.
	AssociationId *string

	// When the security key was created.
	CreationTime *time.Time

	// The key of the security key.
	Key *string

	noSmithyDocumentSerde
}

// Contains information about a security profile.
type SecurityProfile struct {

	// The Amazon Resource Name (ARN) for the secruity profile.
	Arn *string

	// The description of the security profile.
	Description *string

	// The identifier for the security profile.
	Id *string

	// The organization resource identifier for the security profile.
	OrganizationResourceId *string

	// The name for the security profile.
	SecurityProfileName *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The search criteria to be used to return security profiles.
type SecurityProfileSearchCriteria struct {

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []SecurityProfileSearchCriteria

	// A list of conditions which would be applied together with an OR condition.
	OrConditions []SecurityProfileSearchCriteria

	// A leaf node condition which can be used to specify a string condition. The
	// currently supported value for FieldName: name
	StringCondition *StringCondition

	noSmithyDocumentSerde
}

// Information about the returned security profiles.
type SecurityProfileSearchSummary struct {

	// The Amazon Resource Name (ARN) of the security profile.
	Arn *string

	// The description of the security profile.
	Description *string

	// The identifier of the security profile.
	Id *string

	// The organization resource identifier.
	OrganizationResourceId *string

	// The name of the security profile.
	SecurityProfileName *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Filters to be applied to search results.
type SecurityProfilesSearchFilter struct {

	// An object that can be used to specify Tag conditions inside the SearchFilter.
	// This accepts an OR of AND (List of List) input where:
	//
	// * Top level list
	// specifies conditions that need to be applied with OR operator
	//
	// * Inner list
	// specifies conditions that need to be applied with AND operator.
	TagFilter *ControlPlaneTagFilter

	noSmithyDocumentSerde
}

// Contains information about a security profile.
type SecurityProfileSummary struct {

	// The Amazon Resource Name (ARN) of the security profile.
	Arn *string

	// The identifier of the security profile.
	Id *string

	// The name of the security profile.
	Name *string

	noSmithyDocumentSerde
}

// A leaf node condition which can be used to specify a string condition. The
// currently supported value for FieldName: name
type StringCondition struct {

	// The type of comparison to be made when evaluating the string condition.
	ComparisonType StringComparisonType

	// The name of the field in the string condition.
	FieldName *string

	// The value of the string.
	Value *string

	noSmithyDocumentSerde
}

// Information about a reference when the referenceType is STRING. Otherwise, null.
type StringReference struct {

	// Identifier of the string reference.
	Name *string

	// A valid string.
	Value *string

	noSmithyDocumentSerde
}

// A leaf node condition which can be used to specify a tag condition, for example,
// HAVE BPO = 123.
type TagCondition struct {

	// The tag key in the tag condition.
	TagKey *string

	// The tag value in the tag condition.
	TagValue *string

	noSmithyDocumentSerde
}

// Describes constraints that apply to the template fields.
type TaskTemplateConstraints struct {

	// Lists the fields that are invisible to agents.
	InvisibleFields []InvisibleFieldInfo

	// Lists the fields that are read-only to agents, and cannot be edited.
	ReadOnlyFields []ReadOnlyFieldInfo

	// Lists the fields that are required to be filled by agents.
	RequiredFields []RequiredFieldInfo

	noSmithyDocumentSerde
}

// Describes a default field and its corresponding value.
type TaskTemplateDefaultFieldValue struct {

	// Default value for the field.
	DefaultValue *string

	// Identifier of a field.
	Id *TaskTemplateFieldIdentifier

	noSmithyDocumentSerde
}

// Describes default values for fields on a template.
type TaskTemplateDefaults struct {

	// Default value for the field.
	DefaultFieldValues []TaskTemplateDefaultFieldValue

	noSmithyDocumentSerde
}

// Describes a single task template field.
type TaskTemplateField struct {

	// The unique identifier for the field.
	//
	// This member is required.
	Id *TaskTemplateFieldIdentifier

	// The description of the field.
	Description *string

	// A list of options for a single select field.
	SingleSelectOptions []string

	// Indicates the type of field.
	Type TaskTemplateFieldType

	noSmithyDocumentSerde
}

// The identifier of the task template field.
type TaskTemplateFieldIdentifier struct {

	// The name of the task template field.
	Name *string

	noSmithyDocumentSerde
}

// Contains summary information about the task template.
type TaskTemplateMetadata struct {

	// The Amazon Resource Name (ARN) of the task template.
	Arn *string

	// The timestamp when the task template was created.
	CreatedTime *time.Time

	// The description of the task template.
	Description *string

	// A unique identifier for the task template.
	Id *string

	// The timestamp when the task template was last modified.
	LastModifiedTime *time.Time

	// The name of the task template.
	Name *string

	// Marks a template as ACTIVE or INACTIVE for a task to refer to it. Tasks can only
	// be created from ACTIVE templates. If a template is marked as INACTIVE, then a
	// task that refers to this template cannot be created.
	Status TaskTemplateStatus

	noSmithyDocumentSerde
}

// The distribution of traffic between the instance and its replicas.
type TelephonyConfig struct {

	// Information about traffic distributions.
	//
	// This member is required.
	Distributions []Distribution

	noSmithyDocumentSerde
}

// Contains information about the threshold for service level metrics.
type Threshold struct {

	// The type of comparison. Only "less than" (LT) comparisons are supported.
	Comparison Comparison

	// The threshold value to compare.
	ThresholdValue *float64

	noSmithyDocumentSerde
}

// Information about a traffic distribution group.
type TrafficDistributionGroup struct {

	// The Amazon Resource Name (ARN) of the traffic distribution group.
	Arn *string

	// The description of the traffic distribution group.
	Description *string

	// The identifier of the traffic distribution group. This can be the ID or the ARN
	// if the API is being called in the Region where the traffic distribution group
	// was created. The ARN must be provided if the call is from the replicated Region.
	Id *string

	// The Amazon Resource Name (ARN).
	InstanceArn *string

	// The name of the traffic distribution group.
	Name *string

	// The status of the traffic distribution group.
	//
	// * CREATION_IN_PROGRESS means the
	// previous CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	//
	// * ACTIVE means the
	// previous CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation has succeeded.
	//
	// * CREATION_FAILED indicates that the previous
	// CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation has failed.
	//
	// * PENDING_DELETION means the previous
	// DeleteTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	//
	// * DELETION_FAILED
	// means the previous DeleteTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html)
	// operation has failed.
	//
	// * UPDATE_IN_PROGRESS means the previous
	// UpdateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	Status TrafficDistributionGroupStatus

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Information about traffic distribution groups.
type TrafficDistributionGroupSummary struct {

	// The Amazon Resource Name (ARN) of the traffic distribution group.
	Arn *string

	// The identifier of the traffic distribution group. This can be the ID or the ARN
	// if the API is being called in the Region where the traffic distribution group
	// was created. The ARN must be provided if the call is from the replicated Region.
	Id *string

	// The Amazon Resource Name (ARN) of the traffic distribution group.
	InstanceArn *string

	// The name of the traffic distribution group.
	Name *string

	// The status of the traffic distribution group.
	//
	// * CREATION_IN_PROGRESS means the
	// previous CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	//
	// * ACTIVE means the
	// previous CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation has succeeded.
	//
	// * CREATION_FAILED indicates that the previous
	// CreateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html)
	// operation has failed.
	//
	// * PENDING_DELETION means the previous
	// DeleteTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	//
	// * DELETION_FAILED
	// means the previous DeleteTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html)
	// operation has failed.
	//
	// * UPDATE_IN_PROGRESS means the previous
	// UpdateTrafficDistributionGroup
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html)
	// operation is still in progress and has not yet completed.
	Status TrafficDistributionGroupStatus

	noSmithyDocumentSerde
}

// The URL reference.
type UrlReference struct {

	// Identifier of the URL reference.
	Name *string

	// A valid URL.
	Value *string

	noSmithyDocumentSerde
}

// Contains the use case.
type UseCase struct {

	// The Amazon Resource Name (ARN) for the use case.
	UseCaseArn *string

	// The identifier for the use case.
	UseCaseId *string

	// The type of use case to associate to the integration association. Each
	// integration association can have only one of each use case type.
	UseCaseType UseCaseType

	noSmithyDocumentSerde
}

// Contains information about a user account for an Amazon Connect instance.
type User struct {

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string

	// The identifier of the user account in the directory used for identity
	// management.
	DirectoryUserId *string

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string

	// The identifier of the user account.
	Id *string

	// Information about the user identity.
	IdentityInfo *UserIdentityInfo

	// Information about the phone configuration for the user.
	PhoneConfig *UserPhoneConfig

	// The identifier of the routing profile for the user.
	RoutingProfileId *string

	// The identifiers of the security profiles for the user.
	SecurityProfileIds []string

	// The tags.
	Tags map[string]string

	// The user name assigned to the user account.
	Username *string

	noSmithyDocumentSerde
}

// Data for a user.
type UserData struct {

	// A map of active slots by channel. The key is a channel name. The value is an
	// integer: the number of active slots.
	ActiveSlotsByChannel map[string]int32

	// A map of available slots by channel. The key is a channel name. The value is an
	// integer: the available number of slots.
	AvailableSlotsByChannel map[string]int32

	// A list of contact reference information.
	Contacts []AgentContactReference

	// Contains information about the levels of a hierarchy group assigned to a user.
	HierarchyPath *HierarchyPathReference

	// A map of maximum slots by channel. The key is a channel name. The value is an
	// integer: the maximum number of slots. This is calculated from MediaConcurrency
	// (https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html)
	// of the RoutingProfile assigned to the agent.
	MaxSlotsByChannel map[string]int32

	// Information about the routing profile that is assigned to the user.
	RoutingProfile *RoutingProfileReference

	// The status of the agent that they manually set in their Contact Control Panel
	// (CCP), or that the supervisor manually changes in the real-time metrics report.
	Status *AgentStatusReference

	// Information about the user for the data that is returned. It contains the
	// resourceId and ARN of the user.
	User *UserReference

	noSmithyDocumentSerde
}

// A filter for the user data.
type UserDataFilters struct {

	// A filter for the user data based on the contact information that is associated
	// to the user. It contains a list of contact states.
	ContactFilter *ContactFilter

	// Contains information about a queue resource for which metrics are returned.
	Queues []string

	noSmithyDocumentSerde
}

// Contains information about the identity of a user.
type UserIdentityInfo struct {

	// The email address. If you are using SAML for identity management and include
	// this parameter, an error is returned.
	Email *string

	// The first name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	FirstName *string

	// The last name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	LastName *string

	// The user's mobile number.
	Mobile *string

	// The user's secondary email address. If you provide a secondary email, the user
	// receives email notifications - other than password reset notifications - to this
	// email address instead of to their primary email address. Pattern:
	// (?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}
	SecondaryEmail *string

	noSmithyDocumentSerde
}

// The user's first name and last name.
type UserIdentityInfoLite struct {

	// The user's first name.
	FirstName *string

	// The user's last name.
	LastName *string

	noSmithyDocumentSerde
}

// Contains information about the phone configuration settings for a user.
type UserPhoneConfig struct {

	// The phone type.
	//
	// This member is required.
	PhoneType PhoneType

	// The After Call Work (ACW) timeout setting, in seconds. When returned by a
	// SearchUsers call, AfterContactWorkTimeLimit is returned in milliseconds.
	AfterContactWorkTimeLimit int32

	// The Auto accept setting.
	AutoAccept bool

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string

	noSmithyDocumentSerde
}

// Contains information about the quick connect configuration settings for a user.
// The contact flow must be of type Transfer to Agent.
type UserQuickConnectConfig struct {

	// The identifier of the flow.
	//
	// This member is required.
	ContactFlowId *string

	// The identifier of the user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// Information about the user.
type UserReference struct {

	// The Amazon Resource Name (ARN) for the user.
	Arn *string

	// The unique identifier for the user.
	Id *string

	noSmithyDocumentSerde
}

// The search criteria to be used to return users. The Username, Firstname, and
// Lastname fields support "contains" queries with a minimum of 2 characters and a
// maximum of 25 characters. Any queries with character lengths outside of this
// range result in empty results.
type UserSearchCriteria struct {

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []UserSearchCriteria

	// A leaf node condition which can be used to specify a hierarchy group condition.
	HierarchyGroupCondition *HierarchyGroupCondition

	// A list of conditions which would be applied together with an OR condition.
	OrConditions []UserSearchCriteria

	// A leaf node condition which can be used to specify a string condition.
	StringCondition *StringCondition

	noSmithyDocumentSerde
}

// Filters to be applied to search results.
type UserSearchFilter struct {

	// An object that can be used to specify Tag conditions inside the SearchFilter.
	// This accepts an OR of AND (List of List) input where:
	//
	// * Top level list
	// specifies conditions that need to be applied with OR operator
	//
	// * Inner list
	// specifies conditions that need to be applied with AND operator.
	TagFilter *ControlPlaneTagFilter

	noSmithyDocumentSerde
}

// Information about the returned users.
type UserSearchSummary struct {

	// The Amazon Resource Name (ARN) of the user.
	Arn *string

	// The directory identifier of the user.
	DirectoryUserId *string

	// The identifier of the user's hierarchy group.
	HierarchyGroupId *string

	// The identifier of the user's summary.
	Id *string

	// The user's first name and last name.
	IdentityInfo *UserIdentityInfoLite

	// Contains information about the phone configuration settings for a user.
	PhoneConfig *UserPhoneConfig

	// The identifier of the user's routing profile.
	RoutingProfileId *string

	// The identifiers of the user's security profiles.
	SecurityProfileIds []string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	// The name of the user.
	Username *string

	noSmithyDocumentSerde
}

// Contains summary information about a user.
type UserSummary struct {

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string

	// The identifier of the user account.
	Id *string

	// The Amazon Connect user name of the user account.
	Username *string

	noSmithyDocumentSerde
}

// Contains information about a custom vocabulary.
type Vocabulary struct {

	// The Amazon Resource Name (ARN) of the custom vocabulary.
	//
	// This member is required.
	Arn *string

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	Id *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The timestamp when the custom vocabulary was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	Name *string

	// The current state of the custom vocabulary.
	//
	// This member is required.
	State VocabularyState

	// The content of the custom vocabulary in plain-text format with a table of
	// values. Each row in the table represents a word or a phrase, described with
	// Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB
	// characters. For more information, see Create a custom vocabulary using a table
	// (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
	Content *string

	// The reason why the custom vocabulary was not created.
	FailureReason *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains summary information about the custom vocabulary.
type VocabularySummary struct {

	// The Amazon Resource Name (ARN) of the custom vocabulary.
	//
	// This member is required.
	Arn *string

	// The identifier of the custom vocabulary.
	//
	// This member is required.
	Id *string

	// The language code of the vocabulary entries. For a list of languages and their
	// corresponding language codes, see What is Amazon Transcribe?
	// (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// This member is required.
	LanguageCode VocabularyLanguageCode

	// The timestamp when the custom vocabulary was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A unique name of the custom vocabulary.
	//
	// This member is required.
	Name *string

	// The current state of the custom vocabulary.
	//
	// This member is required.
	State VocabularyState

	// The reason why the custom vocabulary was not created.
	FailureReason *string

	noSmithyDocumentSerde
}

// Contains information about the recording configuration settings.
type VoiceRecordingConfiguration struct {

	// Identifies which track is being recorded.
	VoiceRecordingTrack VoiceRecordingTrack

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isReferenceSummary() {}
