// Code generated by smithy-go-codegen DO NOT EDIT.

package databrew

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/databrew/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new ruleset that can be used in a profile job to validate the data
// quality of a dataset.
func (c *Client) CreateRuleset(ctx context.Context, params *CreateRulesetInput, optFns ...func(*Options)) (*CreateRulesetOutput, error) {
	if params == nil {
		params = &CreateRulesetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRuleset", params, optFns, c.addOperationCreateRulesetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRulesetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRulesetInput struct {

	// The name of the ruleset to be created. Valid characters are alphanumeric (A-Z,
	// a-z, 0-9), hyphen (-), period (.), and space.
	//
	// This member is required.
	Name *string

	// A list of rules that are defined with the ruleset. A rule includes one or more
	// checks to be validated on a DataBrew dataset.
	//
	// This member is required.
	Rules []types.Rule

	// The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
	// associated with.
	//
	// This member is required.
	TargetArn *string

	// The description of the ruleset.
	Description *string

	// Metadata tags to apply to the ruleset.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateRulesetOutput struct {

	// The unique name of the created ruleset.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRulesetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRuleset{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRuleset{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateRulesetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRuleset(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRuleset(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "databrew",
		OperationName: "CreateRuleset",
	}
}
