//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurestackhci

import "time"

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string

	// The type of the extended location.
	Type *ExtendedLocationTypes
}

// GalleryImageIdentifier - This is the gallery image definition identifier.
type GalleryImageIdentifier struct {
	// REQUIRED; The name of the gallery image definition offer.
	Offer *string

	// REQUIRED; The name of the gallery image definition publisher.
	Publisher *string

	// REQUIRED; The name of the gallery image definition SKU.
	SKU *string
}

// GalleryImageProperties - Properties under the gallery image resource
type GalleryImageProperties struct {
	// REQUIRED; Operating system type that the gallery image uses [Windows, Linux]
	OSType *OperatingSystemTypes

	// Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
	CloudInitDataSource *CloudInitDataSource

	// Storage ContainerID of the storage container to be used for gallery image
	ContainerID *string

	// The hypervisor generation of the Virtual Machine [V1, V2]
	HyperVGeneration *HyperVGeneration

	// This is the gallery image definition identifier.
	Identifier *GalleryImageIdentifier

	// location of the image the gallery image should be created from
	ImagePath *string

	// Specifies information about the gallery image version that you want to create or update.
	Version *GalleryImageVersion

	// READ-ONLY; Provisioning state of the gallery image.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of gallery images
	Status *GalleryImageStatus
}

// GalleryImageStatus - The observed state of gallery images
type GalleryImageStatus struct {
	// The download status of the gallery image
	DownloadStatus *GalleryImageStatusDownloadStatus

	// GalleryImage provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage *string

	// The progress of the operation in percentage
	ProgressPercentage *int64
	ProvisioningStatus *GalleryImageStatusProvisioningStatus
}

// GalleryImageStatusDownloadStatus - The download status of the gallery image
type GalleryImageStatusDownloadStatus struct {
	// The downloaded sized of the image in MB
	DownloadSizeInMB *int64
}

type GalleryImageStatusProvisioningStatus struct {
	// The ID of the operation performed on the gallery image
	OperationID *string

	// The status of the operation performed on the gallery image [Succeeded, Failed, InProgress]
	Status *Status
}

// GalleryImageVersion - Specifies information about the gallery image version that you want to create or update.
type GalleryImageVersion struct {
	// This is the version of the gallery image.
	Name *string

	// Describes the properties of a gallery image version.
	Properties *GalleryImageVersionProperties
}

// GalleryImageVersionProperties - Describes the properties of a gallery image version.
type GalleryImageVersionProperties struct {
	// REQUIRED; This is the storage profile of a Gallery Image Version.
	StorageProfile *GalleryImageVersionStorageProfile
}

// GalleryImageVersionStorageProfile - This is the storage profile of a Gallery Image Version.
type GalleryImageVersionStorageProfile struct {
	// This is the OS disk image.
	OSDiskImage *GalleryOSDiskImage
}

// GalleryImages - The gallery images resource definition.
type GalleryImages struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the gallery image resource
	Properties *GalleryImageProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GalleryImagesListResult - List of gallery images.
type GalleryImagesListResult struct {
	Value []*GalleryImages

	// READ-ONLY; Link to the next set of results.
	NextLink *string
}

// GalleryImagesUpdateRequest - The gallery images resource patch definition.
type GalleryImagesUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

// GalleryOSDiskImage - This is the OS disk image.
type GalleryOSDiskImage struct {
	// READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInMB *int64
}

// GuestAgent - Defines the GuestAgent.
type GuestAgent struct {
	// REQUIRED; Resource properties.
	Properties *GuestAgentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GuestAgentInstallStatus - Defines the status of a guest agent installation.
type GuestAgentInstallStatus struct {
	// READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string

	// READ-ONLY; Details about the error state.
	ErrorDetails []*ErrorDetail

	// READ-ONLY; The time of the last status change.
	LastStatusChange *time.Time

	// READ-ONLY; The installation status of the hybrid machine agent installation.
	Status *StatusTypes

	// READ-ONLY; Specifies the VM's unique SMBIOS ID.
	VMUUID *string
}

// GuestAgentList - List of GuestAgent.
type GuestAgentList struct {
	// REQUIRED; Array of GuestAgent
	Value []*GuestAgent

	// Url to follow for getting next page of GuestAgent.
	NextLink *string
}

// GuestAgentProperties - Defines the resource properties.
type GuestAgentProperties struct {
	// Username / Password Credentials to provision guest agent.
	Credentials *GuestCredential

	// The guest agent provisioning action.
	ProvisioningAction *ProvisioningAction

	// READ-ONLY; The provisioning state.
	ProvisioningState *string

	// READ-ONLY; The guest agent status.
	Status *string
}

// GuestCredential - Username / Password Credentials to connect to guest.
type GuestCredential struct {
	// The password to connect with the guest.
	Password *string

	// The username to connect with the guest.
	Username *string
}

// HTTPProxyConfiguration - HTTP Proxy configuration for the VM.
type HTTPProxyConfiguration struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string

	// The endpoints that should not go through proxy.
	NoProxy []*string

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string
}

// HardwareProfileUpdate - HardwareProfile - Specifies the hardware settings for the virtual machine instance.
type HardwareProfileUpdate struct {
	// RAM in MB for the virtual machine instance
	MemoryMB *int64

	// number of processors for the virtual machine instance
	Processors *int32
	VMSize     *VMSizeEnum
}

// HybridIdentityMetadata - Defines the HybridIdentityMetadata.
type HybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *HybridIdentityMetadataProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HybridIdentityMetadataList - List of HybridIdentityMetadata.
type HybridIdentityMetadataList struct {
	// REQUIRED; Array of HybridIdentityMetadata
	Value []*HybridIdentityMetadata

	// Url to follow for getting next page of HybridIdentityMetadata.
	NextLink *string
}

// HybridIdentityMetadataProperties - Defines the resource properties.
type HybridIdentityMetadataProperties struct {
	// The Public Key.
	PublicKey *string

	// The unique identifier for the resource.
	ResourceUID *string

	// READ-ONLY; Identity for the resource.
	Identity *Identity

	// READ-ONLY; The provisioning state.
	ProvisioningState *string
}

// IPConfiguration - InterfaceIPConfiguration iPConfiguration in a network interface.
type IPConfiguration struct {
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
	Properties *IPConfigurationProperties
}

// IPConfigurationProperties - InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
type IPConfigurationProperties struct {
	// PrivateIPAddress - Private IP address of the IP configuration.
	PrivateIPAddress *string

	// Subnet - Name of Subnet bound to the IP configuration.
	Subnet *IPConfigurationPropertiesSubnet

	// READ-ONLY; Gateway for network interface
	Gateway *string

	// READ-ONLY; prefixLength for network interface
	PrefixLength *string
}

// IPConfigurationPropertiesSubnet - Subnet - Name of Subnet bound to the IP configuration.
type IPConfigurationPropertiesSubnet struct {
	// ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string
}

type IPPool struct {
	// End of the IP address pool
	End *string

	// Type of the IP Pool [vm, vippool]
	IPPoolType *IPPoolTypeEnum
	Info       *IPPoolInfo

	// Name of the IP-Pool
	Name *string

	// Start of the IP address pool
	Start *string
}

type IPPoolInfo struct {
	// READ-ONLY; Number of IP addresses available in the IP Pool
	Available *string

	// READ-ONLY; Number of IP addresses allocated from the IP Pool
	Used *string
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// InstanceViewStatus - Instance view status.
type InstanceViewStatus struct {
	// The status code.
	Code *string

	// The short localizable label for the status.
	DisplayStatus *string

	// The level code.
	Level *StatusLevelTypes

	// The detailed status message, including for alerts and error messages.
	Message *string

	// The time of the status.
	Time *time.Time
}

type InterfaceDNSSettings struct {
	// List of DNS server IP Addresses for the interface
	DNSServers []*string
}

// LogicalNetworkProperties - Properties under the logical network resource
type LogicalNetworkProperties struct {
	// DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for
	// a subnet overrides logical network DHCP options.
	DhcpOptions *LogicalNetworkPropertiesDhcpOptions

	// Subnet - list of subnets under the logical network
	Subnets []*Subnet

	// name of the network switch to be used for VMs
	VMSwitchName *string

	// READ-ONLY; Provisioning state of the logical network.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of logical networks
	Status *LogicalNetworkStatus
}

// LogicalNetworkPropertiesDhcpOptions - DhcpOptions contains an array of DNS servers available to VMs deployed in the logical
// network. Standard DHCP option for a subnet overrides logical network DHCP options.
type LogicalNetworkPropertiesDhcpOptions struct {
	// The list of DNS servers IP addresses.
	DNSServers []*string
}

// LogicalNetworkStatus - The observed state of logical networks
type LogicalNetworkStatus struct {
	// LogicalNetwork provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage       *string
	ProvisioningStatus *LogicalNetworkStatusProvisioningStatus
}

type LogicalNetworkStatusProvisioningStatus struct {
	// The ID of the operation performed on the logical network
	OperationID *string

	// The status of the operation performed on the logical network [Succeeded, Failed, InProgress]
	Status *Status
}

// LogicalNetworks - The logical network resource definition.
type LogicalNetworks struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the logical network resource
	Properties *LogicalNetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type LogicalNetworksListResult struct {
	NextLink *string
	Value    []*LogicalNetworks
}

// LogicalNetworksUpdateRequest - The logical network resource patch definition.
type LogicalNetworksUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

// MarketplaceGalleryImageProperties - Properties under the marketplace gallery image resource
type MarketplaceGalleryImageProperties struct {
	// REQUIRED; Operating system type that the gallery image uses [Windows, Linux]
	OSType *OperatingSystemTypes

	// Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
	CloudInitDataSource *CloudInitDataSource

	// Storage ContainerID of the storage container to be used for marketplace gallery image
	ContainerID *string

	// The hypervisor generation of the Virtual Machine [V1, V2]
	HyperVGeneration *HyperVGeneration

	// This is the gallery image definition identifier.
	Identifier *GalleryImageIdentifier

	// Specifies information about the gallery image version that you want to create or update.
	Version *GalleryImageVersion

	// READ-ONLY; Provisioning state of the marketplace gallery image.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of marketplace gallery images
	Status *MarketplaceGalleryImageStatus
}

// MarketplaceGalleryImageStatus - The observed state of marketplace gallery images
type MarketplaceGalleryImageStatus struct {
	// The download status of the gallery image
	DownloadStatus *MarketplaceGalleryImageStatusDownloadStatus

	// MarketplaceGalleryImage provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage *string

	// The progress of the operation in percentage
	ProgressPercentage *int64
	ProvisioningStatus *MarketplaceGalleryImageStatusProvisioningStatus
}

// MarketplaceGalleryImageStatusDownloadStatus - The download status of the gallery image
type MarketplaceGalleryImageStatusDownloadStatus struct {
	// The downloaded sized of the image in MB
	DownloadSizeInMB *int64
}

type MarketplaceGalleryImageStatusProvisioningStatus struct {
	// The ID of the operation performed on the gallery image
	OperationID *string

	// The status of the operation performed on the gallery image [Succeeded, Failed, InProgress]
	Status *Status
}

// MarketplaceGalleryImages - The marketplace gallery image resource definition.
type MarketplaceGalleryImages struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the marketplace gallery image resource
	Properties *MarketplaceGalleryImageProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type MarketplaceGalleryImagesListResult struct {
	NextLink *string
	Value    []*MarketplaceGalleryImages
}

// MarketplaceGalleryImagesUpdateRequest - The marketplace gallery image resource patch definition.
type MarketplaceGalleryImagesUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

// NetworkInterfaceProperties - Properties under the network interface resource
type NetworkInterfaceProperties struct {
	// DNS Settings for the interface
	DNSSettings *InterfaceDNSSettings

	// IPConfigurations - A list of IPConfigurations of the network interface.
	IPConfigurations []*IPConfiguration

	// MacAddress - The MAC address of the network interface.
	MacAddress *string

	// READ-ONLY; Provisioning state of the network interface.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of network interfaces
	Status *NetworkInterfaceStatus
}

// NetworkInterfaceStatus - The observed state of network interfaces
type NetworkInterfaceStatus struct {
	// NetworkInterface provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage       *string
	ProvisioningStatus *NetworkInterfaceStatusProvisioningStatus
}

type NetworkInterfaceStatusProvisioningStatus struct {
	// The ID of the operation performed on the network interface
	OperationID *string

	// The status of the operation performed on the network interface [Succeeded, Failed, InProgress]
	Status *Status
}

// NetworkInterfaces - The network interface resource definition.
type NetworkInterfaces struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the network interface resource
	Properties *NetworkInterfaceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type NetworkInterfacesListResult struct {
	NextLink *string
	Value    []*NetworkInterfaces
}

// NetworkInterfacesUpdateRequest - The network interface resource patch definition.
type NetworkInterfacesUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

// NetworkProfileUpdate - NetworkProfile - describes the network update configuration the virtual machine instance
type NetworkProfileUpdate struct {
	// NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
	NetworkInterfaces []*NetworkProfileUpdateNetworkInterfacesItem
}

type NetworkProfileUpdateNetworkInterfacesItem struct {
	// ID - Resource ID of the network interface
	ID *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OsProfileUpdate - OsProfile - describes the update configuration of the operating system
type OsProfileUpdate struct {
	// ComputerName - name of the computer
	ComputerName         *string
	LinuxConfiguration   *OsProfileUpdateLinuxConfiguration
	WindowsConfiguration *OsProfileUpdateWindowsConfiguration
}

type OsProfileUpdateLinuxConfiguration struct {
	// Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation
	// process.
	ProvisionVMAgent *bool

	// Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
	ProvisionVMConfigAgent *bool
}

type OsProfileUpdateWindowsConfiguration struct {
	// Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation
	// process.
	ProvisionVMAgent *bool

	// Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
	ProvisionVMConfigAgent *bool
}

// Route - Route resource.
type Route struct {
	// Name - name of the subnet
	Name *string

	// Properties of the route.
	Properties *RoutePropertiesFormat
}

// RoutePropertiesFormat - Route resource.
type RoutePropertiesFormat struct {
	// The destination CIDR to which the route applies.
	AddressPrefix *string

	// The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string
}

// RouteTable - Route table resource.
type RouteTable struct {
	// Properties of the route table.
	Properties *RouteTablePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RouteTablePropertiesFormat - Route Table resource.
type RouteTablePropertiesFormat struct {
	// Collection of routes contained within a route table.
	Routes []*Route
}

// SSHConfiguration - SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys []*SSHPublicKey
}

// SSHPublicKey - Contains information about SSH certificate public key and the path on the Linux VM where the public key
// is placed.
type SSHPublicKey struct {
	// SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa
	// format.
	// For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
	KeyData *string

	// Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key
	// is appended to the file. Example: /home/user/.ssh/authorized_keys
	Path *string
}

// StorageContainerProperties - Properties under the storage container resource
type StorageContainerProperties struct {
	// REQUIRED; Path of the storage container on the disk
	Path *string

	// READ-ONLY; Provisioning state of the storage container.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of storage containers
	Status *StorageContainerStatus
}

// StorageContainerStatus - The observed state of storage containers
type StorageContainerStatus struct {
	// Amount of space available on the disk in MB
	AvailableSizeMB *int64

	// Total size of the disk in MB
	ContainerSizeMB *int64

	// StorageContainer provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage       *string
	ProvisioningStatus *StorageContainerStatusProvisioningStatus
}

type StorageContainerStatusProvisioningStatus struct {
	// The ID of the operation performed on the storage container
	OperationID *string

	// The status of the operation performed on the storage container [Succeeded, Failed, InProgress]
	Status *Status
}

// StorageContainers - The storage container resource definition.
type StorageContainers struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the storage container resource
	Properties *StorageContainerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type StorageContainersListResult struct {
	NextLink *string
	Value    []*StorageContainers
}

// StorageContainersUpdateRequest - The storage container resource patch definition.
type StorageContainersUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

type StorageProfileUpdate struct {
	// adds data disks to the virtual machine instance for the update call
	DataDisks []*StorageProfileUpdateDataDisksItem
}

type StorageProfileUpdateDataDisksItem struct {
	ID *string
}

type Subnet struct {
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the subnet.
	Properties *SubnetPropertiesFormat
}

// SubnetPropertiesFormat - Properties of the subnet.
type SubnetPropertiesFormat struct {
	// The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
	AddressPrefix *string

	// List of address prefixes for the subnet.
	AddressPrefixes []*string

	// IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
	IPAllocationMethod *IPAllocationMethodEnum

	// IPConfigurationReferences - list of IPConfigurationReferences
	IPConfigurationReferences []*SubnetPropertiesFormatIPConfigurationReferencesItem

	// network associated pool of IP Addresses
	IPPools []*IPPool

	// Route table resource.
	RouteTable *RouteTable

	// Vlan to use for the subnet
	Vlan *int32
}

// SubnetPropertiesFormatIPConfigurationReferencesItem - IPConfigurationReference - Describes a IPConfiguration under the
// virtual network
type SubnetPropertiesFormatIPConfigurationReferencesItem struct {
	// IPConfigurationID
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// VirtualHardDiskProperties - Properties under the virtual hard disk resource
type VirtualHardDiskProperties struct {
	BlockSizeBytes *int32

	// Storage ContainerID of the storage container to be used for VHD
	ContainerID *string

	// The format of the actual VHD file [vhd, vhdx]
	DiskFileFormat *DiskFileFormat

	// Size of the disk in GB
	DiskSizeGB *int64

	// Boolean for enabling dynamic sizing on the virtual hard disk
	Dynamic *bool

	// The hypervisor generation of the Virtual Machine [V1, V2]
	HyperVGeneration    *HyperVGeneration
	LogicalSectorBytes  *int32
	PhysicalSectorBytes *int32

	// READ-ONLY; Provisioning state of the virtual hard disk.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of virtual hard disks
	Status *VirtualHardDiskStatus
}

// VirtualHardDiskStatus - The observed state of virtual hard disks
type VirtualHardDiskStatus struct {
	// VirtualHardDisk provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage       *string
	ProvisioningStatus *VirtualHardDiskStatusProvisioningStatus
}

type VirtualHardDiskStatusProvisioningStatus struct {
	// The ID of the operation performed on the virtual hard disk
	OperationID *string

	// The status of the operation performed on the virtual hard disk [Succeeded, Failed, InProgress]
	Status *Status
}

// VirtualHardDisks - The virtual hard disk resource definition.
type VirtualHardDisks struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Properties under the virtual hard disk resource
	Properties *VirtualHardDiskProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type VirtualHardDisksListResult struct {
	NextLink *string
	Value    []*VirtualHardDisks
}

// VirtualHardDisksUpdateRequest - The virtual hard disk resource patch definition.
type VirtualHardDisksUpdateRequest struct {
	// Resource tags
	Tags map[string]*string
}

// VirtualMachineConfigAgentInstanceView - The instance view of the VM Config Agent running on the virtual machine.
type VirtualMachineConfigAgentInstanceView struct {
	// The resource status information.
	Statuses []*InstanceViewStatus

	// The VM Config Agent full version.
	VMConfigAgentVersion *string
}

// VirtualMachineInstance - The virtual machine instance resource definition.
type VirtualMachineInstance struct {
	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// Identity for the resource.
	Identity *Identity

	// Properties under the virtual machine instance resource
	Properties *VirtualMachineInstanceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type VirtualMachineInstanceListResult struct {
	NextLink *string
	Value    []*VirtualMachineInstance
}

// VirtualMachineInstanceProperties - Properties under the virtual machine instance resource
type VirtualMachineInstanceProperties struct {
	// Guest agent install status.
	GuestAgentInstallStatus *GuestAgentInstallStatus

	// HTTP Proxy configuration for the VM.
	HTTPProxyConfig *HTTPProxyConfiguration

	// HardwareProfile - Specifies the hardware settings for the virtual machine instance.
	HardwareProfile *VirtualMachineInstancePropertiesHardwareProfile

	// NetworkProfile - describes the network configuration the virtual machine instance
	NetworkProfile *VirtualMachineInstancePropertiesNetworkProfile

	// OsProfile - describes the configuration of the operating system and sets login data
	OSProfile *VirtualMachineInstancePropertiesOsProfile

	// Unique identifier defined by ARC to identify the guest of the VM.
	ResourceUID *string

	// SecurityProfile - Specifies the security settings for the virtual machine instance.
	SecurityProfile *VirtualMachineInstancePropertiesSecurityProfile

	// StorageProfile - contains information about the disks and storage information for the virtual machine instance
	StorageProfile *VirtualMachineInstancePropertiesStorageProfile

	// READ-ONLY; The virtual machine instance view.
	InstanceView *VirtualMachineInstanceView

	// READ-ONLY; Provisioning state of the virtual machine instance.
	ProvisioningState *ProvisioningStateEnum

	// READ-ONLY; The observed state of virtual machine instances
	Status *VirtualMachineInstanceStatus

	// READ-ONLY; Unique identifier for the vm resource.
	VMID *string
}

// VirtualMachineInstancePropertiesHardwareProfile - HardwareProfile - Specifies the hardware settings for the virtual machine
// instance.
type VirtualMachineInstancePropertiesHardwareProfile struct {
	DynamicMemoryConfig *VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig

	// RAM in MB for the virtual machine instance
	MemoryMB *int64

	// number of processors for the virtual machine instance
	Processors *int32
	VMSize     *VMSizeEnum
}

type VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig struct {
	MaximumMemoryMB *int64
	MinimumMemoryMB *int64

	// Defines the amount of extra memory that should be reserved for a virtual machine instance at runtime, as a percentage of
	// the total memory that the virtual machine instance is thought to need. This
	// only applies to virtual systems with dynamic memory enabled. This property can be in the range of 5 to 2000.
	TargetMemoryBuffer *int32
}

// VirtualMachineInstancePropertiesNetworkProfile - NetworkProfile - describes the network configuration the virtual machine
// instance
type VirtualMachineInstancePropertiesNetworkProfile struct {
	// NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
	NetworkInterfaces []*VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem
}

type VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem struct {
	// ID - Resource Id of the network interface
	ID *string
}

// VirtualMachineInstancePropertiesOsProfile - OsProfile - describes the configuration of the operating system and sets login
// data
type VirtualMachineInstancePropertiesOsProfile struct {
	// AdminPassword - admin password
	AdminPassword *string

	// AdminUsername - admin username
	AdminUsername *string

	// ComputerName - name of the compute
	ComputerName *string

	// LinuxConfiguration - linux specific configuration values for the virtual machine instance
	LinuxConfiguration *VirtualMachineInstancePropertiesOsProfileLinuxConfiguration

	// Windows Configuration for the virtual machine instance
	WindowsConfiguration *VirtualMachineInstancePropertiesOsProfileWindowsConfiguration
}

// VirtualMachineInstancePropertiesOsProfileLinuxConfiguration - LinuxConfiguration - linux specific configuration values
// for the virtual machine instance
type VirtualMachineInstancePropertiesOsProfileLinuxConfiguration struct {
	// DisablePasswordAuthentication - whether password authentication should be disabled
	DisablePasswordAuthentication *bool

	// Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation
	// process.
	ProvisionVMAgent *bool

	// Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
	ProvisionVMConfigAgent *bool

	// Specifies the ssh key configuration for a Linux OS.
	SSH *SSHConfiguration
}

// VirtualMachineInstancePropertiesOsProfileWindowsConfiguration - Windows Configuration for the virtual machine instance
type VirtualMachineInstancePropertiesOsProfileWindowsConfiguration struct {
	// Whether to EnableAutomaticUpdates on the machine
	EnableAutomaticUpdates *bool

	// Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation
	// process.
	ProvisionVMAgent *bool

	// Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
	ProvisionVMConfigAgent *bool

	// Specifies the ssh key configuration for Windows OS.
	SSH *SSHConfiguration

	// TimeZone for the virtual machine instance
	TimeZone *string
}

// VirtualMachineInstancePropertiesSecurityProfile - SecurityProfile - Specifies the security settings for the virtual machine
// instance.
type VirtualMachineInstancePropertiesSecurityProfile struct {
	EnableTPM *bool

	// Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType
	// to function.
	SecurityType *SecurityTypes
	UefiSettings *VirtualMachineInstancePropertiesSecurityProfileUefiSettings
}

type VirtualMachineInstancePropertiesSecurityProfileUefiSettings struct {
	// Specifies whether secure boot should be enabled on the virtual machine instance.
	SecureBootEnabled *bool
}

// VirtualMachineInstancePropertiesStorageProfile - StorageProfile - contains information about the disks and storage information
// for the virtual machine instance
type VirtualMachineInstancePropertiesStorageProfile struct {
	// adds data disks to the virtual machine instance
	DataDisks []*VirtualMachineInstancePropertiesStorageProfileDataDisksItem

	// Which Image to use for the virtual machine instance
	ImageReference *VirtualMachineInstancePropertiesStorageProfileImageReference

	// VHD to attach as OS disk
	OSDisk *VirtualMachineInstancePropertiesStorageProfileOsDisk

	// Id of the storage container that hosts the VM configuration file
	VMConfigStoragePathID *string
}

type VirtualMachineInstancePropertiesStorageProfileDataDisksItem struct {
	// Resource ID of the data disk
	ID *string
}

// VirtualMachineInstancePropertiesStorageProfileImageReference - Which Image to use for the virtual machine instance
type VirtualMachineInstancePropertiesStorageProfileImageReference struct {
	// Resource ID of the image
	ID *string
}

// VirtualMachineInstancePropertiesStorageProfileOsDisk - VHD to attach as OS disk
type VirtualMachineInstancePropertiesStorageProfileOsDisk struct {
	// Resource ID of the OS disk
	ID *string

	// This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or
	// a specialized VHD. Possible values are: Windows, Linux.
	OSType *OperatingSystemTypes
}

// VirtualMachineInstanceStatus - The observed state of virtual machine instances
type VirtualMachineInstanceStatus struct {
	// VirtualMachine provisioning error code
	ErrorCode *string

	// Descriptive error message
	ErrorMessage *string

	// The power state of the virtual machine instance
	PowerState         *PowerStateEnum
	ProvisioningStatus *VirtualMachineInstanceStatusProvisioningStatus
}

type VirtualMachineInstanceStatusProvisioningStatus struct {
	// The ID of the operation performed on the virtual machine instance
	OperationID *string

	// The status of the operation performed on the virtual machine instance [Succeeded, Failed, InProgress]
	Status *Status
}

// VirtualMachineInstanceUpdateProperties - Defines the resource properties for the update.
type VirtualMachineInstanceUpdateProperties struct {
	// HardwareProfile - Specifies the hardware settings for the virtual machine instance.
	HardwareProfile *HardwareProfileUpdate

	// NetworkProfile - describes the network update configuration the virtual machine instance
	NetworkProfile *NetworkProfileUpdate

	// OsProfile - describes the update configuration of the operating system
	OSProfile      *OsProfileUpdate
	StorageProfile *StorageProfileUpdate
}

// VirtualMachineInstanceUpdateRequest - The virtual machine instance resource patch definition.
type VirtualMachineInstanceUpdateRequest struct {
	// Identity for the resource.
	Identity *Identity

	// Defines the resource properties for the update.
	Properties *VirtualMachineInstanceUpdateProperties
}

// VirtualMachineInstanceView - The instance view of a virtual machine.
type VirtualMachineInstanceView struct {
	// The VM Config Agent running on the virtual machine.
	VMAgent *VirtualMachineConfigAgentInstanceView
}
