//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/HealthReports/ListHealthReports_example.json
func ExampleHealthReportsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewHealthReportsClient().NewListPager("subscriptions/a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.HealthReportsList = armsecurity.HealthReportsList{
		// 	Value: []*armsecurity.HealthReport{
		// 		{
		// 			Name: to.Ptr("2351eaac-f8e6-43d8-87c0-a7e2c3d197c0"),
		// 			Type: to.Ptr("Microsoft.Security/healthReports"),
		// 			ID: to.Ptr("/subscriptions/a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2/resourcegroups/ascdemorg/providers/microsoft.compute/virtualmachines/vm3/providers/Microsoft.Security/healthReports/2351eaac-f8e6-43d8-87c0-a7e2c3d197c0"),
		// 			Properties: &armsecurity.HealthReportProperties{
		// 				AffectedDefendersPlans: []*string{
		// 					to.Ptr("DefenderForServers")},
		// 					EnvironmentDetails: &armsecurity.EnvironmentDetails{
		// 						EnvironmentHierarchyID: to.Ptr("a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2"),
		// 						NativeResourceID: to.Ptr("/subscriptions/a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2/resourcegroups/ascdemorg/providers/microsoft.compute/virtualmachines/vm3"),
		// 						OrganizationalHierarchyID: to.Ptr("200d73cf-ba70-4b93-8fa2-25e05e6aa1f6"),
		// 						SubscriptionID: to.Ptr("a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2"),
		// 						TenantID: to.Ptr("200d73cf-ba70-4b93-8fa2-25e05e6aa1f6"),
		// 					},
		// 					HealthDataClassification: &armsecurity.HealthDataClassification{
		// 						Component: to.Ptr("MDE"),
		// 						Scenario: to.Ptr("Reporting"),
		// 						Scope: to.Ptr(armsecurity.ScopeNameVirtualMachines),
		// 					},
		// 					Issues: []*armsecurity.Issue{
		// 					},
		// 					ResourceDetails: &armsecurity.ResourceDetailsAutoGenerated{
		// 						ID: to.Ptr("/subscriptions/a1efb6ca-fbc5-4782-9aaa-5c7daded1ce2/resourcegroups/ascdemorg/providers/microsoft.compute/virtualmachines/vm3"),
		// 						Source: to.Ptr(armsecurity.SourceAzure),
		// 					},
		// 					Status: &armsecurity.StatusAutoGenerated{
		// 						Code: to.Ptr(armsecurity.StatusNameHealthy),
		// 						FirstEvaluationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-12T09:07:18.675Z"); return t}()),
		// 						StatusChangeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-12T09:07:18.675Z"); return t}()),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}
