<p align="center">
  <b>Special thanks to the generous sponsorship by:</b>
  <br><br>
  <a href="https://www.yousails.com">
    <img src="https://yousails.com/banners/brand.png" width=350>
  </a>
</p>

# Android 学习资料收集                                                        

 收集整理这份资料灵感来自于 [trip_to_iOS](https://github.com/Aufree/trip-to-iOS), 征得同意引用了该资料的开头描述

 收集整理这份资料主要帮助初学者学习 Android 开发, 希望能快速帮助到他们快速入门, 找到适合自己学习资料,   节省再去收集学习资料时间.

 这份资料我会不断的更新完善, 同时也欢迎更多具有丰富经验的Android开发者将自己常用的工具、学习资料、学习心得等分享上来, 我将定期筛选合并, 该份学习资料有不足的地方, 也请指出, 我会谦虚接受改正, 希望我能与大家一起来学习, 谢谢.

 **如果您有任何意见或建议也可以通过[邮件](mailto:huanggaojun13@gmail.com)或[微博](http://weibo.com/gaojunhuang)联系我**

>感谢 [@GitHubDaily](http://weibo.com/GitHubDaily) 与 [@Android 开发日常](http://weibo.com/AndroidDevDaily) 的大力支持

## 目录

- [书籍](#书籍)
- [开发环境/工具](#开发环境工具)
- [博客](#博客)
- [社区](#社区)
- [开源项目学习](#开源项目学习)
- [Android 开发者杂志周刊](#android-开发者杂志周刊)
- [Awesome 系列](#awesome-系列)
- [动画系列](#动画系列)
- [Material Design 设计](#material-design-设计)
- [素材](#素材)
- [开源库收集](#开源库收集)
- [设计模式](#设计模式)
- [实践篇](#实践篇)
- [面试](#面试)
- [Git 教程](#git-教程)
- [文档](#文档)
- [其它资料收集](#其它资料收集)
- [知乎上的讨论](#知乎上的讨论)
- [贡献者](#贡献者)
- [License](#license)

=============================================================

## 书籍

  书籍名称  | 推荐理由 
  --------- | --------
[Thinking In Java 中文版](http://www.amazon.cn/Java%E7%BC%96%E7%A8%8B%E6%80%9D%E6%83%B3-%E5%9F%83%E5%8F%B2%E5%B0%94/dp/B0011F7WU4/ref=sr_1_1?ie=UTF8&qid=1428138267&sr=8-1&keywords=java%E7%BC%96%E7%A8%8B%E6%80%9D%E6%83%B3) | 学习 Android 开发, 首先需要 Java 基础, 这里推荐 Thinking In Java, Thinking In Java 是 Java 的经典书籍, 是学习 Java 语言必备书籍
[第一行代码](http://www.amazon.cn/%E7%AC%AC%E4%B8%80%E8%A1%8C%E4%BB%A3%E7%A0%81-Android-%E9%83%AD%E9%9C%96/dp/B00LVHTI9U/ref=sr_1_1?ie=UTF8&qid=1428138432&sr=8-1&keywords=%E7%AC%AC%E4%B8%80%E8%A1%8C%E4%BB%A3%E7%A0%81%E2%80%94%E2%80%94android+%E9%83%AD%E9%9C%96)   | 郭霖大神的杰作, 郭神在CSDN中的博客文章非常不错, 书我看了, 非常适合新手, 里面的内容非常棒, 建议结合郭神博客文章一起来学习 
[疯狂Android讲义第三版](http://item.jd.com/11689014.html) | 作者是李刚, 这本书是基于 Android 5.0 来讲的, 我看过第二版, 这本书给我第一感觉就是很厚, 但里面内容写的还是很详细的, 代码很多, 可以跟着代码一步步敲 
[Android群英传](http://www.amazon.cn/Android%E7%BE%A4%E8%8B%B1%E4%BC%A0-%E5%BE%90%E5%AE%9C%E7%94%9F/dp/B01481RAA4/ref=sr_1_1?m=A1AJ19PSB66TGU&s=books&ie=UTF8&qid=1442198757&sr=1-1&keywords=android%E7%BE%A4%E8%8B%B1%E4%BC%A0) | 本书作者 @Tomcat 的猫, 曾就职于上海 TCL 通讯, 从事 Alcatel(阿尔卡特) Android 手机系统的定制工作, 活跃于 CSDN, 目前就职于上海沪江网 Android 开发部RD项目组, 负责沪江 App 的功能预研
[Android开发艺术探索](http://product.china-pub.com/4806147) | 由@任玉刚Coder所著, 是一本 Android 进阶类书籍, 采用理论, 源码和实践相结合的方式来阐述高水准的 Android 应用开发要点. 本书从三个方面来组织内容: 第一, 介绍 Android 开发者不容易掌握的一些知识点: 第二,结合Android源代码和应用层开发过程, 融会贯通, 介绍一些比较深入的知识点: 第三, 介绍一些核心技术和Android的性能优化思想.
[App 研发录](http://book.douban.com/subject/26649050/) | 本书作者是包建强, 本书是作者多年 App 开发的经验总结, 从 App 架构的角度, 重点总结了 Android 应用开发中常见的实用技巧和疑难问题解决方法, 为打造高质量 App 提供有价值的实践指导, 迅速提升应用开发能力和解决疑难问题的能力. 这本书非常有利于 Android 开发者进阶.
[Android 设计模式源码分析](http://book.douban.com/subject/26644935/) | 本书作者是开发技术前线创立者之一 Mr.Simple, 该书从 Android 源码的角度由浅入深地剖析设计模式的运用, 让工程师们把设计与模式重视起来, 提升自己的设计能力与代码质量

## 开发环境/工具
(附上: 由 [@脉脉不得语](http://weibo.com/234959219) 收集维护超多开发工具下载地址 [AndroidDevTools](https://github.com/inferjay/AndroidDevTools), 后五个工具资料在 [stormzhang](http://stormzhang.com/) 博客中找到的,[地址](http://stormzhang.com/android/2015/05/26/android-tools/))

 环境/工具 | 简述
 -------- | --------
[Android Studio](http://developer.android.com/sdk/index.html) | 这个开发工具上手需要一定的时间, 自从 Google 推出1.0正式版, 这个工具一直火爆, 谷歌也不停更新维护, 性能逐渐稳定提高, 目前 github 上面的绝大多数开源项目都是使用 Android Studio 工具, 这就是开发 Android 必须掌握使用的工具, 如果还在使用 Eclipse 开发 Android 的童鞋们, 赶紧换成 AS 开发吧
[Genymotion](https://www.genymotion.com/#!/download) | 强大好用高性能的 Android 模拟器, 自带的那个模拟器简直不忍直视, 启动超慢的, 跟这个没法比, 无论你是用 Eclipse 还是 Android Studio 里面都有 Genymotion 插件
[jadx](https://github.com/skylot/jadx) | 一个 Android 反编译神器, 不同于常见的 [dex2jar](https://github.com/pxb1988/dex2jar), 这个反编译器生成代码的 try/catch 次数更少, View也不再是数字 id 了, 可读性更高
[android-selector](https://github.com/importre/android-selector-intellij-plugin) | 可以根据指定颜色生成 Selector Drawable 的插件
[GradleDependenciesHelperPlugin](https://github.com/ligi/GradleDependenciesHelperPlugin) | Gradle 依赖自动补全插件
[Smali Viewer](http://blog.avlyun.com/show/%E3%80%8Asv%E7%94%A8%E6%88%B7%E6%8C%87%E5%8D%97%E3%80%8B/) | sv 是一款免费 APK 分析软件, 对你感兴趣的 APP 分析看看它们都用了些什么, 对你学习借鉴有一定帮助
[folding-plugin](https://github.com/dmytrodanylyk/folding-plugin) | layout 文件夹里的布局文件一般很长很长没有目录, 这个插件就可以把 layout 分好层级结构, 类似 src 下目录结构
[CodeGlance](https://github.com/Vektah/CodeGlance) | 在编辑代码最右侧, 显示一块代码小地图
[Statistic](https://plugins.jetbrains.com/plugin/?idea&id=4509) | 统计整个项目行数的插件, 这可表示我们日日夜夜辛辛苦苦必备插件
[idea-markdown](https://github.com/nicoulaj/idea-markdown) | 在 AS 中编写 Markdown 文件, 可以直接预览网页显示效果, 对于你经常编写 Markdown 文件的你值得拥有这个插件
[Stetho](http://facebook.github.io/stetho/) | Stetho 是 Facebook 出品的一个强大的 Android 调试工具,使用该工具你可以在 Chrome Developer Tools 查看 App 的布局, 网络请求(仅限使用 Volley, okhttp 的网络请求库), sqlite, preference, 一切都是可视化的操作,无须自己在去使用 adb, 也不需要 root 你的设备
[ClassyShark](https://github.com/google/android-classyshark) | ClassyShark 是 Google 发布的一款可以查看 Android 可执行文件的浏览工具, 支持.dex, .aar, .so, .apk, .jar, .class, .xml 等文件格式, 分析里面的内容包括 classes.dex 文件, 包方法数量, 类, 字符串, 使用的 NativeLibrary 等
[AndroidWiFiADB](https://github.com/pedrovgs/AndroidWiFiADB) | 使用 WiFi 连接而不需要 USB 连接 Android 设备达到安装, 运行, 调试应用的目的
[checkstyle-idea](https://github.com/jshiell/checkstyle-idea) | Checkstyle-idea 是一款检查自己写的代码是否符合规范的插件, 该插件是根据 checkstyle.xml 文件来检查的, checkstyle.xml 文件可以由自己自己定义, 也可以使用一些大公司定义的规范, 如果不懂得如何定义, 可以查看 [官方文档](http://checkstyle.sourceforge.net/checks.html), 该插件的详细介绍以及使用, 可以看一下咕咚大侠写的 [文章](http://gudong.name/2016/04/07/checkstyle.html)
[ECTranslation](https://github.com/Skykai521/ECTranslation) | ECTranslation 是 Android Studio 开发工具的一个翻译插件, 可以将英文翻译为中文, 英语基础差的童鞋装上它就可以轻松阅读 Android 源码啦
[Android Methods Count](https://plugins.jetbrains.com/plugin/8076?pr=androidstudio) | 统计 Android 依赖库中方法的总个数, 避免应用方法数超过 65K 问题
[AndroidLocalizationer](https://github.com/westlinkin/AndroidLocalizationer) | 可用于将项目中的 string 资源自动翻译为其他语言的插件, 其翻译支持使用 Microsoft Translator 或 Google Translation
[ButterKnife Zelezny](https://github.com/avast/android-butterknife-zelezny) | ButterKnife 生成器, 使用起来非常简单方便, 为你简写了很多 findViewId 代码, 如果你不了解 ButterKnife 的可以到[这里](http://stormzhang.com/openandroid/android/2014/01/12/android-butterknife/)看看
[SelectorChapek](https://github.com/inmite/android-selector-chapek) | 设计师给我们提供好了各种资源, 每个按钮都要写一个selector是不是很麻烦? 这么这个插件就为解决这个问题而生, 你只需要做的是告诉设计师们按照规范命名就好了, 其他一键搞定
[GsonFormat](https://github.com/zzz40500/GsonFormat) | 现在大多数服务端 api 都以 json 数据格式返回, 而客户端需要根据 api 接口生成相应的实体类, 这个插件把这个过程自动化了, 赶紧使用起来吧
[ParcelableGenerator](https://github.com/mcharmas/android-parcelable-intellij-plugin) | Android中的序列化有两种方式, 分别是实现 Serializable 接口和 Parcelable 接口, 但在 Android 中是推荐使用 Parcelable, 只不过我们这种方式要比Serializable方式要繁琐, 那么有了这个插件一切就ok了
[LeakCanary](https://github.com/square/leakcanary) | 良心企业 Square 最近刚开源的一个非常有用的工具, 强烈推荐, 帮助你在开发阶段方便的检测出内存泄露的问题, 使用起来更简单方便, 而且我们团队第一时间使用帮助我们发现了不少问题, 英文不好的这里有雷锋同志翻译的中文版 [LeakCanary 中文使用说明](http://www.liaohuqiu.net/cn/posts/leak-canary-read-me/)
[更多](https://ydmmocoo.github.io/2016/06/28/Android-Studio%E6%8F%92%E4%BB%B6%E6%95%B4%E7%90%86/) | 该作者收集整理了 40 个插件, 可以说是史上最全的了


## 博客

 博客地址 | 博主信息
 -------- | --------
[Android Developers Blog](http://android-developers.blogspot.com/) | Android官网博客, 在上面可以关注 Android 最新的进展与最权威的博客(需翻墙)
[stormzhang](http://stormzhang.com/) | 博主是上海薄荷科技开发主管, 他的博客分享了他从编程白痴到自学 Android 一路走过的经验, 写了一篇 [Android学习之路](http://stormzhang.com/android/2014/07/07/learn-android-from-rookie/) 帮助了无数人, 里面还有很多好的文章非常适合新手入门, 并且是微信公众号「AndroidDeveloper」的运营者, 可以算是 Android 界最有影响力的公众号之一了, 强烈推荐关注
[胡凯](http://hukai.me/) | 目前就职于腾讯上海从事 Android 开发的工作, 发起 Google Android 官方培训课程中文版翻译, 这课程是学习 Android 应用开发的绝佳资料
[Trinea](http://www.trinea.cn/) | 目前在滴滴负责 Android 客户端技术, 他是开源库项目收集达人, 你想要的开源库[上面](https://github.com/Trinea)都有, 并且发起 Android 开源项目源码解析, 在使用开源库的同时也可以知道其中原理, 大家可以去关注一下, [地址](http://p.codekk.com)
[郭霖](http://blog.csdn.net/guolin_blog) | 博主郭霖是大神, 人人都称"郭神", 是第一行代码的作者, 博主在 CSDN 上所写的文章都非常值得学习
[代码家](http://blog.daimajia.com/) | 90后 Android 大神, 称作库达人, 博主收集了很多 Android 开源库, 博主自己也做了很多开源库, 非常值得学习
[light_sky](http://www.lightskystreet.com/) | Android 开发工程师, 目前在北京工作. Google big fan, 热爱开源, 热爱分享, 活跃于 GitHub, G+, Twitter, 捕捉Android最新资讯和技术, ViewPagerIndicator 开源项目分析者
[张鸿洋](http://blog.csdn.net/lmj623565791/) | 张鴻洋是 CSDN 博客专家, 博主在 CSDN 所发布的每一篇文章都是干货, 都很值得大家去学习
[张兴业](http://blog.csdn.net/xyz_lmn) | 张兴业同样也是 CSDN 博客专家, 博主专注移动互联网开发, 关注移动支付业务
[hi大头鬼hi](http://blog.csdn.net/lzyzsd/) | hi大头鬼hi 是阿里巴巴集团的一名 Android 工程师, 擅长 Android, RxJava, RxAndroid, ReactNative, Node.js, 大前端, 可谓是全栈工程师, 如果你对 RxJava 技术感兴趣, 不妨到他的博客看看, 他写了一系列有关 RxJava 的介绍
[更多](https://github.com/android-cn/android-dev-cn) | 这里面收集了很多国内外开发者的信息, 大家可以去看看

## 社区

 名称 | 简介
 ---- | ----
[StackOverFlow](http://stackoverflow.com/) | IT 界的问答社区, 你开发当中所遇到的问题基本上都能在这里能寻找到你想要的答案
[SegmentFault](https://segmentfault.com/t/android) | SegmentFault 是一个专注于解决编程问题, 提高开发技能的社区
[CSDN](http://blog.csdn.net/mobile/newest.html) | CSDN 是全球最大中文IT技术社区
[稀土掘金](http://gold.xitu.io/explore/android) | 高质量的技术分享社区
[谷歌开发者社区(GDG)](http://chinagdg.org/) | GDG 是 Google Developer Groups 的缩写, 中文名称是谷歌开发者社区

## 开源项目学习

 项目名称 | 项目简介 
 -------- | --------
[Google I/O 2014](https://github.com/google/iosched) | Google I/O Android App 使用了当时最新推出的 Material Design 设计 
[Google play music](https://github.com/googlesamples/android-UniversalMusicPlayer) | 一个跨多个平台音乐播放器 
[Google Santa Tracker for Android](https://github.com/google/santa-tracker-android?utm_source=www.race604.com) | Google 开源的一个儿童教育和娱乐的 App
[github客户端](https://github.com/pockethub/PocketHub) | 开源者 github 团队, 支持项目的 lssues 和 Gists 并集成了新闻 feed 以便及时获取来自组织好友和资料库的更新信息, 还提供了一个用于快速访问你创建,监控以及发布 issue 面板, 可查看并将问题加到收藏夹
[Talon-for-Twitter](https://github.com/klinker24/Talon-for-Twitter) | 一个完整版 Twitter 第三方客户端, 属于顶级水平, 而且在源代码 100% 开源, 学习资源让你取之不尽
[Anime Taste](https://github.com/daimajia/AnimeTaste) | 开发者是代码家为 AnimeTaste 全球动画精选开发的 Android 客户端, 国内很少见的精彩而且开源的 APP, 获得豌豆荚110期设计奖
[EverMemo](https://github.com/daimajia/EverMemo) | 开发者是代码家, EverMemo 是一款让你快速记录与分享灵感的随身便签, 极简的界面与卡片式布局, 让你记录与查找便签更有效率
[9GAG](https://github.com/stormzhang/9GAG) | 开发者是 stormzhang 博主,这个开源项目教你使用 Studio, Gradle 以及一些流行的开源库快速开发一个不错的 Android 客户端
[MIUI 便签](https://github.com/MiCode/Notes) | MiCode 便签是小米便签的社区开源版, 由 MIUI 团队（ww.miui.com）发起并贡献第一批代码, 遵循 NOTICE 文件所描述的开源协议
[贝壳单词](https://github.com/drakeet/Seashell-app) | 开发者是许晓峰(Drakeet), 获得豌豆荚设计奖, 这个是初期版本, 新版没有开源, 但是在博主的博客当中将一些新版的内容都剥离出来写成了文章,可以去学习一下
[Muzei Live Wallpaper](https://github.com/romannurik/muzei) | 开发者是 Ian Lake , 就职于 Google, 这款是定时更换桌面精美壁纸 App
[四次元-新浪微博客户端](https://github.com/qii/weiciyuan) | 一个仿新浪微博客户端 App, 基本都含有新浪微博的功能, 开源团队写了一份 wiki 文档, 可以去学习一下该 App 是如何实现的
[知乎专栏](https://github.com/bxbxbai/ZhuanLan) | 开发者是白瓦力, 项目结构清晰, 代码分包合理, 很棒. 很适合新手去学习如何搭建一个 App 结构, 熟悉开发一个完整 App 的流程
[eoe 客户端](https://github.com/eoecn/android-app) | eoe 社区Android客户端
[oschina](http://git.oschina.net/oschina/android-app) | 开源中国社区 Android 客户端, 此开源的是 v1 版本, v2 版本将在 2015 年年中开源
[v2ex](https://github.com/kyze8439690/v2ex-daily-android) | 开发者是[杨辉](http://yanghui.name/about/), 这个是 v2ex Android 第三方客户端
[Tweet Lanes](https://github.com/chrislacy/TweetLanes) | 功能比较完整的 Twitter 客户端
[Financius](https://github.com/mvarnagiris/financius-public) | 一款简单易用个人理财 Android 程序
[Coding](https://coding.net/u/coding/p/Coding-Android/git) | Coding 类似于 github 一个代码托管平台, 这个是 Coding 的 Android 版客户端
[ZXing](https://github.com/zxing/zxing) | 二维码扫描工具,市场上许多应用的二维码扫描工具都是从这个修改得到的
[photup](https://github.com/chrisbanes/photup) | 编辑机批量上传照片到 facebook 上,代码分包合理,很棒,不过这个项目依赖的开源项目比较多, 比较难编译
[todo.txt-android](https://github.com/ginatrapani/todo.txt-android) | todo.txt 官方 Android 应用, 一个极简的将待办事件记录在 .txt 文件中
[扫扫图书](https://github.com/JayFang1993/ScanBook) | 一个让你懂得如何去选择一本书的 APP, 具有扫描搜索查询图书的信息功能
[ChaseWhisplyProject](https://github.com/tvbarthel/ChaseWhisplyProject) | 开启摄像头在你所在位置寻找鬼魂, 进行打鬼游戏
[AntennaPod](https://github.com/AntennaPod/AntennaPod) | AntennaPod 是一个自由, 开源的播客客户端, 支持 Atom 和 RSS Feed
[干柴](https://github.com/openproject/AndroidDigest) | 开发者是冯建, 一个专注收集 android 相关干货(文摘,名博,github等等)资源 App
[Hacker News](https://github.com/manmal/hn-android) | 一个查看黑客新闻报道和评论的 App
[proxydroid](https://github.com/madeye/proxydroid) | ProxyDroid 是一个帮助你在你的 Android 设备上设置代理 (HTTP / SOCKS4 / SOCKS5)
[AliGesture](https://git.oschina.net/way/AliGesture) | Android平台手势识别应用, 简单的手势就可以进入预置的应用, 方便快捷
[指读](https://coding.net/u/youzi/p/Zhidu-Android/git/tree/master) | 指读顾名思义就是用手指去阅读浩瀚的书海
[KJ 音乐](https://github.com/KJFrame/KJMusic) | 开发者是[张涛](http://blog.kymjs.com/about/), 快捷音乐使用到[KJFrameForAndroid](https://github.com/kymjs/KJFrameForAndroid)开发框架, 拥有界面绚丽, 操作简单, 播放手机本地音乐, 在线收听音乐等功能, 还支持: 新浪微博, 百度账号, QQ 账号的一键登录
[哎嘛](http://git.oschina.net/tonlin/android-app) | OSCHINA 第三方客户端, 这个版本界面比官方版本界面好看多了, 使用的是 Material Design, 界面看上去非常清爽舒服
[码厩](http://git.oschina.net/wlemuel/Cotable/tree/master/) | 博客园第三方客户端, 使用到缓存技术, 当你打开一次之后的博客内容, 会自动保存到设备中, 下次打开阅读同一文章时不需要再利用网络加载, 大家如果想为自己 App 搞缓存的, 可以研究一下该 App 是如何实现的喔
[cnBeta 第三方阅读器](http://git.oschina.net/ywwxhz/cnBeta-reader) | 该 App 是 cnBeta(中文业界资讯站) 第三方阅读客户端, 界面也是使用 Material Design, 还加上一些动画效果, 让人阅读文章起来不会感觉枯燥, 值得去研究学习一下
[BlackLight](https://github.com/PaperAirplane-Dev-Team/BlackLight) | BlackLight是由纸飞机开发团队开发的一款Android上的新浪微博第三方轻量级客户端
[Actor](https://github.com/actorapp/actor-platform) | Actor(优聆) 是一款即时通讯 App, 解决网络通讯差的情况, 支持离线消息和文件存储, 自动与手机联系人建立联系等等
[Plaid](https://github.com/nickbutcher/plaid) | 一个遵循 Material Design 的一个设计新闻客户端，里面的一些完全MD的一些特效很棒，同时整个客户端的框架设计也很有参考意义
[SimplifyReader](https://github.com/SkillCollege/SimplifyReader) | 一款基于 Google Material Design 设计开发的 Android 客户端, 包括新闻简读, 图片浏览, 视频爽看, 音乐轻听以及二维码扫描五个子模块, 项目采取的是MVP架构开发
[PHPHub-Android](https://github.com/CycloneAxe/phphub-android) | PHPHub Android 客户端, 项目架构使用 nucleus 简化 MVP 架构, API 请求返回数据使用 RxJava 进行处理, 客户端使用了独特的二维码扫码登录, 有兴趣的可以去研究一下
[Leisure](https://github.com/MummyDing/Leisure) | 闲暇(Leisure)是一款集"知乎日报", "果壳科学人", "新华网新闻"以及"豆瓣图书"于一体的阅读类 Android 应用, 项目里面有多语言切换、夜间模式以及无图模式, 如果你还不知道这些技术怎么实现, 不妨参考一下这个项目
[Meizhi](https://github.com/drakeet/Meizhi) | 开发者是许晓峰(Drakeet), 该 app 是数据来自代码家干货网站 [gank.io](http://gank.io), 有很多开发者都纷纷为这网站做客户端 app, 因为代码家大神开放该网站的 Api, 更重要的是该网站每天除了有干货还有漂亮妹子看呢, 该 App 使用到的技术有 RxJava + Retrofit, 代码结构非常清晰, 值得一看的开源 App.
[Bingo](https://github.com/sfsheng0322/Bingo) | 开发者是[孙福生](http://weibo.com/u/3852192525), Bingo 是一款 IT 阅读学习类的开源软件, 作者收集一些干货学习内容, 你也可以在 App 上分享你的认为干货文章, 该项目使用动态代理 AOP 编程框架, 使开发起来更简洁, 更高效. 里面有一个功能就是多种主题切换, 感兴趣的可以看看怎么实现

## Android 开发者杂志周刊

( 前五个资料来自 [Drakeet](http://drakeet.me/) 收集整理的, 资料原链接 [地址](http://www.jianshu.com/p/54c4a19ffa68) )

  周刊名 | 周刊简介
  ------ | -------
[Android Weekly](http://androidweekly.net/) | Android Weekly 是由Android 团队的成员和国外知名的 Android 开发者维护, 分享的内容不仅仅只有干货, 而且还有最新的技术分享, 也是Android 开发圈子最早, 最有名的周报
[Android 开发技术周报](http://www.androidweekly.cn/) | Android 开发技术周报是由[@脉脉不嘚語](http://weibo.com/234959219) 维护更新, 截止到现在, 已经发布了28 期, 分享的都是高质量的文章教程, 代码库, 工具, 新闻视频, 设计等
[Android 科学院](http://zhuanlan.zhihu.com/andlib) | 由 [@duguguiyu](http://weibo.com/duguguiyu?from=feed&loc=at&nick=duguguiyu)和豌豆荚一小撮工程师组成, 分享的都是最新的 Android 技术: 虽然更新频率不是很高, 但是质量确是很高的, 值得一看的
[开发技术前线](http://www.devtf.cn/?cat=2) | 开发技术前线是一个高质量技术文章的聚合网站, 主要分享 Android, iOS, 以及招聘等内容
[App 开发日报](http://app.memect.com/) | App 开发日报主要关注移动应用的开发, 它每天一刊, 分享的内容主要来自微博上知名的开发者推荐的内容, 因此质量基本上是有保证的
[Android 开发周报](http://www.infoq.com/cn/author/%E9%83%AD%E4%BA%AE) | Android 开发周报是郭亮在连载更新在 Infoq 的周刊, 它不仅分享 Android 的相关新闻, 新工具, 而且还有更加深入的, 所以对于新生老人都很适合
[干货集中营](http://gank.io/) | 由 [代码家](http://blog.daimajia.com/) 维护更新, 周一到周五每天中午分享, 分享内容有漂亮妹子, Android 干货, iOS 干货, App, 技术以外推荐, 还有休息视频
[Android Blog 周刊](http://www.androidblog.cn/) | AndroidBlog 是由 [Jomeslu](http://weibo.com/u/2106134235?refer_flag=1001030201_&is_hot=1) 收录的, 目前就职于搜狐, 该周刊分享内容主要有一周国内外热门技术博客, 优秀的类库, 以及一些有趣的新闻, 看了前几期分享的内容质量都是很高的, 因此值得推荐给大家

## Awesome 系列

- [awesome android(1)](https://github.com/snowdream/awesome-android)
- [awesome_android(2)](https://github.com/JStumpp/awesome-android)
- [awesome_android_UI](https://github.com/wasabeef/awesome-android-ui)
- [awesome_android_libraries](https://github.com/wasabeef/awesome-android-libraries)
- [awesome_java](https://github.com/akullpp/awesome-java)
- [awesome_materialdesign](https://github.com/lightSky/Awesome-MaterialDesign)
- [awesome 系列之终极版](https://github.com/sindresorhus/awesome)
- [android-dynamic-load-awesome](https://github.com/liaohuqiu/android-dynamic-load-awesome)
- [awesome-adb](https://github.com/mzlogin/awesome-adb)

## 动画系列
- [animate](https://github.com/hitherejoe/animate)
- [awesome-animation](https://github.com/Animatious/awesome-animation)
- [Material-Animations](https://github.com/lgvalle/Material-Animations)
- [AndroidViewAnimations](https://github.com/daimajia/AndroidViewAnimations)

## Material Design 设计

- [Material Design 教程](https://www.google.com/design/spec/material-design/introduction.html)
- [Material Design 教程(中文版)](https://github.com/1sters/material_design_zh_2)
- [Material Design Android Library ](https://github.com/navasmdc/MaterialDesignLibrary)(Material Design 开源库, 很多效果可以直接拿来用)
- [十大Material Design开源项目](http://www.csdn.net/article/2014-11-21/2822753-material-design-libs)

## 素材

- [常用色彩搭配表](http://tool.c7sky.com/webcolor/)
- [ColorHunt-色彩搭配](http://www.colorhunt.co/)
- [在线 Material Design 界面调色板](http://www.materialpalette.com/)
- [Material Design设计模板与素材](http://www.materialup.com/)
- [Icons8](https://icons8.com/)
- [Icon Store](https://iconstore.co/)
- [Material icons](https://design.google.com/icons/)
- [Iconfont](http://iconfont.cn/)
- [awesome-design](https://github.com/gztchan/awesome-design/)

## 开源库收集

- [Android Libraries and Resources ](http://alamkanak.github.io/android-libraries-and-resources/)
- [Android Arsenal ](http://android-arsenal.com/)(一个专门收集 android 开源库的网站, 网站经常更新)
- [Android 开源项目汇总 ](https://github.com/Trinea/android-open-project)(Trinea 大神收集的)
- [Android 开源项目源码分析 ](http://codekk.com/open-source-project-analysis)(在懂得使用这些开源项目同时, 也应该了解当中的原理)
- [泡在网上的日子](http://www.jcodecraeer.com/plus/list.php?tid=31)
- [android-gems](http://www.android-gems.com/)(国内外很多开发者都在这里上传他们最新的项目, 还带有 apk 下载)

## 设计模式

- [java-design-patterns](https://github.com/iluwatar/java-design-patterns#model-view-presenter)
- [Android源码设计模式分析项目](https://github.com/simple-android-framework-exchange/android_design_patterns_analysis)
- [Java之美[从菜鸟到高手演变]之设计模式](http://blog.csdn.net/zhangerqing/article/details/8194653)

## 实践篇

- [Android Studio 小技巧合集](http://jaeger.itscoder.com/android/2016/02/14/android-studio-tips.html)
- [Android 开发最佳实践](https://github.com/futurice/android-best-practices/blob/master/translations/Chinese/README.cn.md)
- [Android 开发最佳实践 ](http://hukai.me/android-dev-patterns/)(来自[胡凯](http://hukai.me/)总结)
- [Android 最佳实践之 UI 篇](http://sr1.me/way-to-explore/2015/03/25/best-practice-for-android-ui.html)
- [Android 屏幕适配全攻略](http://blog.csdn.net/zhaokaiqiang1992/article/details/45419023)
- [给半新人的app开发指南](http://www.hamberluo.cn/2015/04/27/semi-android-newer)
- [Android 一些重要知识点解析整理](https://github.com/FX-Max/Point-of-Android)
- [Android 开发人员应避免的 10 个误区](http://www.imooc.com/article/1287)
- [Java 反射最佳实践](https://github.com/tianzhijiexian/Android-Best-Practices/blob/master/2015.9/reflect/reflect.md)
- [Android 内存优化之 OOM](http://www.csdn.net/article/2015-09-18/2825737/1)
- [Android 命名规范](http://blog.csdn.net/vipzjyno1/article/details/23542617)
- [Adapter 优化方案的探索](https://github.com/tianzhijiexian/Android-Best-Practices/blob/master/2015.10/adapter/adapter.md)
- [Android-Tips](https://github.com/tangqi92/Android-Tips)
- [最全 Android ADB Shell](http://adbshell.com/)
- [AndroidNote](https://github.com/CharonChui/AndroidNote)
- [Android 常用工具类](https://github.com/l123456789jy/Lazy)
- [创建安卓 app 的 30 个经验教训](http://www.jcodecraeer.com/a/anzhuokaifa/androidkaifa/2016/0218/3978.html)
- [Android 三大图片缓存原理、特性对比](http://www.trinea.cn/android/android-image-cache-compare/)
- [Android 性能优化总结](http://www.trinea.cn/android/performance/)
- [Android 实用代码片段整合 ](http://www.eoeandroid.com/thread-570919-1-1.html)
- [36 个 Android 开发常用代码片段](http://www.phpxs.com/code/1001775)
- [收集了大家常用的一些 Android 的模板代码](https://github.com/jiang111/awesome-android-tips)
- [Android 技术积累: 开发规范](http://keeganlee.me/post/android/20150709) 
- [App 架构设计经验谈](http://keeganlee.me/post/architecture/20160114)
- [关于 Android 开发的 40 条优化建议](http://blog.csdn.net/yyh352091626/article/details/50957851)
- [如何提高安卓代码的质量和语法](http://gold.xitu.io/entry/56cd6ebb99a6ce005a2887e3)
- [我的 Android 开发实战经验总结](http://www.jianshu.com/p/4f152bc8f4f3)
- [Android Tips 系列](http://www.wangchenlong.org/2016/02/23/tips/1603/231-android-tips-1/)
- [如何自学 Android](http://www.jianshu.com/p/28111d29eee4)
- [你所不知道的Android Studio调试技巧](http://www.jianshu.com/p/011eb88f4e0d)

## 面试

- [80% 以上简历都是不合格的](http://j.codekk.com/blogs/detail/5705bcdf4a38205862ef4770)
- [推荐两个技术简历模板](http://j.codekk.com/blogs/detail/5705bcdf4a38205862ef476f)
- [关于程序员求职简历](https://mdluo.github.io/blog/about-resume/)
- [国内一线互联网公司内部面试题库](https://github.com/JackyAndroid/AndroidInterview-Q-A)
- [LearningNotes](https://github.com/GeniusVJR/LearningNotes) (非常详细的面试资料, 涉及 Android, Java, 设计模式, 算法等)
- [Android 面试那些事儿](https://zhuanlan.zhihu.com/p/21565914)
- [精益技术简历之道——改善技术简历的47条原则](http://lucida.me/blog/lean-technical-resume/)
- [史上最全 Android 面试资料集合](http://www.jianshu.com/p/d1efe2f31b6d)

## Git 教程

新手看完这几份教程基本上知道怎么使用 Git 了

- [GitHub 团队美女写的一套 Git 使用教程](http://jlord.us/git-it/challenges/get_git.html)
- [ProGit 中文版](https://git-scm.com/book/zh/v2)
- [廖雪峰的 Git 教程](http://www.liaoxuefeng.com/wiki/0013739516305929606dd18361248578c67b8067c8c017b000)
- [Git 简易指南](http://rogerdudler.github.io/git-guide/index.zh.html)
- [git-tips](https://github.com/git-tips/tips)(Git 命令集合)

## 文档

- [Android 官方 API 文档](http://developer.android.com/reference/android/package-summary.html)(网站需要翻墙，不翻墙可以[下载](http://pan.baidu.com/s/1dDu3LVb)离线文件)
- [Android 官方培训课程中文版](http://hukai.me/android-training-course-in-chinese/index.html)(由胡凯发起对 Google Android 官方培训课程翻译的中文版)

## 其它资料收集

- [10 个很棒的学习 Android 开发的网站](http://www.eoeandroid.com/forum.php?mod=viewthread&tid=571335&highlight=10%E4%B8%AA%E5%BE%88%E6%A3%92)
- [Android 开发, 你应该知道的学习资源](http://android.jobbole.com/80815/)
- [AndroidCat 安卓书签网](https://github.com/ColorfulCat/AndroidGuide)
- [每个 Android 开发者都应该了解的资源列表](http://www.jianshu.com/p/e961f1633d7a)
- [Android 开发者网址导航](http://www.jianshu.com/p/54902270249d)
- [Android 开发收藏夹](https://github.com/ruijun/Android-Dev-Favorites)
- [TimLiu-Android](https://github.com/Tim9Liu9/TimLiu-Android)(TimLiu 总结的 Android 开源项目及库)
- [AndroidTips](https://github.com/JohnTsaiAndroid/AndroidTips)
- [Android 开发人员不得不收集的代码](https://github.com/Blankj/AndroidUtilCode)
- [Android 架构合集](https://github.com/Juude/Awesome-Android-Architecture)
- [AndroidArchitectureCollection](https://github.com/CameloeAnthony/AndroidArchitectureCollection)
- [Android 开发中的日常积累](https://github.com/lizhangqu/CoreLink)
- [2016安卓开发资料大全](http://blog.chengyunfeng.com/?p=1020)

## 知乎上的讨论

- [有哪些 Android 大牛的 blog 值得推荐?](http://www.zhihu.com/question/19775981)
- [GitHub 上都有哪些值得关注学习的 Android项目?](http://www.zhihu.com/question/23804819)
- [GitHub 上有哪些适合新人围观的 Android 项目?](https://www.zhihu.com/question/28481864)
- [2015 年移动设备界面设计有哪些趋势?](http://www.zhihu.com/question/28841081)
- [Android开发中, 有哪些让你觉得相见恨晚的方法,类或接口?](http://www.zhihu.com/question/33636939)
- [Android Studio有哪些非常好用的插件?](https://www.zhihu.com/question/28527388)
- [Android 开发有哪些新技术出现?](https://www.zhihu.com/question/32037895)
- [有哪些优秀的 Android 应用开源项目, 特效, 设计资料推荐?](https://www.zhihu.com/question/19804692)
- [有没有适合 Android 开发初学者的 App 源码推荐?](https://www.zhihu.com/question/26687642)
- [Android有什么好的技术点适合进行技术分享?](https://www.zhihu.com/question/29939631)
- [Android Studio有什么奇技淫巧?](https://www.zhihu.com/question/27482725)
- [Android 开发: 开始一个项目前, 做好哪些准备可以事半功倍?](https://www.zhihu.com/question/37433825)
- [大家有哪些好的 Android 开发习惯?](https://www.zhihu.com/question/27227425)
- [Android 开发有什么好的架构么?](https://www.zhihu.com/question/21406685)

## 贡献者

点击[该链接](https://github.com/Freelander/Android_Data/graphs/contributors)查看该项目所有贡献者

## License

以上内容采用 [CC BY-NC-SA 3.0](http://creativecommons.org/licenses/by-nc-sa/3.0/deed.zh) 进行许可, 转载请注明出处, 版权归本人及所有贡献者所有
