// SPDX-FileCopyrightText: 2023 The Pion community <https://pion.ly>
// SPDX-License-Identifier: MIT

package replaydetector

import (
	"fmt"
)

func Example_fixedBigInt_SetBit() {
	bi := newFixedBigInt(224)

	bi.SetBit(0)
	fmt.Println(bi.String())
	bi.Lsh(1)
	fmt.Println(bi.String())

	bi.Lsh(0)
	fmt.Println(bi.String())

	bi.SetBit(10)
	fmt.Println(bi.String())
	bi.Lsh(20)
	fmt.Println(bi.String())

	bi.SetBit(80)
	fmt.Println(bi.String())
	bi.Lsh(4)
	fmt.Println(bi.String())

	bi.SetBit(130)
	fmt.Println(bi.String())
	bi.Lsh(64)
	fmt.Println(bi.String())

	bi.SetBit(7)
	fmt.Println(bi.String())

	bi.Lsh(129)
	fmt.Println(bi.String())

	for i := 0; i < 256; i++ {
		bi.Lsh(1)
		bi.SetBit(0)
	}
	fmt.Println(bi.String())

	// output:
	// 0000000000000000000000000000000000000000000000000000000000000001
	// 0000000000000000000000000000000000000000000000000000000000000002
	// 0000000000000000000000000000000000000000000000000000000000000002
	// 0000000000000000000000000000000000000000000000000000000000000402
	// 0000000000000000000000000000000000000000000000000000000040200000
	// 0000000000000000000000000000000000000000000100000000000040200000
	// 0000000000000000000000000000000000000000001000000000000402000000
	// 0000000000000000000000000000000400000000001000000000000402000000
	// 0000000000000004000000000010000000000004020000000000000000000000
	// 0000000000000004000000000010000000000004020000000000000000000080
	// 0000000004000000000000000000010000000000000000000000000000000000
	// 00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
}
