#ifndef ntruprime_test_h
#define ntruprime_test_h

#define aligned ntruprime_test_aligned
#define callocplus ntruprime_test_callocplus
#define checksum ntruprime_test_checksum
#define checksum_clear ntruprime_test_checksum_clear
#define checksum_expected ntruprime_test_checksum_expected
#define double_canary ntruprime_test_double_canary
#define endianness ntruprime_test_endianness
#define forked ntruprime_test_forked
#define input_compare ntruprime_test_input_compare
#define input_prepare ntruprime_test_input_prepare
#define myrandom ntruprime_test_myrandom
#define ok ntruprime_test_ok
#define output_compare ntruprime_test_output_compare
#define output_prepare ntruprime_test_output_prepare
#define public ntruprime_test_public
#define secret ntruprime_test_secret
#define targeti ntruprime_test_targeti
#define targetn ntruprime_test_targetn
#define targetoffset ntruprime_test_targetoffset
#define targeto ntruprime_test_targeto
#define targetp ntruprime_test_targetp
#define valgrind ntruprime_test_valgrind

extern const char *targeto;
extern const char *targetp;
extern const char *targeti;
extern const char *targetn;
extern const char *targetoffset;
extern int ok;
extern int valgrind;

extern unsigned long long myrandom(void);
extern void forked(void (*)(long long),long long);
extern void *aligned(void *,long long);
extern void *callocplus(long long);
extern void secret(void *,long long);
extern void public(void *,long long);
extern void double_canary(unsigned char *,unsigned char *,unsigned long long);
extern void input_prepare(unsigned char *,unsigned char *,unsigned long long);
extern void output_prepare(unsigned char *,unsigned char *,unsigned long long);
extern void input_compare(const unsigned char *,const unsigned char *,unsigned long long,const char *);
extern void output_compare(const unsigned char *,const unsigned char *,unsigned long long,const char *);
extern void checksum_expected(const char *);
extern void checksum(const unsigned char *,unsigned long long);
extern void checksum_clear(void);
extern void endianness(unsigned char *,unsigned long long,unsigned long long);

#define test_hashblocks_sha512 ntruprime_test_hashblockssha512
extern void test_hashblocks_sha512(void);
#define test_hash_sha512 ntruprime_test_hashsha512
extern void test_hash_sha512(void);
#define test_decode_653x3 ntruprime_test_decode653x3
extern void test_decode_653x3(void);
#define test_decode_653x1541 ntruprime_test_decode653x1541
extern void test_decode_653x1541(void);
#define test_decode_653x4621 ntruprime_test_decode653x4621
extern void test_decode_653x4621(void);
#define test_decode_653xint16 ntruprime_test_decode653xint16
extern void test_decode_653xint16(void);
#define test_decode_653xint32 ntruprime_test_decode653xint32
extern void test_decode_653xint32(void);
#define test_decode_761x3 ntruprime_test_decode761x3
extern void test_decode_761x3(void);
#define test_decode_761x1531 ntruprime_test_decode761x1531
extern void test_decode_761x1531(void);
#define test_decode_761x4591 ntruprime_test_decode761x4591
extern void test_decode_761x4591(void);
#define test_decode_761xint16 ntruprime_test_decode761xint16
extern void test_decode_761xint16(void);
#define test_decode_761xint32 ntruprime_test_decode761xint32
extern void test_decode_761xint32(void);
#define test_decode_857x3 ntruprime_test_decode857x3
extern void test_decode_857x3(void);
#define test_decode_857x1723 ntruprime_test_decode857x1723
extern void test_decode_857x1723(void);
#define test_decode_857x5167 ntruprime_test_decode857x5167
extern void test_decode_857x5167(void);
#define test_decode_857xint16 ntruprime_test_decode857xint16
extern void test_decode_857xint16(void);
#define test_decode_857xint32 ntruprime_test_decode857xint32
extern void test_decode_857xint32(void);
#define test_decode_953x3 ntruprime_test_decode953x3
extern void test_decode_953x3(void);
#define test_decode_953x2115 ntruprime_test_decode953x2115
extern void test_decode_953x2115(void);
#define test_decode_953x6343 ntruprime_test_decode953x6343
extern void test_decode_953x6343(void);
#define test_decode_953xint16 ntruprime_test_decode953xint16
extern void test_decode_953xint16(void);
#define test_decode_953xint32 ntruprime_test_decode953xint32
extern void test_decode_953xint32(void);
#define test_decode_1013x3 ntruprime_test_decode1013x3
extern void test_decode_1013x3(void);
#define test_decode_1013x2393 ntruprime_test_decode1013x2393
extern void test_decode_1013x2393(void);
#define test_decode_1013x7177 ntruprime_test_decode1013x7177
extern void test_decode_1013x7177(void);
#define test_decode_1013xint16 ntruprime_test_decode1013xint16
extern void test_decode_1013xint16(void);
#define test_decode_1013xint32 ntruprime_test_decode1013xint32
extern void test_decode_1013xint32(void);
#define test_decode_1277x3 ntruprime_test_decode1277x3
extern void test_decode_1277x3(void);
#define test_decode_1277x2627 ntruprime_test_decode1277x2627
extern void test_decode_1277x2627(void);
#define test_decode_1277x7879 ntruprime_test_decode1277x7879
extern void test_decode_1277x7879(void);
#define test_decode_1277xint16 ntruprime_test_decode1277xint16
extern void test_decode_1277xint16(void);
#define test_decode_1277xint32 ntruprime_test_decode1277xint32
extern void test_decode_1277xint32(void);
#define test_decode_int16 ntruprime_test_decodeint16
extern void test_decode_int16(void);
#define test_encode_653x3 ntruprime_test_encode653x3
extern void test_encode_653x3(void);
#define test_encode_653x1541 ntruprime_test_encode653x1541
extern void test_encode_653x1541(void);
#define test_encode_653x1541round ntruprime_test_encode653x1541round
extern void test_encode_653x1541round(void);
#define test_encode_653x4621 ntruprime_test_encode653x4621
extern void test_encode_653x4621(void);
#define test_encode_653xfreeze3 ntruprime_test_encode653xfreeze3
extern void test_encode_653xfreeze3(void);
#define test_encode_653xint16 ntruprime_test_encode653xint16
extern void test_encode_653xint16(void);
#define test_encode_761x3 ntruprime_test_encode761x3
extern void test_encode_761x3(void);
#define test_encode_761x1531 ntruprime_test_encode761x1531
extern void test_encode_761x1531(void);
#define test_encode_761x1531round ntruprime_test_encode761x1531round
extern void test_encode_761x1531round(void);
#define test_encode_761x4591 ntruprime_test_encode761x4591
extern void test_encode_761x4591(void);
#define test_encode_761xfreeze3 ntruprime_test_encode761xfreeze3
extern void test_encode_761xfreeze3(void);
#define test_encode_761xint16 ntruprime_test_encode761xint16
extern void test_encode_761xint16(void);
#define test_encode_857x3 ntruprime_test_encode857x3
extern void test_encode_857x3(void);
#define test_encode_857x1723 ntruprime_test_encode857x1723
extern void test_encode_857x1723(void);
#define test_encode_857x1723round ntruprime_test_encode857x1723round
extern void test_encode_857x1723round(void);
#define test_encode_857x5167 ntruprime_test_encode857x5167
extern void test_encode_857x5167(void);
#define test_encode_857xfreeze3 ntruprime_test_encode857xfreeze3
extern void test_encode_857xfreeze3(void);
#define test_encode_857xint16 ntruprime_test_encode857xint16
extern void test_encode_857xint16(void);
#define test_encode_953x3 ntruprime_test_encode953x3
extern void test_encode_953x3(void);
#define test_encode_953x2115 ntruprime_test_encode953x2115
extern void test_encode_953x2115(void);
#define test_encode_953x2115round ntruprime_test_encode953x2115round
extern void test_encode_953x2115round(void);
#define test_encode_953x6343 ntruprime_test_encode953x6343
extern void test_encode_953x6343(void);
#define test_encode_953xfreeze3 ntruprime_test_encode953xfreeze3
extern void test_encode_953xfreeze3(void);
#define test_encode_953xint16 ntruprime_test_encode953xint16
extern void test_encode_953xint16(void);
#define test_encode_1013x3 ntruprime_test_encode1013x3
extern void test_encode_1013x3(void);
#define test_encode_1013x2393 ntruprime_test_encode1013x2393
extern void test_encode_1013x2393(void);
#define test_encode_1013x2393round ntruprime_test_encode1013x2393round
extern void test_encode_1013x2393round(void);
#define test_encode_1013x7177 ntruprime_test_encode1013x7177
extern void test_encode_1013x7177(void);
#define test_encode_1013xfreeze3 ntruprime_test_encode1013xfreeze3
extern void test_encode_1013xfreeze3(void);
#define test_encode_1013xint16 ntruprime_test_encode1013xint16
extern void test_encode_1013xint16(void);
#define test_encode_1277x3 ntruprime_test_encode1277x3
extern void test_encode_1277x3(void);
#define test_encode_1277x2627 ntruprime_test_encode1277x2627
extern void test_encode_1277x2627(void);
#define test_encode_1277x2627round ntruprime_test_encode1277x2627round
extern void test_encode_1277x2627round(void);
#define test_encode_1277x7879 ntruprime_test_encode1277x7879
extern void test_encode_1277x7879(void);
#define test_encode_1277xfreeze3 ntruprime_test_encode1277xfreeze3
extern void test_encode_1277xfreeze3(void);
#define test_encode_1277xint16 ntruprime_test_encode1277xint16
extern void test_encode_1277xint16(void);
#define test_encode_int16 ntruprime_test_encodeint16
extern void test_encode_int16(void);
#define test_sort_int32 ntruprime_test_sortint32
extern void test_sort_int32(void);
#define test_sort_uint32 ntruprime_test_sortuint32
extern void test_sort_uint32(void);
#define test_core_inv3sntrup653 ntruprime_test_coreinv3sntrup653
extern void test_core_inv3sntrup653(void);
#define test_core_inv3sntrup761 ntruprime_test_coreinv3sntrup761
extern void test_core_inv3sntrup761(void);
#define test_core_inv3sntrup857 ntruprime_test_coreinv3sntrup857
extern void test_core_inv3sntrup857(void);
#define test_core_inv3sntrup953 ntruprime_test_coreinv3sntrup953
extern void test_core_inv3sntrup953(void);
#define test_core_inv3sntrup1013 ntruprime_test_coreinv3sntrup1013
extern void test_core_inv3sntrup1013(void);
#define test_core_inv3sntrup1277 ntruprime_test_coreinv3sntrup1277
extern void test_core_inv3sntrup1277(void);
#define test_core_invsntrup653 ntruprime_test_coreinvsntrup653
extern void test_core_invsntrup653(void);
#define test_core_invsntrup761 ntruprime_test_coreinvsntrup761
extern void test_core_invsntrup761(void);
#define test_core_invsntrup857 ntruprime_test_coreinvsntrup857
extern void test_core_invsntrup857(void);
#define test_core_invsntrup953 ntruprime_test_coreinvsntrup953
extern void test_core_invsntrup953(void);
#define test_core_invsntrup1013 ntruprime_test_coreinvsntrup1013
extern void test_core_invsntrup1013(void);
#define test_core_invsntrup1277 ntruprime_test_coreinvsntrup1277
extern void test_core_invsntrup1277(void);
#define test_core_mult3sntrup653 ntruprime_test_coremult3sntrup653
extern void test_core_mult3sntrup653(void);
#define test_core_mult3sntrup761 ntruprime_test_coremult3sntrup761
extern void test_core_mult3sntrup761(void);
#define test_core_mult3sntrup857 ntruprime_test_coremult3sntrup857
extern void test_core_mult3sntrup857(void);
#define test_core_mult3sntrup953 ntruprime_test_coremult3sntrup953
extern void test_core_mult3sntrup953(void);
#define test_core_mult3sntrup1013 ntruprime_test_coremult3sntrup1013
extern void test_core_mult3sntrup1013(void);
#define test_core_mult3sntrup1277 ntruprime_test_coremult3sntrup1277
extern void test_core_mult3sntrup1277(void);
#define test_core_multsntrup653 ntruprime_test_coremultsntrup653
extern void test_core_multsntrup653(void);
#define test_core_multsntrup761 ntruprime_test_coremultsntrup761
extern void test_core_multsntrup761(void);
#define test_core_multsntrup857 ntruprime_test_coremultsntrup857
extern void test_core_multsntrup857(void);
#define test_core_multsntrup953 ntruprime_test_coremultsntrup953
extern void test_core_multsntrup953(void);
#define test_core_multsntrup1013 ntruprime_test_coremultsntrup1013
extern void test_core_multsntrup1013(void);
#define test_core_multsntrup1277 ntruprime_test_coremultsntrup1277
extern void test_core_multsntrup1277(void);
#define test_core_scale3sntrup653 ntruprime_test_corescale3sntrup653
extern void test_core_scale3sntrup653(void);
#define test_core_scale3sntrup761 ntruprime_test_corescale3sntrup761
extern void test_core_scale3sntrup761(void);
#define test_core_scale3sntrup857 ntruprime_test_corescale3sntrup857
extern void test_core_scale3sntrup857(void);
#define test_core_scale3sntrup953 ntruprime_test_corescale3sntrup953
extern void test_core_scale3sntrup953(void);
#define test_core_scale3sntrup1013 ntruprime_test_corescale3sntrup1013
extern void test_core_scale3sntrup1013(void);
#define test_core_scale3sntrup1277 ntruprime_test_corescale3sntrup1277
extern void test_core_scale3sntrup1277(void);
#define test_core_weightsntrup653 ntruprime_test_coreweightsntrup653
extern void test_core_weightsntrup653(void);
#define test_core_weightsntrup761 ntruprime_test_coreweightsntrup761
extern void test_core_weightsntrup761(void);
#define test_core_weightsntrup857 ntruprime_test_coreweightsntrup857
extern void test_core_weightsntrup857(void);
#define test_core_weightsntrup953 ntruprime_test_coreweightsntrup953
extern void test_core_weightsntrup953(void);
#define test_core_weightsntrup1013 ntruprime_test_coreweightsntrup1013
extern void test_core_weightsntrup1013(void);
#define test_core_weightsntrup1277 ntruprime_test_coreweightsntrup1277
extern void test_core_weightsntrup1277(void);
#define test_core_wforcesntrup653 ntruprime_test_corewforcesntrup653
extern void test_core_wforcesntrup653(void);
#define test_core_wforcesntrup761 ntruprime_test_corewforcesntrup761
extern void test_core_wforcesntrup761(void);
#define test_core_wforcesntrup857 ntruprime_test_corewforcesntrup857
extern void test_core_wforcesntrup857(void);
#define test_core_wforcesntrup953 ntruprime_test_corewforcesntrup953
extern void test_core_wforcesntrup953(void);
#define test_core_wforcesntrup1013 ntruprime_test_corewforcesntrup1013
extern void test_core_wforcesntrup1013(void);
#define test_core_wforcesntrup1277 ntruprime_test_corewforcesntrup1277
extern void test_core_wforcesntrup1277(void);
#define test_kem_sntrup653 ntruprime_test_kemsntrup653
extern void test_kem_sntrup653(void);
#define test_kem_sntrup761 ntruprime_test_kemsntrup761
extern void test_kem_sntrup761(void);
#define test_kem_sntrup857 ntruprime_test_kemsntrup857
extern void test_kem_sntrup857(void);
#define test_kem_sntrup953 ntruprime_test_kemsntrup953
extern void test_kem_sntrup953(void);
#define test_kem_sntrup1013 ntruprime_test_kemsntrup1013
extern void test_kem_sntrup1013(void);
#define test_kem_sntrup1277 ntruprime_test_kemsntrup1277
extern void test_kem_sntrup1277(void);
#endif
