/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"

/* -- Begin Profiling Symbol Block for routine MPI_Win_toint */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Win_toint = PMPI_Win_toint
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Win_toint  MPI_Win_toint
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Win_toint as PMPI_Win_toint
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Win_toint(MPI_Win win)  __attribute__ ((weak, alias("PMPI_Win_toint")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Win_toint
#define MPI_Win_toint PMPI_Win_toint
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Win_toint(MPI_Win win)
{
    return (int) win;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Win_toint(QMPI_Context context, int tool_id, MPI_Win win)
{
    return internal_Win_toint(win);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Win_toint(MPI_Win win)
{
    QMPI_Context context;
    QMPI_Win_toint_t *fn_ptr;

    context.storage_stack = NULL;

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Win_toint(context, 0, win);

    fn_ptr = (QMPI_Win_toint_t *) MPIR_QMPI_first_fn_ptrs[MPI_WIN_TOINT_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_WIN_TOINT_T], win);
}
#else /* ENABLE_QMPI */
int MPI_Win_toint(MPI_Win win)
{
    return internal_Win_toint(win);
}

#endif /* ENABLE_QMPI */
