
#line 3 "lex.ncmpi.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer ncmpi_create_buffer
#define yy_delete_buffer ncmpi_delete_buffer
#define yy_flex_debug ncmpi_flex_debug
#define yy_init_buffer ncmpi_init_buffer
#define yy_flush_buffer ncmpi_flush_buffer
#define yy_load_buffer_state ncmpi_load_buffer_state
#define yy_switch_to_buffer ncmpi_switch_to_buffer
#define yyin ncmpiin
#define yyleng ncmpileng
#define yylex ncmpilex
#define yylineno ncmpilineno
#define yyout ncmpiout
#define yyrestart ncmpirestart
#define yytext ncmpitext
#define yywrap ncmpiwrap
#define yyalloc ncmpialloc
#define yyrealloc ncmpirealloc
#define yyfree ncmpifree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types.
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE ncmpirestart(ncmpiin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int ncmpileng;

extern FILE *ncmpiin, *ncmpiout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)

/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up ncmpitext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up ncmpitext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via ncmpirestart()), so that the user can continue scanning by
	 * just pointing ncmpiin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when ncmpitext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int ncmpileng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow ncmpiwrap()'s to do buffer switches
 * instead of setting up a fresh ncmpiin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void ncmpirestart (FILE *input_file  );
void ncmpi_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE ncmpi_create_buffer (FILE *file,int size  );
void ncmpi_delete_buffer (YY_BUFFER_STATE b  );
void ncmpi_flush_buffer (YY_BUFFER_STATE b  );
void ncmpipush_buffer_state (YY_BUFFER_STATE new_buffer  );
void ncmpipop_buffer_state (void );

static void ncmpiensure_buffer_stack (void );
static void ncmpi_load_buffer_state (void );
static void ncmpi_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER ncmpi_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE ncmpi_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE ncmpi_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE ncmpi_scan_bytes (yyconst char *bytes,int len  );

void *ncmpialloc (yy_size_t  );
void *ncmpirealloc (void *,yy_size_t  );
void ncmpifree (void *  );

#define yy_new_buffer ncmpi_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        ncmpiensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ncmpi_create_buffer(ncmpiin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        ncmpiensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ncmpi_create_buffer(ncmpiin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

typedef unsigned char YY_CHAR;

FILE *ncmpiin = (FILE *) 0, *ncmpiout = (FILE *) 0;

typedef int yy_state_type;

extern int ncmpilineno;

int ncmpilineno = 1;

extern char *ncmpitext;
#define yytext_ptr ncmpitext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up ncmpitext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	ncmpileng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 35
#define YY_END_OF_BUFFER 36
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[277] =
    {   0,
        0,    0,   36,   34,   33,   22,   34,   34,   34,   34,
       24,   34,   27,   27,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   33,    0,
        2,    0,    0,    0,   24,   27,   27,    0,    0,   24,
       24,    0,   25,    1,   28,   28,   23,   28,   27,   26,
        0,   27,   23,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,

       21,   21,   29,    0,    0,    0,    0,    0,   24,    0,
        0,   24,    1,   28,   24,   28,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,    7,   21,   21,   21,
       19,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,    7,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   32,   30,    0,    0,   24,    0,
       24,   25,   24,    5,    4,   21,   21,   21,   21,   21,
       21,   21,   21,   20,   21,    7,   21,    3,   21,   21,
       11,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   11,   21,   21,   21,   30,    0,

       31,    0,   20,    0,   17,   21,   21,   21,   21,   12,
       21,   21,   21,    6,    9,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,    0,   21,
        8,   21,   21,   21,   21,   21,   13,   21,   10,   21,
       21,   21,   21,   21,    0,   21,   21,   21,   21,    0,
       21,   21,   21,   21,   21,    0,   21,   21,   18,   18,
       21,   21,   21,   21,   21,   19,   21,   14,   21,   21,
       21,   21,   16,   21,   15,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    1,    1,    1,    7,    1,
        1,    1,    8,    1,    9,   10,   11,   12,   13,   13,
       13,   14,   13,   15,   13,   16,   16,   17,    1,    1,
        1,    1,    1,    6,   18,   19,   20,   21,   22,   23,
       24,   25,   26,   27,   27,   28,   29,   30,   31,   27,
       27,   32,   33,   34,   35,   36,   27,   37,   38,   27,
        6,   39,    6,    1,   27,    1,   40,   41,   42,   43,

       44,   45,   46,   47,   48,   27,   27,   49,   50,   51,
       52,   27,   27,   53,   54,   55,   56,   57,   27,   37,
       58,   27,   59,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[60] =
    {   0,
        1,    1,    2,    1,    1,    3,    4,    3,    3,    3,
        1,    5,    5,    5,    5,    5,    1,    5,    5,    5,
        5,    5,    5,    3,    3,    3,    3,    6,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    1,    5,
        5,    5,    5,    5,    5,    3,    3,    3,    6,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    7
    } ;

static yyconst flex_int16_t yy_base[287] =
    {   0,
        0,    0,  514,  515,   58,  515,   56,  474,   53,   88,
      121,  501,  161,  206,    0,  473,  485,   53,   73,   42,
       42,  478,   52,  486,  482,   87,  488,  447,  457,   59,
      454,  451,  449,  456,  455,  451,   67,  457,   74,   85,
      515,  493,  488,  113,    0,  139,    0,  228,  443,    0,
      515,  249,  515,    0,  110,   45,   81,  258,  515,  515,
        0,    0,  515,    0,  459,  474,  457,  461,  454,  432,
      217,  296,  456,  434,  451,  439,  453,  448,  451,  462,
      448,  440,  447,  448,  450,  442,  418,  432,  416,  420,
      413,  416,  412,  415,  393,  401,  385,  362,  368,  369,

      369,  361,  515,  406,  178,  405,   91,  263,  334,  366,
      268,  372,    0,  515,  293,  113,  388,  377,  390,  385,
      387,  364,    0,    0,  386,  363,  101,   32,  378,  381,
        0,  371,  366,  363,  362,  368,  361,  365,  346,  336,
      342,  337,  339,  338,   68,  330,  119,  326,  321,  318,
      317,  323,  318,  321,  515,  515,  239,  361,  515,  100,
      129,  158,  515,    0,    0,  350,  336,  337,  315,  329,
      306,  346,  335,    0,  307,    0,  335,    0,  320,  331,
      337,  322,  312,  325,  323,  286,  286,  279,  319,  286,
      310,  287,  274,  284,  312,  276,  272,  283,  515,  315,

      515,  313,  515,  267,  515,  282,  291,  262,  279,    0,
      282,  255,  277,    0,    0,  285,  272,  263,  277,  241,
      250,  249,  269,  246,  276,  241,  233,  246,  237,  243,
        0,  242,  208,  224,  194,  246,    0,  211,    0,  210,
      187,  174,  171,  175,  168,  186,  163,  168,  154,  209,
      187,  186,  148,  155,  153,  138,  165,  143,    0,  185,
      151,  136,  117,  120,  106,  515,  125,    0,  139,   77,
      112,  105,  515,   79,  515,  515,  421,  428,  433,  439,
      446,  449,   59,  452,  454,  459
    } ;

static yyconst flex_int16_t yy_def[287] =
    {   0,
      276,    1,  276,  276,  276,  276,  277,  278,  276,  276,
      276,  276,  276,  276,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  276,  277,
      276,  277,  276,  280,   11,   14,   14,  276,  276,   11,
      276,  276,  276,  281,   13,  282,  282,  282,  276,  276,
      283,   14,  276,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,

      279,  279,  276,  276,  276,  284,   46,  276,  276,  276,
      276,  276,  281,  276,   58,  283,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  276,  276,  276,  285,  276,  276,
      282,  282,  276,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  276,  276,

      276,  276,  276,  276,  276,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  276,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  276,  279,  279,  279,  279,  286,
      279,  279,  279,  279,  279,  276,  279,  279,  286,  286,
      279,  279,  279,  279,  279,  276,  279,  279,  279,  279,
      279,  279,  276,  279,  276,    0,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276
    } ;

static yyconst flex_int16_t yy_nxt[575] =
    {   0,
        4,    5,    6,    5,    7,    4,    8,    9,   10,   11,
       12,   13,   14,   14,   14,   14,    4,   15,   16,   17,
       18,   19,   20,   15,   15,   21,   15,   22,   15,   23,
       15,   24,   25,   15,   26,   27,   15,   15,    4,   15,
       28,   29,   30,   19,   31,   15,   15,   32,   33,   15,
       34,   15,   35,   36,   15,   37,   38,   15,    4,   39,
       41,   39,   45,  116,   46,   47,   47,   47,   47,   73,
       67,   75,  114,   78,   48,   39,  174,   39,   68,  175,
       71,   71,  189,   69,   72,   72,   72,   72,   72,   41,
       74,   79,   76,  114,   42,  275,   48,   45,   89,   46,

       47,   47,   47,   47,   70,   82,   90,   98,  114,   48,
       91,  190,   83,   49,   99,  172,   84,  100,  276,   85,
      101,  275,  173,   42,  105,  105,  105,  105,  273,  114,
      274,   48,   50,   50,   50,   50,   50,  114,  191,  276,
      114,   51,   52,   53,  203,   60,  276,  204,   51,  106,
      107,  107,  107,  107,  107,  273,  114,  272,  114,  271,
      192,  114,  268,   51,   52,   53,   60,  270,  269,   51,
       45,  268,   55,   55,   55,   55,   55,  114,   56,   57,
       56,   56,   58,   56,  156,  114,  260,  131,   59,  157,
      157,  157,  157,   60,  267,  266,  265,   61,  264,  263,

       56,   57,   56,   56,   58,   56,  114,  262,  261,   59,
      260,  131,  174,  258,   60,   45,  257,   62,   62,   62,
       62,   62,  256,  255,   63,  254,  176,   48,   72,   72,
       72,   72,   72,   59,  253,  108,  108,  252,   60,  109,
      109,  109,  109,  109,  251,  199,   63,  250,  249,   48,
      200,  200,  200,  200,   59,  176,  111,  111,  248,   60,
      112,  112,  112,  112,  112,  108,  108,  247,  246,  115,
      115,  115,  115,  115,  109,  109,  109,  109,  109,  112,
      112,  112,  112,  112,  245,  114,  244,  239,  243,  237,
      236,  236,  242,  231,  241,  240,  239,  238,  237,  236,

      276,  276,  235,  234,  233,  232,  114,   72,   72,   72,
       72,   72,  231,  161,  230,  162,  123,  229,  124,  201,
      163,  199,  228,  123,  227,  226,  225,  215,  214,  224,
      223,  222,  210,  178,  221,  161,  220,  162,  123,  205,
      124,  163,  219,  218,  123,  109,  109,  109,  109,  109,
      217,  216,  215,  214,  159,  213,   53,  212,  211,  210,
      209,  159,  178,  208,  207,  206,  205,  201,  198,  197,
      196,  195,  194,  193,  178,  176,  159,  188,   53,  187,
      186,  185,  159,  112,  112,  112,  112,  112,  165,  164,
      184,  183,   51,  182,   53,  181,  180,  179,  178,   51,

      177,  176,  171,  170,  169,  168,  167,  166,  165,  164,
      160,  155,  155,  154,   51,  153,   53,  152,  151,  150,
       51,   40,   40,   40,   40,   40,   40,   40,   43,   43,
       43,   43,   43,   43,   43,   64,  149,   64,   64,  104,
      148,  104,  104,  104,  104,  104,  113,  147,  113,  113,
      113,  113,  113,   56,   56,  158,  158,  202,  202,  259,
      259,  259,  259,  259,  259,  146,  145,  144,  143,  142,
      141,  140,  139,  138,  137,  136,  135,  134,  133,  132,
      131,  130,  129,  128,  127,  126,  125,  122,  121,  120,
      119,  118,  117,  110,  103,  276,  102,   97,   96,   95,

       94,   93,   92,   88,   87,   86,   81,   80,   77,   66,
       65,   54,   44,  276,    3,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276
    } ;

static yyconst flex_int16_t yy_chk[575] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    5,
        7,    5,    9,  283,    9,    9,    9,    9,    9,   20,
       18,   21,   56,   23,    9,   39,  128,   39,   18,  128,
       19,   19,  145,   18,   19,   19,   19,   19,   19,   40,
       20,   23,   21,   56,    7,  274,    9,   10,   30,   10,

       10,   10,   10,   10,   18,   26,   30,   37,   57,   10,
       30,  145,   26,   10,   37,  127,   26,   37,  107,   26,
       37,  272,  127,   40,   44,   44,   44,   44,  271,   57,
      270,   10,   11,   11,   11,   11,   11,   55,  147,  107,
      116,   11,   11,   11,  160,  116,   55,  160,   11,   44,
       46,   46,   46,   46,   46,  269,  161,  267,   55,  265,
      147,  116,  264,   11,   11,   11,  116,  263,  262,   11,
       13,  261,   13,   13,   13,   13,   13,  161,   13,   13,
       13,   13,   13,   13,  105,  162,  260,  258,   13,  105,
      105,  105,  105,   13,  257,  256,  255,   13,  254,  253,

       13,   13,   13,   13,   13,   13,  162,  252,  251,   13,
      250,  249,  248,  247,   13,   14,  246,   14,   14,   14,
       14,   14,  245,  244,   14,  243,  242,   14,   71,   71,
       71,   71,   71,   14,  241,   48,   48,  240,   14,   48,
       48,   48,   48,   48,  238,  157,   14,  236,  235,   14,
      157,  157,  157,  157,   14,  234,   52,   52,  233,   14,
       52,   52,   52,   52,   52,   58,   58,  232,  230,   58,
       58,   58,   58,   58,  108,  108,  108,  108,  108,  111,
      111,  111,  111,  111,  229,   58,  228,  227,  226,  225,
      224,  223,  222,  221,  220,  219,  218,  217,  216,  213,

      115,  115,  212,  211,  209,  208,   58,   72,   72,   72,
       72,   72,  207,  115,  206,  115,   72,  204,   72,  202,
      115,  200,  198,   72,  197,  196,  195,  194,  193,  192,
      191,  190,  189,  188,  187,  115,  186,  115,   72,  185,
       72,  115,  184,  183,   72,  109,  109,  109,  109,  109,
      182,  181,  180,  179,  109,  177,  109,  175,  173,  172,
      171,  109,  170,  169,  168,  167,  166,  158,  154,  153,
      152,  151,  150,  149,  148,  146,  109,  144,  109,  143,
      142,  141,  109,  112,  112,  112,  112,  112,  140,  139,
      138,  137,  112,  136,  112,  135,  134,  133,  132,  112,

      130,  129,  126,  125,  122,  121,  120,  119,  118,  117,
      110,  106,  104,  102,  112,  101,  112,  100,   99,   98,
      112,  277,  277,  277,  277,  277,  277,  277,  278,  278,
      278,  278,  278,  278,  278,  279,   97,  279,  279,  280,
       96,  280,  280,  280,  280,  280,  281,   95,  281,  281,
      281,  281,  281,  282,  282,  284,  284,  285,  285,  286,
      286,  286,  286,  286,  286,   94,   93,   92,   91,   90,
       89,   88,   87,   86,   85,   84,   83,   82,   81,   80,
       79,   78,   77,   76,   75,   74,   73,   70,   69,   68,
       67,   66,   65,   49,   43,   42,   38,   36,   35,   34,

       33,   32,   31,   29,   28,   27,   25,   24,   22,   17,
       16,   12,    8,    3,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  276,  276,  276,  276,
      276,  276,  276,  276
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int ncmpi_flex_debug;
int ncmpi_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *ncmpitext;
#line 1 "./ncmpigen.l"
#line 2 "./ncmpigen.l"
/*********************************************************************
 *   Copyright 1993, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Id$
 *********************************************************************/

/* lex specification for tokens for ncmpigen */

/* Fill value used by ncdump from version 2.4 and later.  Should match
   definition of FILL_STRING in ../ncdump/vardata.h */
#define FILL_STRING "_"
#define XDR_INT_MIN (-2147483647-1)
#define XDR_INT_MAX 2147483647
#define XDR_INT64_MIN  (-9223372036854775807LL-1)
#define XDR_INT64_MAX  (9223372036854775807LL)

char errstr[100];		/* for short error messages */

#include <string.h>
#include <ctype.h>
#include <errno.h>   /* errno */
#include "genlib.h"
#include "ncmpigentab.h"

#define YY_BREAK                /* defining as nothing eliminates unreachable
				   statement warnings from flex output,
                                   but make sure every action ends with
                                   "return" or "break"! */

#line 714 "lex.ncmpi.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int ncmpilex_destroy (void );

int ncmpiget_debug (void );

void ncmpiset_debug (int debug_flag  );

YY_EXTRA_TYPE ncmpiget_extra (void );

void ncmpiset_extra (YY_EXTRA_TYPE user_defined  );

FILE *ncmpiget_in (void );

void ncmpiset_in  (FILE * in_str  );

FILE *ncmpiget_out (void );

void ncmpiset_out  (FILE * out_str  );

int ncmpiget_leng (void );

char *ncmpiget_text (void );

int ncmpiget_lineno (void );

void ncmpiset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int ncmpiwrap (void );
#else
extern int ncmpiwrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( ncmpitext, ncmpileng, 1, ncmpiout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		unsigned n; \
		for ( n = 0; n < max_size && \
			     (c = getc( ncmpiin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( ncmpiin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, ncmpiin))==0 && ferror(ncmpiin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(ncmpiin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int ncmpilex (void);

#define YY_DECL int ncmpilex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after ncmpitext and ncmpileng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 38 "./ncmpigen.l"

#line 898 "lex.ncmpi.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! ncmpiin )
			ncmpiin = stdin;

		if ( ! ncmpiout )
			ncmpiout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			ncmpiensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				ncmpi_create_buffer(ncmpiin,YY_BUF_SIZE );
		}

		ncmpi_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of ncmpitext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 277 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 515 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 39 "./ncmpigen.l"
{ /* comment */
                          break;
                        }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 43 "./ncmpigen.l"
{
			 if(ncmpileng > MAXTRST) {
				yyerror("string too long, truncated\n");
			        ncmpitext[MAXTRST-1] = '\0';
			 }
			 expand_escapes(termstring,(char *)ncmpitext,ncmpileng);
		 	 return (TERMSTRING);
		        }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 52 "./ncmpigen.l"
{return (FLOAT_K);}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 53 "./ncmpigen.l"
{return (CHAR_K);}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 54 "./ncmpigen.l"
{return (BYTE_K);}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 55 "./ncmpigen.l"
{return (SHORT_K);}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 56 "./ncmpigen.l"
{return (INT_K);}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 57 "./ncmpigen.l"
{return (DOUBLE_K);}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 58 "./ncmpigen.l"
{return (UBYTE_K);}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 59 "./ncmpigen.l"
{return (USHORT_K);}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 60 "./ncmpigen.l"
{return (UINT_K);}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 61 "./ncmpigen.l"
{return (INT64_K);}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 62 "./ncmpigen.l"
{return (UINT64_K);}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 63 "./ncmpigen.l"
{int_val = -1;
			 return (NC_UNLIMITED_K);}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 66 "./ncmpigen.l"
{return (DIMENSIONS);}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 67 "./ncmpigen.l"
{return (VARIABLES);}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 68 "./ncmpigen.l"
{return (DATA);}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 69 "./ncmpigen.l"
{
		char *s = (char*)ncmpitext+strlen("netcdf");
		char *t = (char*)ncmpitext+ncmpileng-1;
		while (isspace(*s))
			s++;
		while (isspace(*t))
			t--;
		t++;
                if (t-s+1 < 1) {
                        yyerror("netCDF name required");
                        return (DATA); /* generate syntax error */
                }
		netcdfname = (char *) emalloc(t-s+1);
		(void) strncpy(netcdfname, s, t-s);
		netcdfname[t-s] = '\0';
		return (NETCDF);
		}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 86 "./ncmpigen.l"
{ /* missing value (pre-2.4 backward compatibility) */
                if (ncmpitext[0] == '-') {
		    double_val = -NC_FILL_DOUBLE;
                } else {
		    double_val = NC_FILL_DOUBLE;
                }
		return (DOUBLE_CONST);
		}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 94 "./ncmpigen.l"
{ /* missing value (pre-2.4 backward compatibility) */
                if (ncmpitext[0] == '-') {
		    float_val = -NC_FILL_FLOAT;
                } else {
		    float_val = NC_FILL_FLOAT;
                }
		return (FLOAT_CONST);
		}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 102 "./ncmpigen.l"
{
                if (STREQ((char *)ncmpitext, FILL_STRING))
		        return (FILLVALUE);
		if ((yylval = lookup((char *)ncmpitext)) == NULL) {
			yylval = install((char *)ncmpitext);
		}
		return (IDENT);
		}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 111 "./ncmpigen.l"
{
		lineno++ ;
                break;
		}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 116 "./ncmpigen.l"
{
                int ii;
		if (sscanf((char*)ncmpitext, "%d", &ii) != 1) {
		    sprintf(errstr,"bad byte constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
                byte_val = ii;
		if (ii != (int)byte_val) {
		    sprintf(errstr,"byte constant out of range (-128,127): %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
		return (BYTE_CONST);
                }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 130 "./ncmpigen.l"
{
		if (sscanf((char*)ncmpitext, "%le", &double_val) != 1) {
		    sprintf(errstr,"bad long or double constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
                return (DOUBLE_CONST);
                }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 137 "./ncmpigen.l"
{
		if (sscanf((char*)ncmpitext, "%e", &float_val) != 1) {
		    sprintf(errstr,"bad float constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
                return (FLOAT_CONST);
                }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 144 "./ncmpigen.l"
{
		if (sscanf((char*)ncmpitext, "%hd", &short_val) != 1) {
		    sprintf(errstr,"bad short constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
		return (SHORT_CONST);
	        }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 151 "./ncmpigen.l"
{
    		char *ptr;
                errno = 0;
		double_val = strtod((char*)ncmpitext, &ptr);
		if (errno != 0 && double_val == 0.0) {
		    sprintf(errstr,"bad numerical constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
                if (double_val < XDR_INT_MIN ||double_val > XDR_INT_MAX) {
                    return DOUBLE_CONST;
                } else {
                    int_val = (int) double_val;
                    return INT_CONST;
                }
	        }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 166 "./ncmpigen.l"
{
    		char *ptr;
                long long_val;
                errno = 0;
		long_val = strtol((char*)ncmpitext, &ptr, 0);
		if (errno != 0) {
		    sprintf(errstr,"bad long constant: %s",(char*)ncmpitext);
		    yyerror(errstr);
		}
                if (long_val < XDR_INT_MIN || long_val > XDR_INT_MAX) {
                    double_val = (double) long_val;
                    return DOUBLE_CONST;
                } else {
                    int_val = (int) long_val;
                    return INT_CONST;
                }
	        }
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 183 "./ncmpigen.l"
{
	        (void) sscanf((char*)&ncmpitext[1],"%c",&byte_val);
		return (BYTE_CONST);
                }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 187 "./ncmpigen.l"
{
		byte_val = (char) strtol((char*)&ncmpitext[2], (char **) 0, 8);
		return (BYTE_CONST);
                }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 191 "./ncmpigen.l"
{
		byte_val = (char) strtol((char*)&ncmpitext[3], (char **) 0, 16);
		return (BYTE_CONST);
                }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 195 "./ncmpigen.l"
{
	       switch ((char)ncmpitext[2]) {
	          case 'a': byte_val = '\007'; break; /* not everyone under-
						       * stands '\a' yet */
     	          case 'b': byte_val = '\b'; break;
		  case 'f': byte_val = '\f'; break;
		  case 'n': byte_val = '\n'; break;
		  case 'r': byte_val = '\r'; break;
		  case 't': byte_val = '\t'; break;
		  case 'v': byte_val = '\v'; break;
		  case '\\': byte_val = '\\'; break;
		  case '?': byte_val = '\177'; break;
		  case '\'': byte_val = '\''; break;
		  default: byte_val = (char)ncmpitext[2];
	           }
		return (BYTE_CONST);
                }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 213 "./ncmpigen.l"
{ /* whitespace */
		  break;
		}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 216 "./ncmpigen.l"
return (ncmpitext[0]) ;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 217 "./ncmpigen.l"
ECHO;
	YY_BREAK
#line 1297 "lex.ncmpi.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed ncmpiin at a new source and called
			 * ncmpilex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = ncmpiin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( ncmpiwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * ncmpitext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of ncmpilex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					ncmpirealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			ncmpirestart(ncmpiin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) ncmpirealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 277 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 277 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 276);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;

    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up ncmpitext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;

	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					ncmpirestart(ncmpiin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( ncmpiwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve ncmpitext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 *
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void ncmpirestart  (FILE * input_file )
{

	if ( ! YY_CURRENT_BUFFER ){
        ncmpiensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            ncmpi_create_buffer(ncmpiin,YY_BUF_SIZE );
	}

	ncmpi_init_buffer(YY_CURRENT_BUFFER,input_file );
	ncmpi_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 *
 */
    void ncmpi_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		ncmpipop_buffer_state();
	 *		ncmpipush_buffer_state(new_buffer);
     */
	ncmpiensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	ncmpi_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (ncmpiwrap()) processing, but the only time this flag
	 * is looked at is after ncmpiwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void ncmpi_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	ncmpiin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 *
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE ncmpi_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) ncmpialloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in ncmpi_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) ncmpialloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in ncmpi_create_buffer()" );

	b->yy_is_our_buffer = 1;

	ncmpi_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with ncmpi_create_buffer()
 *
 */
    void ncmpi_delete_buffer (YY_BUFFER_STATE  b )
{

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		ncmpifree((void *) b->yy_ch_buf  );

	ncmpifree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a ncmpirestart() or at EOF.
 */
    static void ncmpi_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;

	ncmpi_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then ncmpi_init_buffer was _probably_
     * called from ncmpirestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;

	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 *
 */
    void ncmpi_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		ncmpi_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *
 */
void ncmpipush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	ncmpiensure_buffer_stack();

	/* This block is copied from ncmpi_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from ncmpi_switch_to_buffer. */
	ncmpi_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *
 */
void ncmpipop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	ncmpi_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		ncmpi_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void ncmpiensure_buffer_stack (void)
{
	int num_to_alloc;

	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)ncmpialloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ncmpiensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)ncmpirealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ncmpiensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE ncmpi_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) ncmpialloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in ncmpi_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	ncmpi_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to ncmpilex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 *
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       ncmpi_scan_bytes() instead.
 */
YY_BUFFER_STATE ncmpi_scan_string (yyconst char * yystr )
{

	return ncmpi_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to ncmpilex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE ncmpi_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) ncmpialloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in ncmpi_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = ncmpi_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in ncmpi_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up ncmpitext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		ncmpitext[ncmpileng] = (yy_hold_char); \
		(yy_c_buf_p) = ncmpitext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		ncmpileng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 *
 */
int ncmpiget_lineno  (void)
{

    return ncmpilineno;
}

/** Get the input stream.
 *
 */
FILE *ncmpiget_in  (void)
{
        return ncmpiin;
}

/** Get the output stream.
 *
 */
FILE *ncmpiget_out  (void)
{
        return ncmpiout;
}

/** Get the length of the current token.
 *
 */
int ncmpiget_leng  (void)
{
        return ncmpileng;
}

/** Get the current token.
 *
 */

char *ncmpiget_text  (void)
{
        return ncmpitext;
}

/** Set the current line number.
 * @param line_number
 *
 */
void ncmpiset_lineno (int  line_number )
{

    ncmpilineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 *
 * @see ncmpi_switch_to_buffer
 */
void ncmpiset_in (FILE *  in_str )
{
        ncmpiin = in_str ;
}

void ncmpiset_out (FILE *  out_str )
{
        ncmpiout = out_str ;
}

int ncmpiget_debug  (void)
{
        return ncmpi_flex_debug;
}

void ncmpiset_debug (int  bdebug )
{
        ncmpi_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from ncmpilex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    ncmpiin = stdin;
    ncmpiout = stdout;
#else
    ncmpiin = (FILE *) 0;
    ncmpiout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * ncmpilex_init()
     */
    return 0;
}

/* ncmpilex_destroy is for both reentrant and non-reentrant scanners. */
int ncmpilex_destroy  (void)
{

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		ncmpi_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		ncmpipop_buffer_state();
	}

	/* Destroy the stack itself. */
	ncmpifree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * ncmpilex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *ncmpialloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *ncmpirealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void ncmpifree (void * ptr )
{
	free( (char *) ptr );	/* see ncmpirealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 217 "./ncmpigen.l"
