/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/*
 * This file is based on WME Lite.
 * http://dead-code.org/redir.php?target=wmelite
 * Copyright (c) 2011 Jan Nedoma
 */

#include "engines/wintermute/base/base_scriptable.h"
#include "engines/wintermute/base/scriptables/script_value.h"
#include "engines/wintermute/base/scriptables/script_stack.h"

#ifndef WINTERMUTE_PLUGINS_H
#define WINTERMUTE_PLUGINS_H

namespace Wintermute {

// Implemented in their respective .cpp-files
BaseScriptable *makeSXSteamAPI(BaseGame *inGame, ScStack *stack);
BaseScriptable *makeSXWMEGalaxyAPI(BaseGame *inGame, ScStack *stack);
BaseScriptable *makeSX3fStatistics(BaseGame *inGame, ScStack *stack);

bool EmulatePluginCall(BaseGame *inGame, ScStack *stack, ScStack *thisStack, char *name) {
	ScValue *thisObj;

	//////////////////////////////////////////////////////////////////////////
	// SteamAPI (from wme_steam.dll)
	//////////////////////////////////////////////////////////////////////////
	if (strcmp(name, "SteamAPI") == 0) {
		thisObj = thisStack->getTop();

		thisObj->setNative(makeSXSteamAPI(inGame,  stack));

		stack->pushNULL();
		return STATUS_OK;
	}

	//////////////////////////////////////////////////////////////////////////
	// WMEGalaxyAPI (from GOG version of julia.exe)
	//////////////////////////////////////////////////////////////////////////
	else if (strcmp(name, "WMEGalaxyAPI") == 0) {
		thisObj = thisStack->getTop();

		thisObj->setNative(makeSXWMEGalaxyAPI(inGame,  stack));

		stack->pushNULL();
		return STATUS_OK;
	}

	//////////////////////////////////////////////////////////////////////////
	// Statistics (from wme_3fstatistics.dll)
	//////////////////////////////////////////////////////////////////////////
	else if (strcmp(name, "Statistics") == 0) {
		thisObj = thisStack->getTop();

		thisObj->setNative(makeSX3fStatistics(inGame,  stack));

		stack->pushNULL();
		return STATUS_OK;
	}

	return STATUS_FAILED;
}

} // End of namespace Wintermute

#endif
