#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    sisu
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_libs
  require_relative 'sisu/hub'                               # sisu/hub.rb
  require_relative 'sisu/se'                                # sisu/se.rb
  require_relative 'sisu/utils'                             # sisu/utils.rb
  class CallHubMaster
    def initialize(argv,sisu_runtime)
      begin
        SiSU::HubMaster.new(argv,sisu_runtime)
      rescue
        SiSU_Screen::Ansi.new(argv).rescue do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        Dir.chdir(sisu_runtime[:call_path])
      end
    end
  end
  class HubClose
    def initialize(argv,call_path)
      begin
        env=SiSU_Env::InfoEnv.new
      rescue
      ensure
        if FileTest.directory?(env.processing_path.processing) \
        and FileTest.directory?(env.processing_path.processing_base_tmp) \
        and env.processing_path.processing_base_tmp =~/#{env.processing_path.processing}/ \
        and env.processing_path.processing_base_tmp =~/^\/tmp\/\S+/ \
        and not argv.inspect =~/"--maintenance"|"-M"/
          FileUtils::cd(env.processing_path.processing_base_tmp) do
            FileUtils::rm_rf('.')
          end
        end
        Dir.chdir(call_path)
      end
    end
  end
end
__END__
