# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class ServerConfigInstance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'short_description': 'str',
        'default_client_route': 'str',
        'is_nsfw': 'bool',
        'default_nsfw_policy': 'str',
        'customizations': 'ServerConfigInstanceCustomizations'
    }

    attribute_map = {
        'name': 'name',
        'short_description': 'shortDescription',
        'default_client_route': 'defaultClientRoute',
        'is_nsfw': 'isNSFW',
        'default_nsfw_policy': 'defaultNSFWPolicy',
        'customizations': 'customizations'
    }

    def __init__(self, name=None, short_description=None, default_client_route=None, is_nsfw=None, default_nsfw_policy=None, customizations=None, local_vars_configuration=None):  # noqa: E501
        """ServerConfigInstance - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._short_description = None
        self._default_client_route = None
        self._is_nsfw = None
        self._default_nsfw_policy = None
        self._customizations = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if short_description is not None:
            self.short_description = short_description
        if default_client_route is not None:
            self.default_client_route = default_client_route
        if is_nsfw is not None:
            self.is_nsfw = is_nsfw
        if default_nsfw_policy is not None:
            self.default_nsfw_policy = default_nsfw_policy
        if customizations is not None:
            self.customizations = customizations

    @property
    def name(self):
        """Gets the name of this ServerConfigInstance.  # noqa: E501


        :return: The name of this ServerConfigInstance.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServerConfigInstance.


        :param name: The name of this ServerConfigInstance.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def short_description(self):
        """Gets the short_description of this ServerConfigInstance.  # noqa: E501


        :return: The short_description of this ServerConfigInstance.  # noqa: E501
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this ServerConfigInstance.


        :param short_description: The short_description of this ServerConfigInstance.  # noqa: E501
        :type short_description: str
        """

        self._short_description = short_description

    @property
    def default_client_route(self):
        """Gets the default_client_route of this ServerConfigInstance.  # noqa: E501


        :return: The default_client_route of this ServerConfigInstance.  # noqa: E501
        :rtype: str
        """
        return self._default_client_route

    @default_client_route.setter
    def default_client_route(self, default_client_route):
        """Sets the default_client_route of this ServerConfigInstance.


        :param default_client_route: The default_client_route of this ServerConfigInstance.  # noqa: E501
        :type default_client_route: str
        """

        self._default_client_route = default_client_route

    @property
    def is_nsfw(self):
        """Gets the is_nsfw of this ServerConfigInstance.  # noqa: E501


        :return: The is_nsfw of this ServerConfigInstance.  # noqa: E501
        :rtype: bool
        """
        return self._is_nsfw

    @is_nsfw.setter
    def is_nsfw(self, is_nsfw):
        """Sets the is_nsfw of this ServerConfigInstance.


        :param is_nsfw: The is_nsfw of this ServerConfigInstance.  # noqa: E501
        :type is_nsfw: bool
        """

        self._is_nsfw = is_nsfw

    @property
    def default_nsfw_policy(self):
        """Gets the default_nsfw_policy of this ServerConfigInstance.  # noqa: E501


        :return: The default_nsfw_policy of this ServerConfigInstance.  # noqa: E501
        :rtype: str
        """
        return self._default_nsfw_policy

    @default_nsfw_policy.setter
    def default_nsfw_policy(self, default_nsfw_policy):
        """Sets the default_nsfw_policy of this ServerConfigInstance.


        :param default_nsfw_policy: The default_nsfw_policy of this ServerConfigInstance.  # noqa: E501
        :type default_nsfw_policy: str
        """

        self._default_nsfw_policy = default_nsfw_policy

    @property
    def customizations(self):
        """Gets the customizations of this ServerConfigInstance.  # noqa: E501


        :return: The customizations of this ServerConfigInstance.  # noqa: E501
        :rtype: ServerConfigInstanceCustomizations
        """
        return self._customizations

    @customizations.setter
    def customizations(self, customizations):
        """Sets the customizations of this ServerConfigInstance.


        :param customizations: The customizations of this ServerConfigInstance.  # noqa: E501
        :type customizations: ServerConfigInstanceCustomizations
        """

        self._customizations = customizations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerConfigInstance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerConfigInstance):
            return True

        return self.to_dict() != other.to_dict()
