"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("@emotion/react");
const emotion_normalize_1 = __importDefault(require("emotion-normalize"));
const GlobalCssVariables_1 = require("./Theme/GlobalCssVariables");
const getGlobalStyles = (theme) => ({
    '*': {
        boxSizing: 'border-box',
    },
    'b, strong': {
        fontWeight: 600,
    },
    body: Object.assign(Object.assign({}, GlobalCssVariables_1.GlobalCssVariables.accentColors()), { MozOsxFontSmoothing: 'grayscale', WebkitFontSmoothing: 'antialiased', background: theme.general.backgroundColor, color: theme.general.color, display: 'flex', flexDirection: 'column', minHeight: '100vh', transition: 'background 0.15s' }),
    'body, body.theme-default': Object.assign({}, GlobalCssVariables_1.GlobalCssVariables.light()),
    'body.theme-dark': Object.assign({}, GlobalCssVariables_1.GlobalCssVariables.dark()),
    html: {
        background: theme.general.backgroundColor,
        transition: 'background 0.15s',
        fontSize: '16px',
    },
    p: {
        marginTop: 0,
    },
});
const getGlobalFontStyle = () => ({
    body: {
        fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji";',
        fontWeight: 400,
        lineHeight: 1.5,
    },
});
exports.GlobalStyle = (0, react_1.withTheme)(({ theme }) => {
    return ((0, jsx_runtime_1.jsx)(react_1.Global, { styles: (0, react_1.css) `
        ${emotion_normalize_1.default}
        ${getGlobalStyles(theme)}
        ${getGlobalFontStyle()}
      ` }));
});
