"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvatarGrid = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Avatar_1 = require("./Avatar");
const colors_1 = require("./colors");
const Misc_1 = require("../Misc/");
const util_1 = require("../util");
const avatarGridStyle = ({ borderWidth, size, backgroundColor = colors_1.COLOR.GRAY_DARKEN_48, borderColor = colors_1.COLOR.GRAY_DARKEN_48, }) => {
    return {
        alignItems: 'start',
        backgroundColor: backgroundColor,
        border: `${borderWidth}px solid ${borderColor}`,
        borderRadius: '16%',
        display: 'grid',
        gridGap: borderWidth,
        gridTemplateColumns: 'repeat(2, 1fr)',
        gridTemplateRows: 'repeat(2, 1fr)',
        height: `${size}px`,
        justifyItems: 'center',
        minWidth: `${size}px`,
        overflow: 'hidden',
        width: `${size}px`,
    };
};
const filteredAvatarGridProps = (props) => (0, util_1.filterProps)(props, ['backgroundColor', 'borderColor', 'items', 'size', 'borderWidth']);
const AvatarGrid = (_a) => {
    var { borderWidth = 1, size = Avatar_1.DEFAULT_AVATAR_SIZE, items, fetchImages } = _a, props = __rest(_a, ["borderWidth", "size", "items", "fetchImages"]);
    const allProps = Object.assign({ borderWidth, items, size }, props);
    const slicedItems = items.slice(0, 4);
    const missing = 4 - slicedItems.length;
    for (let index = 0; index < missing; index++) {
        slicedItems.push(null);
    }
    return ((0, jsx_runtime_1.jsx)(Misc_1.IsInViewport, Object.assign({ checkViewportOnce: true, onEnterViewport: fetchImages, css: avatarGridStyle(allProps) }, filteredAvatarGridProps(allProps), { children: slicedItems.map(item => item ? ((0, jsx_runtime_1.jsx)(Avatar_1.Avatar, { backgroundColor: item.backgroundColor || colors_1.COLOR.GRAY_DARKEN_80, url: item.url, color: item.color, forceInitials: item.forceInitials, isAvatarGridItem: true, name: item.name, size: size / 2 - borderWidth, style: { height: '100%', width: '100%' } }, Math.random().toString())) : ((0, jsx_runtime_1.jsx)("div", { css: {
                backgroundColor: colors_1.COLOR.GRAY_DARKEN_80,
                height: '100%',
                width: '100%',
            } }, Math.random().toString()))) })));
};
exports.AvatarGrid = AvatarGrid;
