/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.util.test.FreeColTestCase;

public class RoleTest
extends FreeColTestCase {
    private static final GoodsType horses = RoleTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType muskets = RoleTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType tools = RoleTest.spec().getGoodsType("model.goods.tools");
    private static final Role none = RoleTest.spec().getDefaultRole();
    private static final Role scout = RoleTest.spec().getRole("model.role.scout");
    private static final Role soldier = RoleTest.spec().getRole("model.role.soldier");
    private static final Role dragoon = RoleTest.spec().getRole("model.role.dragoon");
    private static final Role pioneer = RoleTest.spec().getRole("model.role.pioneer");
    private static final Role mission = RoleTest.spec().getRole("model.role.missionary");
    private static final Role infantry = RoleTest.spec().getRole("model.role.infantry");
    private static final Role cavalry = RoleTest.spec().getRole("model.role.cavalry");
    private static final Role armedBrave = RoleTest.spec().getRole("model.role.armedBrave");
    private static final Role mountedBrave = RoleTest.spec().getRole("model.role.mountedBrave");
    private static final Role nativeDragoon = RoleTest.spec().getRole("model.role.nativeDragoon");
    private static final UnitType braveType = RoleTest.spec().getUnitType("model.unit.brave");
    private static final UnitType colonistType = RoleTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType kingsRegularType = RoleTest.spec().getUnitType("model.unit.kingsRegular");

    public void testRoleComparator() {
        RoleTest.assertEquals((int)0, (int)Role.militaryComparator.compare(soldier, soldier));
        RoleTest.assertEquals((int)0, (int)Role.militaryComparator.compare(dragoon, dragoon));
        RoleTest.assertEquals((int)0, (int)Role.militaryComparator.compare(mission, mission));
        RoleTest.assertEquals((int)-1, (int)Role.militaryComparator.compare(dragoon, soldier));
        RoleTest.assertEquals((int)1, (int)Role.militaryComparator.compare(soldier, dragoon));
        RoleTest.assertEquals((int)1, (int)Role.militaryComparator.compare(mission, soldier));
        RoleTest.assertEquals((int)-1, (int)Role.militaryComparator.compare(dragoon, mission));
    }

    public void testCompatibleRoles() {
        RoleTest.assertFalse((boolean)soldier.isCompatibleWith(none));
        RoleTest.assertFalse((boolean)soldier.isCompatibleWith(pioneer));
        RoleTest.assertFalse((boolean)soldier.isCompatibleWith(mission));
        RoleTest.assertTrue((boolean)soldier.isCompatibleWith(soldier));
        RoleTest.assertFalse((boolean)soldier.isCompatibleWith(scout));
        RoleTest.assertTrue((boolean)soldier.isCompatibleWith(dragoon));
        RoleTest.assertFalse((boolean)mission.isCompatibleWith(none));
        RoleTest.assertFalse((boolean)mission.isCompatibleWith(pioneer));
        RoleTest.assertTrue((boolean)mission.isCompatibleWith(mission));
        RoleTest.assertFalse((boolean)mission.isCompatibleWith(soldier));
        RoleTest.assertFalse((boolean)mission.isCompatibleWith(scout));
        RoleTest.assertFalse((boolean)mission.isCompatibleWith(dragoon));
    }

    public void testGoodsDifference() {
        RoleTest.assertTrue((boolean)Role.getGoodsDifference(null, 1, none, 1).isEmpty());
        RoleTest.assertTrue((boolean)Role.getGoodsDifference(none, 1, none, 1).isEmpty());
        RoleTest.assertTrue((boolean)Role.getGoodsDifference(none, 1, mission, 1).isEmpty());
        RoleTest.assertTrue((boolean)Role.getGoodsDifference(mission, 1, none, 1).isEmpty());
        List<AbstractGoods> goods = Role.getGoodsDifference(none, 1, soldier, 1);
        this.checkGoods("->soldier", goods, new AbstractGoods(muskets, 50));
        goods = Role.getGoodsDifference(soldier, 1, dragoon, 1);
        this.checkGoods("soldier->dragoon", goods, new AbstractGoods(horses, 50));
        goods = Role.getGoodsDifference(mission, 1, dragoon, 1);
        this.checkGoods("missionary->dragoon", goods, new AbstractGoods(horses, 50), new AbstractGoods(muskets, 50));
        goods = Role.getGoodsDifference(soldier, 1, none, 1);
        this.checkGoods("soldier->", goods, new AbstractGoods(muskets, -50));
        goods = Role.getGoodsDifference(nativeDragoon, 1, armedBrave, 1);
        this.checkGoods("nativeDragoon->armedBrave", goods, new AbstractGoods(horses, -25));
        goods = Role.getGoodsDifference(soldier, 1, pioneer, 4);
        this.checkGoods("soldier->pioneer(4)", goods, new AbstractGoods(muskets, -50), new AbstractGoods(tools, 80));
    }

    public void testMilitaryRoles() {
        Game game = RoleTest.getStandardGame();
        List<Role> military = RoleTest.spec().getMilitaryRolesList();
        ArrayList<Role> expectedRoles = new ArrayList<Role>();
        expectedRoles.add(dragoon);
        expectedRoles.add(soldier);
        expectedRoles.add(scout);
        List<Role> colonialRoles = Role.getAvailableRoles(game.getPlayerByNationId("model.nation.dutch"), colonistType, military);
        RoleTest.assertTrue((boolean)expectedRoles.equals(colonialRoles));
        expectedRoles.clear();
        expectedRoles.add(cavalry);
        expectedRoles.add(infantry);
        List<Role> royalRoles = Role.getAvailableRoles(game.getPlayerByNationId("model.nation.dutchREF"), kingsRegularType, military);
        RoleTest.assertTrue((boolean)expectedRoles.equals(royalRoles));
        expectedRoles.clear();
        expectedRoles.add(nativeDragoon);
        expectedRoles.add(armedBrave);
        expectedRoles.add(mountedBrave);
        List<Role> nativeRoles = Role.getAvailableRoles(game.getPlayerByNationId("model.nation.inca"), braveType, military);
        RoleTest.assertTrue((boolean)expectedRoles.equals(nativeRoles));
    }

    public void testGetRoleWithAbility() {
        Role r = RoleTest.spec().getRoleWithAbility("model.ability.improveTerrain", null);
        RoleTest.assertNotNull((Object)r);
        RoleTest.assertEquals((String)"model.role.pioneer", (String)r.getId());
        r = RoleTest.spec().getRoleWithAbility("model.ability.speakWithChief", null);
        RoleTest.assertNotNull((Object)r);
        RoleTest.assertEquals((String)"model.role.scout", (String)r.getId());
        r = RoleTest.spec().getRoleWithAbility("model.ability.inciteNatives", null);
        RoleTest.assertNotNull((Object)r);
        RoleTest.assertEquals((String)"model.role.missionary", (String)r.getId());
        r = RoleTest.spec().getRoleWithAbility("model.ability.inciteNatives", null);
        RoleTest.assertNotNull((Object)r);
        RoleTest.assertEquals((String)"model.role.missionary", (String)r.getId());
    }
}

