/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;

public abstract class TradeItem
extends FreeColGameObject {
    public static final int INVALID_TRADE_ITEM = Integer.MIN_VALUE;
    private Player source;
    private Player destination;
    private static final String DESTINATION_TAG = "destination";
    private static final String SOURCE_TAG = "source";

    protected TradeItem(Game game, String id, Player source, Player destination) {
        super(game, id);
        this.source = source;
        this.destination = destination;
    }

    protected TradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, "");
        this.readFromXML(xr);
    }

    public final Player getSource() {
        return this.source;
    }

    public final void setSource(Player newSource) {
        this.source = newSource;
    }

    public final Player getDestination() {
        return this.destination;
    }

    public final void setDestination(Player newDestination) {
        this.destination = newDestination;
    }

    public final Player getOther(Player player) {
        return player == this.source ? this.destination : this.source;
    }

    public abstract boolean isValid();

    public abstract boolean isUnique();

    public abstract StringTemplate getLabel();

    public Colony getColony(Game game) {
        return null;
    }

    public Goods getGoods() {
        return null;
    }

    public void setGoods(Goods goods) {
    }

    public int getGold() {
        return 0;
    }

    public void setGold(int gold) {
    }

    public Player getVictim() {
        return null;
    }

    public Stance getStance() {
        return null;
    }

    public void setStance(Stance stance) {
    }

    public Unit getUnit() {
        return null;
    }

    public void setUnit(Unit unit) {
    }

    public abstract int evaluateFor(Player var1);

    @Override
    public boolean isInternable() {
        return false;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TradeItem o = this.copyInCast(other, TradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.source = game.updateRef(o.getSource());
        this.destination = game.updateRef(o.getDestination());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(SOURCE_TAG, this.source);
        xw.writeAttribute(DESTINATION_TAG, this.destination);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.source = xr.getAttribute(this.getGame(), SOURCE_TAG, Player.class, (Player)null);
        this.destination = xr.getAttribute(this.getGame(), DESTINATION_TAG, Player.class, (Player)null);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TradeItem)) {
            return false;
        }
        TradeItem other = (TradeItem)o;
        return Utils.equals(this.source, other.source) && Utils.equals(this.destination, other.destination) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.source);
        return 37 * hash + Utils.hashCode(this.destination);
    }
}

