/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.util.Iterator;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validating;

public class InvalidInputException
extends IllegalArgumentException
implements Iterable<Problem> {
    private final Problems problems;

    public InvalidInputException(Problems problems) {
        this.problems = problems;
    }

    public InvalidInputException(String msg, Problems problems) {
        super(msg);
        this.problems = problems;
    }

    public InvalidInputException(String message, Validating v) {
        this(message, v.getProblems());
    }

    public InvalidInputException(Validating v) {
        this("Invalid " + v.getClass().getSimpleName(), v.getProblems());
    }

    public static void throwIfNecessary(Validating v) throws InvalidInputException {
        InvalidInputException.throwIfNecessary(null, v);
    }

    public static void throwIfNecessary(String msg, Validating v) throws InvalidInputException {
        if (v != null && !v.isValid()) {
            Problems p = v.getProblems();
            if (p == null) {
                throw new IllegalStateException(v + " (" + v.getClass().getSimpleName() + ") reports itself invalid but returns null from getProblems(): " + v);
            }
            if (p.hasFatal()) {
                if (msg == null) {
                    throw new InvalidInputException(v);
                }
                throw new InvalidInputException(msg, v);
            }
        }
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        msg = msg != null ? msg + ": " + this.problems.toString() : this.problems.toString();
        return msg;
    }

    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.problems.iterator();
    }
}

