/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin.spreadsheet.wizard;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.ImporterSpreadsheetExcel;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.AbstractWizardVisualPanel1;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.ImportModeWrapper;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.WizardPanel1Excel;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.NbBundle;

public class WizardVisualPanel1Excel
extends AbstractWizardVisualPanel1 {
    private final ImporterSpreadsheetExcel importer;
    private final WizardPanel1Excel wizard1;
    private ValidationPanel validationPanel;
    private boolean initialized = false;
    private JLabel filePathLabel;
    private JComboBox modeComboBox;
    private JLabel modeLabel;
    private JTextField pathTextField;
    private JLabel previewLabel;
    private JTable previewTable;
    private JScrollPane scroll;
    private JLabel separatorLabel;
    private JComboBox sheetComboBox;

    public WizardVisualPanel1Excel(ImporterSpreadsheetExcel importer, WizardPanel1Excel wizard1) {
        super((AbstractImporterSpreadsheet)importer);
        this.initComponents();
        this.wizard1 = wizard1;
        this.importer = importer;
        for (SpreadsheetGeneralConfiguration.Mode mode : SpreadsheetGeneralConfiguration.Mode.values()) {
            this.modeComboBox.addItem(new ImportModeWrapper(mode));
        }
        for (String string : importer.getAvailableSheetNames()) {
            this.sheetComboBox.addItem(string);
        }
        this.modeComboBox.setSelectedItem(new ImportModeWrapper(importer.getMode()));
        String string = importer.getFile().getAbsolutePath();
        this.pathTextField.setText(string);
        this.pathTextField.setToolTipText(string);
        this.initialized = true;
        this.refreshPreviewTable();
    }

    public ValidationPanel getValidationPanel() {
        if (this.validationPanel != null) {
            return this.validationPanel;
        }
        this.validationPanel = new ValidationPanel();
        this.validationPanel.setInnerComponent((Component)this);
        ValidationGroup validationGroup = this.validationPanel.getValidationGroup();
        validationGroup.add((Object)this.pathTextField, (Validator)new Validator<String>(){

            public Class<String> modelType() {
                return String.class;
            }

            public void validate(Problems prblms, String string, String t) {
                if (!WizardVisualPanel1Excel.this.areValidColumnsForMode()) {
                    prblms.add(WizardVisualPanel1Excel.this.getMessage("WizardVisualPanel1CSV.validation.edges.no-source-target-columns"));
                }
                if (WizardVisualPanel1Excel.this.hasRowsMissingSourcesOrTargets()) {
                    prblms.add(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1CSV.validation.edges.empty-sources-or-targets"), Severity.WARNING);
                }
            }
        });
        this.validationPanel.setName(this.getName());
        return this.validationPanel;
    }

    @Override
    public final void refreshPreviewTable() {
        super.refreshPreviewTable();
        this.wizard1.fireChangeEvent();
        this.pathTextField.setText(this.pathTextField.getText());
    }

    @Override
    public String getName() {
        return this.getMessage("WizardVisualPanel1Excel.name");
    }

    @Override
    public SpreadsheetGeneralConfiguration.Mode getSelectedMode() {
        if (this.modeComboBox.getItemCount() == 0) {
            return SpreadsheetGeneralConfiguration.Mode.ADJACENCY_LIST;
        }
        return ((ImportModeWrapper)this.modeComboBox.getSelectedItem()).getMode();
    }

    public int getSelectedSheetIndex() {
        return this.sheetComboBox.getSelectedIndex();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean hasColumns() {
        return this.getColumnCount() > 0;
    }

    public boolean areValidColumnsForMode() {
        switch (this.getSelectedMode()) {
            case EDGES_TABLE: {
                return this.hasSourceNodeColumn && this.hasTargetNodeColumn;
            }
            case NODES_TABLE: {
                return this.getColumnCount() > 0;
            }
        }
        return true;
    }

    public boolean isValidData() {
        return this.areValidColumnsForMode();
    }

    public boolean hasRowsMissingSourcesOrTargets() {
        return this.hasRowsMissingSourcesOrTargets;
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)resName);
    }

    @Override
    protected JTable getPreviewTable() {
        return this.previewTable;
    }

    @Override
    protected JScrollPane getPreviewTableScrollPane() {
        return this.scroll;
    }

    private void initComponents() {
        this.filePathLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.separatorLabel = new JLabel();
        this.sheetComboBox = new JComboBox();
        this.modeLabel = new JLabel();
        this.modeComboBox = new JComboBox();
        this.previewLabel = new JLabel();
        this.scroll = new JScrollPane();
        this.previewTable = new JTable();
        this.filePathLabel.setText(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1Excel.filePathLabel.text"));
        this.pathTextField.setEditable(false);
        this.pathTextField.setText(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1Excel.pathTextField.text"));
        this.separatorLabel.setHorizontalAlignment(0);
        this.separatorLabel.setText(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1Excel.separatorLabel.text"));
        this.sheetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WizardVisualPanel1Excel.this.sheetComboBoxItemStateChanged(evt);
            }
        });
        this.modeLabel.setHorizontalAlignment(0);
        this.modeLabel.setText(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1Excel.modeLabel.text"));
        this.modeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WizardVisualPanel1Excel.this.modeComboBoxItemStateChanged(evt);
            }
        });
        this.previewLabel.setText(NbBundle.getMessage(WizardVisualPanel1Excel.class, (String)"WizardVisualPanel1Excel.previewLabel.text"));
        this.previewTable.setAutoResizeMode(0);
        this.scroll.setViewportView(this.previewTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scroll, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addComponent(this.filePathLabel, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addComponent(this.pathTextField, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.previewLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.sheetComboBox, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.modeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.modeComboBox, -2, 123, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.separatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sheetComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.modeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.modeComboBox, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 150, Short.MAX_VALUE).addContainerGap()));
    }

    private void sheetComboBoxItemStateChanged(ItemEvent evt) {
        if (this.initialized) {
            this.importer.setSheetIndex(this.getSelectedSheetIndex());
            this.refreshPreviewTable();
        }
    }

    private void modeComboBoxItemStateChanged(ItemEvent evt) {
        if (this.initialized) {
            this.importer.setMode(this.getSelectedMode());
            this.refreshPreviewTable();
        }
    }
}

