/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassProcessorFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.internal.Factory;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public abstract class JUnitTestFramework
implements TestFramework {
    private static final Logger LOGGER = Logging.getLogger(JUnitTestFramework.class);
    private JUnitDetector detector;
    private final DefaultTestFilter filter;
    private final Factory<File> testTaskTemporaryDir;
    private final Provider<Boolean> dryRun;

    @Inject
    public JUnitTestFramework(DefaultTestFilter filter, Factory<File> testTaskTemporaryDir, Provider<Boolean> dryRun) {
        this.filter = filter;
        this.testTaskTemporaryDir = testTaskTemporaryDir;
        this.detector = new JUnitDetector(new ClassFileExtractionManager(testTaskTemporaryDir));
        this.dryRun = dryRun;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitTestFramework newTestFramework = (JUnitTestFramework)this.getObjectFactory().newInstance(JUnitTestFramework.class, new Object[]{newTestFilters, this.testTaskTemporaryDir, this.dryRun});
        newTestFramework.getOptions().copyFrom(this.getOptions());
        return newTestFramework;
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.validateOptions();
        return new JUnitTestClassProcessorFactory(new JUnitSpec(this.filter.toSpec(), this.getOptions().getIncludeCategories(), this.getOptions().getExcludeCategories(), ((Boolean)this.dryRun.get()).booleanValue()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> {
            workerProcessBuilder.sharedPackages(new String[]{"junit.framework"});
            workerProcessBuilder.sharedPackages(new String[]{"junit.extensions"});
            workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
        };
    }

    @Override
    @Nested
    public abstract JUnitOptions getOptions();

    @Override
    public JUnitDetector getDetector() {
        return this.detector;
    }

    @Override
    public void close() throws IOException {
        this.detector = null;
    }

    private void validateOptions() {
        HashSet intersection = Sets.newHashSet(this.getOptions().getIncludeCategories());
        intersection.retainAll(this.getOptions().getExcludeCategories());
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                LOGGER.warn("The category '" + (String)intersection.iterator().next() + "' is both included and excluded.  This will result in the category being excluded, which may not be what was intended.  Please either include or exclude the category but not both.");
            } else {
                String allCategories = intersection.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
                LOGGER.warn("The categories " + allCategories + " are both included and excluded.  This will result in the categories being excluded, which may not be what was intended. Please either include or exclude the categories but not both.");
            }
        }
    }
}

