/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.browser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class FirefoxPreferencesFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File find() throws IOException {
        String profilesPath;
        String appdata;
        Map<String, String> env;
        String configPath = System.getProperty("user.home") + File.separator + ".mozilla" + File.separator + "firefox" + File.separator;
        if (JNLPRuntime.isWindows() && (env = System.getenv()) != null && (appdata = env.get("APPDATA")) != null) {
            configPath = appdata + File.separator + "Mozilla" + File.separator + "Firefox" + File.separator;
        }
        if (!new File(profilesPath = configPath + "profiles.ini").isFile()) {
            throw new FileNotFoundException(profilesPath);
        }
        OutputController.getLogger().log("Using firefox's profiles file: " + profilesPath);
        BufferedReader reader = new BufferedReader(new FileReader(profilesPath));
        ArrayList<String> linesInSection = new ArrayList<String>();
        boolean foundDefaultSection = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("[Profile") && line.endsWith("]")) {
                    if (foundDefaultSection) {
                        break;
                    }
                    linesInSection = new ArrayList();
                    continue;
                }
                linesInSection.add(line);
                int equalSignPos = line.indexOf(61);
                if (equalSignPos <= 0) continue;
                String key = line.substring(0, equalSignPos).trim();
                String value = line.substring(equalSignPos + 1).trim();
                if (!key.toLowerCase().equals("default") || !value.equals("1")) continue;
                foundDefaultSection = true;
            }
        }
        finally {
            reader.close();
        }
        if (!foundDefaultSection && linesInSection.size() == 0) {
            throw new FileNotFoundException("preferences file");
        }
        String path = null;
        for (String line : linesInSection) {
            if (!line.startsWith("Path=")) continue;
            path = line.substring("Path=".length());
        }
        if (path == null) {
            throw new FileNotFoundException("preferences file");
        }
        String fullPath = configPath + path + File.separator + "prefs.js";
        OutputController.getLogger().log("Found preferences file: " + fullPath);
        return new File(fullPath);
    }
}

