/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.CC;
import org.jsampler.event.SamplerAdapter;
import org.jsampler.event.SamplerEvent;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.jsampler.view.std.StdUtils;

public class ChannelsBar
extends JToolBar {
    private final JButton btnNew = new ToolbarButton(A4n.newChannel);
    private final JButton btnDuplicate;
    private final JButton btnUp;
    private final JButton btnDown;
    private final JButton btnRemove;
    private final JButton btnNewTab;
    private final JButton btnRemoveTab;
    private final JButton btnTabMoveLeft;
    private final JButton btnTabMoveRight;
    private final JLabel lVolume;
    private final JSlider slVolume;

    public ChannelsBar() {
        super(ClassicI18n.i18n.getLabel("ChanelsBar.name"));
        this.btnDuplicate = new ToolbarButton(A4n.a4n.duplicateChannels);
        this.btnUp = new ToolbarButton(A4n.a4n.moveChannelsUp);
        this.btnDown = new ToolbarButton(A4n.a4n.moveChannelsDown);
        this.btnRemove = new ToolbarButton(A4n.a4n.removeChannels);
        this.btnNewTab = new ToolbarButton(A4n.newChannelsTab);
        this.btnRemoveTab = new ToolbarButton(A4n.closeChannelsTab);
        this.btnTabMoveLeft = new ToolbarButton(A4n.moveTab2Left);
        this.btnTabMoveRight = new ToolbarButton(A4n.moveTab2Right);
        this.lVolume = new JLabel(Res.iconVolume22);
        this.slVolume = StdUtils.createVolumeSlider();
        this.setFloatable(false);
        this.add(this.lVolume);
        Dimension dimension = new Dimension(200, this.slVolume.getPreferredSize().height);
        this.slVolume.setPreferredSize(dimension);
        this.slVolume.setMaximumSize(dimension);
        this.slVolume.setOpaque(false);
        this.add(this.slVolume);
        this.addSeparator();
        this.add(this.btnNew);
        this.add(this.btnDuplicate);
        this.add(this.btnRemove);
        this.add(this.btnUp);
        this.add(this.btnDown);
        this.addSeparator();
        this.add(this.btnNewTab);
        this.add(this.btnRemoveTab);
        this.add(this.btnTabMoveLeft);
        this.add(this.btnTabMoveRight);
        int n = ClassicPrefs.preferences().getIntProperty("maximumMasterVolume");
        this.slVolume.setMaximum(n);
        String string = "maximumMasterVolume";
        ClassicPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = ClassicPrefs.preferences().getIntProperty("maximumMasterVolume");
                ChannelsBar.this.slVolume.setMaximum(n);
            }
        });
        this.slVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChannelsBar.this.setVolume();
            }
        });
        CC.getSamplerModel().addSamplerListener(new SamplerAdapter(){

            @Override
            public void volumeChanged(SamplerEvent samplerEvent) {
                ChannelsBar.this.updateVolume();
            }
        });
        this.updateVolume();
    }

    private void setVolume() {
        int n = this.slVolume.getValue();
        String string = ClassicI18n.i18n.getLabel("ChannelsBar.volume", n);
        if (this.slVolume.getValueIsAdjusting()) {
            return;
        }
        int n2 = (int)(CC.getSamplerModel().getVolume() * 100.0f);
        if (n2 == this.slVolume.getValue()) {
            return;
        }
        float f = this.slVolume.getValue();
        CC.getSamplerModel().setBackendVolume(f /= 100.0f);
    }

    private void updateVolume() {
        this.slVolume.setValue((int)(CC.getSamplerModel().getVolume() * 100.0f));
    }
}

