/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Subgraph;
import org.hibernate.Incubating;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.graph.Graph;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.internal.parse.GraphParsing;
import org.hibernate.graph.spi.GraphImplementor;

public final class GraphParser {
    public static <T> RootGraph<T> parse(Class<T> rootEntityClass, CharSequence graphText, SessionFactory sessionFactory) {
        if (graphText == null) {
            return null;
        }
        return GraphParsing.parse(rootEntityClass, graphText.toString(), (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class));
    }

    @Incubating
    public static <T> RootGraph<T> parse(String rootEntityName, CharSequence graphText, SessionFactory sessionFactory) {
        if (graphText == null) {
            return null;
        }
        return GraphParsing.parse(rootEntityName, graphText.toString(), (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class));
    }

    @Incubating
    public static <T> RootGraph<T> parse(CharSequence graphText, SessionFactory sessionFactory) {
        if (graphText == null) {
            return null;
        }
        return GraphParsing.parse(graphText.toString(), (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class));
    }

    public static <T> RootGraph<T> parse(Class<T> rootType, CharSequence graphText, EntityManager entityManager) {
        if (graphText == null) {
            return null;
        }
        return GraphParsing.parse(rootType, graphText.toString(), (SessionFactoryImplementor)entityManager.getEntityManagerFactory().unwrap(SessionFactoryImplementor.class));
    }

    public static <T> void parseInto(Graph<T> graph, CharSequence graphText, EntityManager entityManager) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, ((SessionImplementor)entityManager).getSessionFactory());
    }

    public static <T> void parseInto(EntityGraph<T> graph, CharSequence graphText, EntityManager entityManager) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, ((SessionImplementor)entityManager).getSessionFactory());
    }

    public static <T> void parseInto(Subgraph<T> graph, CharSequence graphText, EntityManager entityManager) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, ((SessionImplementor)entityManager).getSessionFactory());
    }

    public static <T> void parseInto(Graph<T> graph, CharSequence graphText, EntityManagerFactory entityManagerFactory) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, (SessionFactoryImplementor)entityManagerFactory);
    }

    public static <T> void parseInto(EntityGraph<T> graph, CharSequence graphText, EntityManagerFactory entityManagerFactory) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, (SessionFactoryImplementor)entityManagerFactory);
    }

    public static <T> void parseInto(Subgraph<T> graph, CharSequence graphText, EntityManagerFactory entityManagerFactory) {
        GraphParser.parseInto((GraphImplementor)graph, graphText, (SessionFactoryImplementor)entityManagerFactory);
    }

    private static <T> void parseInto(GraphImplementor<T> graph, CharSequence graphText, SessionFactoryImplementor sessionFactory) {
        if (graphText != null) {
            GraphParsing.parseInto(graph, graphText, sessionFactory);
        }
    }
}

