/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.predicate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class Junction
implements Predicate {
    private final Nature nature;
    private final JdbcMappingContainer expressionType;
    private final List<Predicate> predicates;

    public Junction() {
        this(Nature.CONJUNCTION);
    }

    public Junction(Nature nature) {
        this(nature, null);
    }

    public Junction(Nature nature, JdbcMappingContainer expressionType) {
        this.nature = nature;
        this.expressionType = expressionType;
        this.predicates = new ArrayList<Predicate>();
    }

    public Junction(Nature nature, List<Predicate> predicates, JdbcMappingContainer expressionType) {
        this.nature = nature;
        this.expressionType = expressionType;
        this.predicates = predicates;
    }

    public void add(Predicate predicate) {
        this.predicates.add(predicate);
    }

    public Nature getNature() {
        return this.nature;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public boolean isEmpty() {
        return this.predicates.isEmpty();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitJunction(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expressionType;
    }

    public static enum Nature {
        CONJUNCTION,
        DISJUNCTION;

    }
}

