/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlUtility {
    public static Element getElementByTagNameNS(Node element, String namespace, String name) {
        NodeList elements = element.getChildNodes();
        String colon = ":";
        if (elements != null) {
            for (int i = 0; i < elements.getLength(); ++i) {
                String nodeName;
                if (elements.item(i).getNodeType() != 1 || elements.item(i).getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil") != null && "true".equals(elements.item(i).getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil"))) continue;
                Element currentElement = (Element)elements.item(i);
                String nodeNameOnly = nodeName = currentElement.getNodeName();
                if (nodeName.contains(colon)) {
                    String[] nodeNameSplit = nodeName.split(":");
                    nodeNameOnly = nodeNameSplit[1];
                }
                if (currentElement.getNamespaceURI() != null && !currentElement.getNamespaceURI().equals(namespace) || !nodeNameOnly.equals(name)) continue;
                return currentElement;
            }
        }
        return null;
    }

    public static ArrayList<Element> getElementsByTagNameNS(Node element, String namespace, String name) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        NodeList elements = element.getChildNodes();
        if (elements != null) {
            for (int i = 0; i < elements.getLength(); ++i) {
                Element currentElement;
                if (elements.item(i).getNodeType() != 1 || (currentElement = (Element)elements.item(i)).getNamespaceURI() != null && !currentElement.getNamespaceURI().equals(namespace) || !currentElement.getNodeName().equals(name)) continue;
                childElements.add(currentElement);
            }
        }
        return childElements;
    }

    public static Element getElementByTagName(Node element, String name) {
        NodeList elements = element.getChildNodes();
        if (elements != null) {
            for (int i = 0; i < elements.getLength(); ++i) {
                Element currentElement;
                if (elements.item(i).getNodeType() != 1 || !(currentElement = (Element)elements.item(i)).getNodeName().equals(name)) continue;
                return currentElement;
            }
        }
        return null;
    }
}

