/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.support.QueryParsers;
import org.opensearch.index.search.QueryParserHelper;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.rollup.query.QueryStringQueryParserExt;
import org.opensearch.indexmanagement.rollup.util.QueryShardContextFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J4\u0010\f\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/rollup/query/QueryStringQueryUtil;", "", "<init>", "()V", "rewriteQueryStringQuery", "Lorg/opensearch/index/query/QueryStringQueryBuilder;", "queryBuilder", "Lorg/opensearch/index/query/QueryBuilder;", "concreteIndexName", "", "escapeSpaceCharacters", "field", "extractFieldsFromQueryString", "Lkotlin/Pair;", "", "", "", "resolveMatchPatternFields", "context", "Lorg/opensearch/index/query/QueryShardContext;", "pattern", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nQueryStringQueryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryStringQueryUtil.kt\norg/opensearch/indexmanagement/rollup/query/QueryStringQueryUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,231:1\n1869#2,2:232\n216#3,2:234\n*S KotlinDebug\n*F\n+ 1 QueryStringQueryUtil.kt\norg/opensearch/indexmanagement/rollup/query/QueryStringQueryUtil\n*L\n33#1:232,2\n51#1:234,2\n*E\n"})
public final class QueryStringQueryUtil {
    @NotNull
    public static final QueryStringQueryUtil INSTANCE = new QueryStringQueryUtil();

    private QueryStringQueryUtil() {
    }

    @NotNull
    public final QueryStringQueryBuilder rewriteQueryStringQuery(@NotNull QueryBuilder queryBuilder, @NotNull String concreteIndexName) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter((Object)concreteIndexName, (String)"concreteIndexName");
        QueryStringQueryBuilder qsqBuilder = (QueryStringQueryBuilder)queryBuilder;
        Pair<List<String>, Map<String, Float>> pair = this.extractFieldsFromQueryString(queryBuilder, concreteIndexName);
        List fieldsFromQueryString = (List)pair.component1();
        Map otherFields = (Map)pair.component2();
        String newQueryString = null;
        newQueryString = qsqBuilder.queryString();
        Iterable $this$forEach$iv = fieldsFromQueryString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String field = (String)element$iv;
            boolean bl = false;
            String escapedField = INSTANCE.escapeSpaceCharacters(field);
            String string = newQueryString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element");
            newQueryString = StringsKt.replace$default((String)string, (String)(escapedField + ":"), (String)(escapedField + "." + Dimension.Type.TERMS.getType() + ":"), (boolean)false, (int)4, null);
            newQueryString = StringsKt.replace$default((String)newQueryString, (String)("_exists_:" + escapedField), (String)("_exists_:" + escapedField + "." + Dimension.Type.TERMS.getType()), (boolean)false, (int)4, null);
        }
        Object newDefaultField = qsqBuilder.defaultField();
        newDefaultField = newDefaultField != null && !Regex.isSimpleMatchPattern((String)newDefaultField) ? (String)newDefaultField + "." + Dimension.Type.TERMS.getType() : null;
        Map newFields = null;
        if (!otherFields.isEmpty()) {
            newFields = new LinkedHashMap();
            Map $this$forEach$iv2 = otherFields;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                newFields.put(it.getKey() + "." + Dimension.Type.TERMS.getType(), it.getValue());
            }
        }
        QueryStringQueryBuilder retVal = ((QueryStringQueryBuilder)((QueryStringQueryBuilder)new QueryStringQueryBuilder(newQueryString).rewrite(qsqBuilder.rewrite()).fuzzyRewrite(qsqBuilder.fuzzyRewrite()).autoGenerateSynonymsPhraseQuery(qsqBuilder.autoGenerateSynonymsPhraseQuery()).allowLeadingWildcard(qsqBuilder.allowLeadingWildcard()).analyzeWildcard(qsqBuilder.analyzeWildcard()).defaultOperator(qsqBuilder.defaultOperator()).escape(qsqBuilder.escape()).fuzziness(qsqBuilder.fuzziness()).lenient(qsqBuilder.lenient()).enablePositionIncrements(qsqBuilder.enablePositionIncrements()).fuzzyMaxExpansions(qsqBuilder.fuzzyMaxExpansions()).fuzzyPrefixLength(qsqBuilder.fuzzyPrefixLength()).queryName(qsqBuilder.queryName())).quoteAnalyzer(qsqBuilder.quoteAnalyzer()).analyzer(qsqBuilder.analyzer()).minimumShouldMatch(qsqBuilder.minimumShouldMatch()).timeZone(qsqBuilder.timeZone()).phraseSlop(qsqBuilder.phraseSlop()).quoteFieldSuffix(qsqBuilder.quoteFieldSuffix()).boost(qsqBuilder.boost())).fuzzyTranspositions(qsqBuilder.fuzzyTranspositions());
        if (newDefaultField != null) {
            retVal = retVal.defaultField((String)newDefaultField);
        } else if (newFields != null && newFields.size() > 0) {
            retVal = retVal.fields(newFields);
        }
        if (qsqBuilder.tieBreaker() != null) {
            Float f = qsqBuilder.tieBreaker();
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"tieBreaker(...)");
            retVal = retVal.tieBreaker(((Number)f).floatValue());
        }
        QueryStringQueryBuilder queryStringQueryBuilder = retVal;
        Intrinsics.checkNotNull((Object)queryStringQueryBuilder);
        return queryStringQueryBuilder;
    }

    private final String escapeSpaceCharacters(String field) {
        String escapedField = StringsKt.replace$default((String)field, (String)" ", (String)"\\ ", (boolean)false, (int)4, null);
        return escapedField;
    }

    @NotNull
    public final Pair<List<String>, Map<String, Float>> extractFieldsFromQueryString(@NotNull QueryBuilder queryBuilder, @NotNull String concreteIndexName) {
        boolean bl;
        Boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter((Object)concreteIndexName, (String)"concreteIndexName");
        QueryShardContext context = QueryShardContextFactory.INSTANCE.createShardContext(concreteIndexName);
        QueryStringQueryBuilder qsqBuilder = (QueryStringQueryBuilder)queryBuilder;
        String rewrittenQueryString = qsqBuilder.escape() ? QueryParser.escape((String)qsqBuilder.queryString()) : qsqBuilder.queryString();
        QueryStringQueryParserExt queryParser = null;
        if (qsqBuilder.lenient() == null) {
            bl3 = context.queryStringLenient();
        } else {
            Boolean bl4 = qsqBuilder.lenient();
            Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"lenient(...)");
            bl3 = bl4;
        }
        boolean isLenient = bl3;
        Map otherFields = MapsKt.emptyMap();
        if (qsqBuilder.defaultField() != null) {
            if (Regex.isMatchAllPattern((String)qsqBuilder.defaultField())) {
                otherFields = QueryStringQueryUtil.resolveMatchPatternFields$default(this, context, null, 2, null);
                bl2 = qsqBuilder.lenient() == null ? Boolean.valueOf(true) : qsqBuilder.lenient();
                Intrinsics.checkNotNull((Object)bl2);
                queryParser = new QueryStringQueryParserExt(context, bl2);
            } else if (Regex.isSimpleMatchPattern((String)qsqBuilder.defaultField())) {
                String string = qsqBuilder.defaultField();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultField(...)");
                otherFields = this.resolveMatchPatternFields(context, string);
                String string2 = qsqBuilder.defaultField();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultField(...)");
                queryParser = new QueryStringQueryParserExt(context, string2, isLenient);
            } else {
                String string = qsqBuilder.defaultField();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultField(...)");
                queryParser = new QueryStringQueryParserExt(context, string, isLenient);
            }
        } else if (qsqBuilder.fields().size() > 0) {
            QueryStringQueryParserExt queryStringQueryParserExt;
            Map resolvedFields = QueryParserHelper.resolveMappingFields((QueryShardContext)context, (Map)qsqBuilder.fields());
            Intrinsics.checkNotNull((Object)resolvedFields);
            otherFields = resolvedFields;
            if (QueryParserHelper.hasAllFieldsWildcard((Collection)qsqBuilder.fields().keySet())) {
                var10_10 = qsqBuilder.lenient() == null ? Boolean.valueOf(true) : qsqBuilder.lenient();
                Intrinsics.checkNotNull((Object)var10_10);
                QueryStringQueryParserExt queryStringQueryParserExt2 = new QueryStringQueryParserExt(context, resolvedFields, (boolean)var10_10);
                queryStringQueryParserExt = queryStringQueryParserExt2;
            } else {
                queryStringQueryParserExt = new QueryStringQueryParserExt(context, resolvedFields, isLenient);
            }
            queryParser = queryStringQueryParserExt;
        } else {
            List list = context.defaultFields();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"defaultFields(...)");
            List defaultFields = list;
            if (QueryParserHelper.hasAllFieldsWildcard((Collection)defaultFields)) {
                otherFields = QueryStringQueryUtil.resolveMatchPatternFields$default(this, context, null, 2, null);
                var10_10 = qsqBuilder.lenient() == null ? Boolean.valueOf(true) : qsqBuilder.lenient();
                Intrinsics.checkNotNull((Object)var10_10);
                QueryStringQueryParserExt queryStringQueryParserExt = new QueryStringQueryParserExt(context, var10_10);
                v9 = queryStringQueryParserExt;
            } else {
                Map resolvedFields = QueryParserHelper.resolveMappingFields((QueryShardContext)context, (Map)QueryParserHelper.parseFieldsAndWeights((List)defaultFields));
                Intrinsics.checkNotNull((Object)resolvedFields);
                otherFields = resolvedFields;
                v9 = queryParser = new QueryStringQueryParserExt(context, resolvedFields, isLenient);
            }
        }
        if (qsqBuilder.analyzer() != null) {
            NamedAnalyzer namedAnalyzer = context.getIndexAnalyzers().get(qsqBuilder.analyzer());
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] analyzer [" + qsqBuilder + ".analyzer] not found", new Object[0]);
            }
            NamedAnalyzer namedAnalyzer2 = namedAnalyzer;
            queryParser.setForceAnalyzer((Analyzer)namedAnalyzer2);
        }
        if (qsqBuilder.quoteAnalyzer() != null) {
            NamedAnalyzer namedAnalyzer = context.getIndexAnalyzers().get(qsqBuilder.quoteAnalyzer());
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] quote_analyzer [" + qsqBuilder + ".quoteAnalyzer] not found", new Object[0]);
            }
            NamedAnalyzer forceQuoteAnalyzer = namedAnalyzer;
            queryParser.setForceQuoteAnalyzer((Analyzer)forceQuoteAnalyzer);
        }
        queryParser.setDefaultOperator(qsqBuilder.defaultOperator().toQueryParserOperator());
        queryParser.setType(QueryStringQueryBuilder.DEFAULT_TYPE);
        if (qsqBuilder.tieBreaker() != null) {
            Float f = qsqBuilder.tieBreaker();
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"tieBreaker(...)");
            queryParser.setGroupTieBreaker(((Number)f).floatValue());
        } else {
            queryParser.setGroupTieBreaker(QueryStringQueryBuilder.DEFAULT_TYPE.tieBreaker());
        }
        queryParser.setPhraseSlop(qsqBuilder.phraseSlop());
        queryParser.setQuoteFieldSuffix(qsqBuilder.quoteFieldSuffix());
        if (qsqBuilder.allowLeadingWildcard() == null) {
            bl = context.queryStringAllowLeadingWildcard();
        } else {
            bl2 = qsqBuilder.allowLeadingWildcard();
            Intrinsics.checkNotNull((Object)bl2);
            bl = bl2;
        }
        queryParser.setAllowLeadingWildcard(bl);
        bl2 = qsqBuilder.analyzeWildcard() == null ? Boolean.valueOf(context.queryStringAnalyzeWildcard()) : qsqBuilder.analyzeWildcard();
        Intrinsics.checkNotNull((Object)bl2);
        queryParser.setAnalyzeWildcard(bl2);
        queryParser.setEnablePositionIncrements(qsqBuilder.enablePositionIncrements());
        queryParser.setFuzziness(qsqBuilder.fuzziness());
        queryParser.setFuzzyPrefixLength(qsqBuilder.fuzzyPrefixLength());
        queryParser.setFuzzyMaxExpansions(qsqBuilder.fuzzyMaxExpansions());
        queryParser.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod((String)qsqBuilder.fuzzyRewrite(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE)));
        queryParser.setMultiTermRewriteMethod(QueryParsers.parseRewriteMethod((String)qsqBuilder.rewrite(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE)));
        queryParser.setTimeZone(qsqBuilder.timeZone());
        queryParser.setDeterminizeWorkLimit(qsqBuilder.maxDeterminizedStates());
        queryParser.setAutoGenerateMultiTermSynonymsPhraseQuery(qsqBuilder.autoGenerateSynonymsPhraseQuery());
        queryParser.setFuzzyTranspositions(qsqBuilder.fuzzyTranspositions());
        try {
            queryParser.parse(rewrittenQueryString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse query [" + qsqBuilder.queryString() + "]", e);
        }
        return TuplesKt.to(queryParser.getDiscoveredFields(), (Object)(queryParser.getHasLonelyTerms() ? otherFields : MapsKt.emptyMap()));
    }

    @NotNull
    public final Map<String, Float> resolveMatchPatternFields(@NotNull QueryShardContext context, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Set allFields = context.simpleMatchToIndexNames(pattern);
        Map fields = new HashMap();
        for (String fieldName : allFields) {
            String resolvedFieldName;
            MappedFieldType fieldType;
            if (context.getMapperService().fieldType(fieldName) == null) continue;
            String string = fieldType.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null)) continue;
            try {
                fieldType.termQuery((Object)"", context);
            }
            catch (QueryShardException e) {
                continue;
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (OpenSearchParseException openSearchParseException) {
                // empty catch block
            }
            if (!allFields.contains(resolvedFieldName = fieldType.name())) continue;
            fields.put(fieldName, Float.valueOf(1.0f));
        }
        return fields;
    }

    public static /* synthetic */ Map resolveMatchPatternFields$default(QueryStringQueryUtil queryStringQueryUtil, QueryShardContext queryShardContext, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "*";
        }
        return queryStringQueryUtil.resolveMatchPatternFields(queryShardContext, string);
    }
}

