/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.RemoveUnnecessaryCastQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyUnnecessaryCastInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyUnnecessaryCastInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return (PsiElementVisitor)new PyInspectionVisitor(holder, typeEvalContext){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitPyCallExpression(PyCallExpression callExpression) {
                PyType actualType;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                List list = callExpression.multiResolveCalleeFunction(this.getResolveContext());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"multiResolveCalleeFunction(...)");
                List callees = list;
                Iterable $this$any$iv = callees;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    block9: {
                        block8: {
                            if (!iterator.hasNext()) return;
                            T element$iv = iterator.next();
                            PyCallable it = (PyCallable)element$iv;
                            boolean bl2 = false;
                            PyFunction pyFunction = it instanceof PyFunction ? (PyFunction)it : null;
                            if (Intrinsics.areEqual((Object)(pyFunction != null ? pyFunction.getQualifiedName() : null), (Object)"typing.cast")) break block8;
                            PyFunction pyFunction2 = it instanceof PyFunction ? (PyFunction)it : null;
                            if (!Intrinsics.areEqual((Object)(pyFunction2 != null ? pyFunction2.getQualifiedName() : null), (Object)"typing_extensions.cast")) break block9;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                boolean bl3 = true;
                boolean isCastCall = bl3;
                if (!isCastCall) {
                    return;
                }
                PyExpression[] pyExpressionArray = callExpression.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                PyExpression[] args = pyExpressionArray;
                if (args.length != 2) {
                    return;
                }
                Ref<PyType> targetTypeRef = PyTypingTypeProvider.getType(args[0], this.myTypeEvalContext);
                PyType targetType = (PyType)Ref.deref(targetTypeRef);
                if (!PyTypeUtil.isSameType(targetType, actualType = this.myTypeEvalContext.getType((PyTypedElement)args[1]), this.myTypeEvalContext)) {
                    return;
                }
                String string = PythonDocumentationProvider.getTypeName(targetType, this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                String toName = string;
                PsiElement psiElement = (PsiElement)callExpression;
                Object[] objectArray = new Object[]{toName};
                String string2 = PyPsiBundle.message("INSP.unnecessary.cast.message", objectArray);
                PsiElement psiElement2 = callExpression.getArguments()[0].getNextSibling();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNextSibling(...)");
                objectArray = new LocalQuickFix[]{new RemoveUnnecessaryCastQuickFix()};
                this.registerProblem(psiElement, string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new TextRange(0, PsiTreeUtilKt.getEndOffset((PsiElement)psiElement2) - PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)callExpression))), (LocalQuickFix[])objectArray);
                objectArray = new Object[]{toName};
                String string3 = PyPsiBundle.message("INSP.unnecessary.cast.message", objectArray);
                objectArray = new LocalQuickFix[]{new RemoveUnnecessaryCastQuickFix()};
                this.registerProblem((PsiElement)callExpression, string3, ProblemHighlightType.INFORMATION, null, (LocalQuickFix[])objectArray);
            }
        };
    }
}

