
use builtin;
use str;

set edit:completion:arg-completer[typstyle] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'typstyle'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'typstyle'= {
            cand -l 'Maximum width of each line'
            cand -c 'Maximum width of each line'
            cand --line-width 'Maximum width of each line'
            cand --column 'Maximum width of each line'
            cand -t 'Number of spaces per indentation level'
            cand --indent-width 'Number of spaces per indentation level'
            cand --tab-width 'Number of spaces per indentation level'
            cand -i 'Format the file in place'
            cand --inplace 'Format the file in place'
            cand --check 'Run in ''check'' mode. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
            cand --diff 'Run in ''diff'' mode. Shows unified diff of what formatting changes would be made. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
            cand --no-reorder-import-items 'Disable alphabetical reordering of import items'
            cand --wrap-text 'Wrap text in markup to fit within the line width, and collapse spaces in markup'
            cand -a 'Print the AST of the input file'
            cand --ast 'Print the AST of the input file'
            cand -p 'Print the pretty document'
            cand --pretty-doc 'Print the pretty document'
            cand --timing 'Show elapsed time taken by the formatter'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand completions 'Generate shell completions for the given shell to stdout'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'typstyle;completions'= {
            cand -l 'Maximum width of each line'
            cand -c 'Maximum width of each line'
            cand --line-width 'Maximum width of each line'
            cand --column 'Maximum width of each line'
            cand -t 'Number of spaces per indentation level'
            cand --indent-width 'Number of spaces per indentation level'
            cand --tab-width 'Number of spaces per indentation level'
            cand --check 'Run in ''check'' mode. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
            cand --diff 'Run in ''diff'' mode. Shows unified diff of what formatting changes would be made. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
            cand --no-reorder-import-items 'Disable alphabetical reordering of import items'
            cand --wrap-text 'Wrap text in markup to fit within the line width, and collapse spaces in markup'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'typstyle;help'= {
            cand completions 'Generate shell completions for the given shell to stdout'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'typstyle;help;completions'= {
        }
        &'typstyle;help;help'= {
        }
    ]
    $completions[$command]
}
