/*****************************************************************************
 * notify.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2006, Gregory D Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * Phrozensmoke ['at'] yahoo.com
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "config.h"

#include "main.h"
#include "gyach.h"
#include "pmwindow.h"
#include "util.h"
#include "interface.h"
#include "notify.h"

#include "gyachi_lib.h"


void notify(char *mytitle, char *mymsg, const char *icon_stock_id, int timeout);
void (*gyachi_notify)(char *mytitle, char *mymsg, const char *icon_stock_id, int timeout) = notify;

void set_notify_callback(void (*notify_callback)(char *mytitle, char *mymsg, const char *icon_stock_id, int timeout))
{
	gyachi_notify = notify_callback;
}

void show_popup_dialog(char *mytitle, char *mymsg, const char *stock_id)  {

	gyachi_notify(mytitle, mymsg, stock_id, 7000);
}

int hide_popup_timeout(GtkWidget *mypopup) {
	if (mypopup) {gtk_widget_destroy(GTK_WIDGET(mypopup));}
	return 0;
}

void notify(char *mytitle, char *mymsg, const char *icon_stock_id, int millisecs)  {
	char phead[165];
	char pmsg[276];
	GtkWidget *dwindow;
	GtkWidget *dvbox;
	GtkWidget *dlbox;
	GtkWidget *dlabel;
	GtkWidget *dhead;
	GtkWidget *icon = NULL;

	if (capture_fp) {	
		fprintf(capture_fp,"\n[%s] POPUP-DIALOG MESSAGE: %s '%s'\n", gyach_timestamp(), mytitle, mymsg);
		fflush(capture_fp);
	}

	if (icon_stock_id) {
		icon=gtk_image_new_from_stock(icon_stock_id, GTK_ICON_SIZE_MENU);
	}


	if (dialogs_opening_too_fast()) {
		if (num_dialogs_too_fast<11) {
			char tmsgbuf[200]="";
			snprintf(tmsgbuf, 193, "** Info Message: %s", _(mymsg));
			strcat( tmsgbuf," **\n");
			append_to_textbox_color( chat_window, NULL, tmsgbuf);
		}
		return;
	}

	snprintf(phead, 150, "<span foreground=\"#0000AA\" size=\"larger\"><b>%s", mytitle);
	strcat(phead,"</b></span>");
	snprintf(pmsg, 264, "<span foreground=\"#000000\" size=\"smaller\">%s", mymsg);
	strcat(pmsg,"</span>");
	dwindow = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_window_set_title (GTK_WINDOW (dwindow), _("GYachE Improved: Message"));
	dvbox = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (dwindow), dvbox); 
	gtk_container_set_border_width (GTK_CONTAINER (dvbox), 6);  
	dlabel=gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(dlabel),pmsg); 
	gtk_label_set_line_wrap(GTK_LABEL(dlabel),1);
	dhead=gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(dhead),phead); 
	gtk_label_set_line_wrap(GTK_LABEL(dhead),1);
	gtk_label_set_justify (GTK_LABEL (dlabel), GTK_JUSTIFY_LEFT);
	dlbox = gtk_hbox_new (FALSE, 2); /* icon */
  	gtk_box_set_spacing (GTK_BOX (dlbox), 3);
  	gtk_box_set_spacing (GTK_BOX (dvbox), 6);
  	gtk_box_pack_start (GTK_BOX (dlbox), icon, FALSE, FALSE , 2);
  	gtk_box_pack_start (GTK_BOX (dlbox), dhead, TRUE, TRUE, 4);
  	gtk_box_pack_start (GTK_BOX (dvbox), dlbox, TRUE, TRUE, 2);  
  	gtk_box_pack_start (GTK_BOX (dvbox), dlabel, TRUE, TRUE, 1);

	gtk_window_move(GTK_WINDOW(dwindow), gdk_screen_width()-150, gdk_screen_height()-150);
	gtk_widget_show_all(dwindow);
	gtk_window_move(GTK_WINDOW(dwindow), gdk_screen_width()-dwindow->allocation.width-4, gdk_screen_height()-dwindow->allocation.height-74);
	g_timeout_add( millisecs, (void *)hide_popup_timeout, dwindow );
}


