/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef EBOOKHTMLTOKEN_H_INCLUDED
#define EBOOKHTMLTOKEN_H_INCLUDED

#include <boost/static_assert.hpp>

#include "EBOOKToken.h"

namespace libebook
{

namespace EBOOKHTMLToken
{

enum
{
  INVALID_TOKEN = 0,
  FIRST_TOKEN = EBOOKToken<EBOOKHTMLParser>::FIRST_TOKEN,

  // namespace prefixes
  xlink,
  xml,
  xmlns,

  // elements
  a,
  abbr,
  acronym,
  address,
  applet,
  area,
  article,
  aside,
  b,
  base,
  basefont,
  bdi,
  bdo,
  big,
  blink,
  blockquote,
  body,
  br,
  button,
  caption,
  center,
  cite,
  code,
  col,
  colgroup,
  datalist,
  dd,
  del,
  details,
  dfn,
  dialog,
  dir,
  div,
  dl,
  dt,
  em,
  embed,
  fieldset,
  figcaption,
  figure,
  font,
  footer,
  form,
  h1,
  h2,
  h3,
  h4,
  h5,
  h6,
  head,
  header,
  hgroup,
  hr,
  html,
  i,
  iframe,
  img,
  input,
  ins,
  isindex,
  kbd,
  keygen,
  label,
  legend,
  li,
  link,
  listing,
  main,
  map,
  mark,
  marquee,
  menu,
  meta,
  meter,
  nav,
  nobr,
  noembed,
  noframes,
  noscript,
  object,
  ol,
  optgroup,
  option,
  output,
  p,
  param,
  plaintext,
  pre,
  progress,
  q,
  rp,
  rt,
  ruby,
  s,
  samp,
  script,
  section,
  select,
  small,
  source,
  span,
  strike,
  strong,
  style,
  sub,
  sup,
  table,
  tbody,
  td,
  template_,
  textarea,
  tfoot,
  th,
  thead,
  title,
  tr,
  track,
  tt,
  u,
  ul,
  var,
  video,
  wbr,
  xmp,

  // attributes
  accept,
  accept_charset,
  accesskey,
  action,
  align,
  alink,
  alt,
  archive,
  axis,
  background,
  bgcolor,
  border,
  cellpadding,
  cellspacing,
  char_,
  charoff,
  charset,
  checked,
  class_,
  classid,
  clear,
  codebase,
  codetype,
  color,
  cols,
  colspan,
  compact,
  content,
  coords,
  data,
  datetime,
  declare,
  defer,
  disabled,
  enctype,
  face,
  for_,
  frame,
  frameborder,
  headers,
  height,
  href,
  hreflang,
  hspace,
  http_equiv,
  id,
  ismap,
  lang,
  language,
  longdesc,
  marginheight,
  marginwidth,
  maxlength,
  media,
  method,
  multiple,
  name,
  nohref,
  noshade,
  nowrap,
  onblur,
  onchange,
  onclick,
  ondblclick,
  onfocus,
  onkeydown,
  onkeypress,
  onkeyup,
  onload,
  onmousedown,
  onmousemove,
  onmouseout,
  onmouseover,
  onmouseup,
  onreset,
  onselect,
  onsubmit,
  onunload,
  profile,
  prompt,
  readonly,
  rel,
  rev,
  rows,
  rowspan,
  rules,
  scheme,
  scope,
  scrolling,
  selected,
  shape,
  size,
  space,
  src,
  standby,
  start,
  summary,
  tabindex,
  target,
  text,
  type,
  usemap,
  valign,
  value,
  valuetype,
  vlink,
  vspace,
  width,

  // attribute values
  above,
  all,
  aqua,
  auto_,
  baseline,
  below,
  black,
  blue,
  bottom,
  box,
  checkbox,
  circle,
  default_,
  disc,
  fuchsia,
  get,
  gray,
  green,
  groups,
  hsides,
  justify,
  left,
  lhs,
  lime,
  ltr,
  maroon,
  middle,
  navy,
  no,
  none,
  numbered,
  olive,
  password,
  poly,
  post,
  preserve,
  purple,
  rect,
  red,
  ref,
  reset,
  rhs,
  right,
  row,
  rowgroup,
  rtl,
  silver,
  square,
  submit,
  teal,
  top,
  void_,
  vsides,
  white,
  yellow,
  yes,

  LAST_TOKEN
};

BOOST_STATIC_ASSERT(EBOOKToken<EBOOKHTMLParser>::LAST_TOKEN >= LAST_TOKEN);

enum Namespace
{
  NS_html = html << 16,
  NS_xlink = xlink << 16,
  NS_xml = xml << 16,
  NS_xmlns = xmlns << 16
};

}

int getHTMLTokenId(const char *name, const char *ns = 0);
int getHTMLTokenId(const char *name, std::size_t nameLen, const char *ns, std::size_t nsLen);
int getHTMLTokenId(const char *name, std::size_t nameLen);

}

#endif // EBOOKHTMLTOKEN_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
