/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Component;
import java.awt.Container;
import org.dvb.ui.TestOpacity;
import org.havi.ui.HComponentOrdering;
import org.havi.ui.HMatte;
import org.havi.ui.HMatteException;
import org.havi.ui.HMatteLayer;

public class HContainer
extends Container
implements HMatteLayer,
HComponentOrdering,
TestOpacity {
    private HMatte hMatte = null;
    private boolean grouped = false;
    private static final long serialVersionUID = 263606166411114032L;

    public HContainer() {
        this(0, 0, 0, 0);
    }

    public HContainer(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setMatte(HMatte m) throws HMatteException {
        throw new HMatteException("Matte is not supported");
    }

    public HMatte getMatte() {
        return this.hMatte;
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public boolean isOpaque() {
        return false;
    }

    private int getOffset(Component c) throws ArrayIndexOutOfBoundsException {
        Component[] cs = this.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c) continue;
            return i;
        }
        throw new ArrayIndexOutOfBoundsException("Component not contained within");
    }

    private void checkLineage(Component c) {
        if (c.getParent() != this) {
            throw new ArrayIndexOutOfBoundsException("Component not contained within");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component addBefore(Component component, Component behind) {
        try {
            this.getOffset(behind);
        }
        catch (Exception e) {
            return null;
        }
        if (component == behind) {
            return component;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                this.remove(component);
                int offset = this.getOffset(behind);
                return this.add(component, offset);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component addAfter(Component component, Component front) {
        try {
            this.getOffset(front);
        }
        catch (Exception e) {
            return null;
        }
        if (component == front) {
            return component;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                this.remove(component);
                int offset = this.getOffset(front);
                return this.add(component, offset + 1);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popToFront(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                this.checkLineage(component);
                this.remove(component);
                this.add(component, 0);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushToBack(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                this.checkLineage(component);
                this.remove(component);
                this.add(component, -1);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pop(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int offset = this.getOffset(component);
                if (offset > 0) {
                    this.remove(component);
                    this.add(component, offset - 1);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int offset = this.getOffset(component);
                int count = this.getComponentCount();
                if (offset == count - 1) {
                    return true;
                }
                if (offset < count - 1) {
                    this.remove(component);
                    this.add(component, offset + 1);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popInFrontOf(Component move, Component behind) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (move != behind) {
                    this.checkLineage(move);
                    this.checkLineage(behind);
                    this.remove(move);
                    this.addBefore(move, behind);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushBehind(Component move, Component front) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (move != front) {
                    this.checkLineage(move);
                    this.checkLineage(front);
                    this.remove(move);
                    this.addAfter(move, front);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public void group() {
        this.grouped = true;
    }

    public void ungroup() {
        this.grouped = false;
    }

    public boolean isGrouped() {
        return this.grouped;
    }
}

