/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.selection;

import java.io.Serializable;
import java.security.Permission;
import javax.tv.locator.Locator;

public final class SelectPermission
extends Permission
implements Serializable {
    private String actions;
    private String locator;
    private static final long serialVersionUID = 3418810478648506665L;

    public SelectPermission(Locator locator, String actions) {
        super(locator.toExternalForm());
        if (!actions.equals("own") && !actions.equals("*")) {
            throw new IllegalArgumentException();
        }
        this.locator = locator.toExternalForm();
        this.actions = actions;
    }

    public SelectPermission(String locator, String actions) {
        super(locator);
        if (!actions.equals("own") && !actions.equals("*")) {
            throw new IllegalArgumentException();
        }
        this.locator = locator;
        this.actions = actions;
    }

    public boolean implies(Permission perm) {
        if (!(perm instanceof SelectPermission)) {
            return false;
        }
        if (!perm.getActions().equals(this.actions) && !this.actions.equals("*")) {
            return false;
        }
        SelectPermission sperm = (SelectPermission)perm;
        return sperm.locator.equals(this.locator) || this.locator.equals("*");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectPermission other = (SelectPermission)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        return !(this.locator == null ? other.locator != null : !this.locator.equals(other.locator));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
        return result;
    }

    public String getActions() {
        return this.actions;
    }
}

