/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.PlaytreeEditEvent;
import vlcskineditor.items.Slider;

public class Playtree
extends Item
implements ActionListener {
    public final int WIDTH_DEFAULT = 0;
    public final int HEIGHT_DEFAULT = 0;
    public final String VAR_DEFAULT = "playlist";
    public final String BGIMAGE_DEFAULT = "none";
    public final String FGCOLOR_DEFAULT = "#000000";
    public final String PLAYCOLOR_DEFAULT = "#FF0000";
    public final String SELCOLOR_DEFAULT = "#0000FF";
    public final String BGCOLOR1_DEFAULT = "#FFFFFF";
    public final String BGCOLOR2_DEFAULT = "#FFFFFF";
    public final boolean FLAT_DEFAULT = false;
    public final String ITEMIMAGE_DEFAULT = "none";
    public final String OPENIMAGE_DEFAULT = "none";
    public final String CLOSEDIMAGE_DEFAULT = "none";
    public int width = 0;
    public int height = 0;
    public String font;
    public String var = "playlist";
    public String bgimage = "none";
    public String fgcolor = "#000000";
    public String playcolor = "#FF0000";
    public String selcolor = "#0000FF";
    public String bgcolor1 = "#FFFFFF";
    public String bgcolor2 = "#FFFFFF";
    public boolean flat = false;
    public String itemimage = "none";
    public String openimage = "none";
    public String closedimage = "none";
    Slider slider = null;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField width_tf;
    JTextField height_tf;
    JTextField font_tf;
    JTextField bgimage_tf;
    JTextField itemimage_tf;
    JTextField openimage_tf;
    JTextField closedimage_tf;
    JTextField fgcolor_tf;
    JTextField playcolor_tf;
    JTextField selcolor_tf;
    JTextField bgcolor1_tf;
    JTextField bgcolor2_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox flat_cb;
    JButton visible_btn;
    JButton bgcolor1_btn;
    JButton bgcolor2_btn;
    JButton fgcolor_btn;
    JButton playcolor_btn;
    JButton selcolor_btn;
    JButton slider_btn;
    JButton ok_btn;
    JButton help_btn;
    JButton cancel_btn;

    public Playtree(String string, Skin skin) {
        this.type = "Playtree";
        this.s = skin;
        String[] stringArray = string.split("\n");
        if (stringArray[0].startsWith("<Playlist")) {
            this.flat = true;
        }
        this.font = XML.getValue(stringArray[0], "font");
        if (stringArray[0].indexOf("width=\"") != -1) {
            this.width = XML.getIntValue(stringArray[0], "width");
        }
        if (stringArray[0].indexOf("height=\"") != -1) {
            this.height = XML.getIntValue(stringArray[0], "height");
        }
        if (stringArray[0].indexOf("var=\"") != -1) {
            this.var = XML.getValue(stringArray[0], "var");
        }
        if (stringArray[0].indexOf("bgimage=\"") != -1) {
            this.bgimage = XML.getValue(stringArray[0], "bgimage");
        }
        if (stringArray[0].indexOf("openimage=\"") != -1) {
            this.openimage = XML.getValue(stringArray[0], "openimage");
        }
        if (stringArray[0].indexOf("closedimage=\"") != -1) {
            this.closedimage = XML.getValue(stringArray[0], "closedimage");
        }
        if (stringArray[0].indexOf("itemimage=\"") != -1) {
            this.itemimage = XML.getValue(stringArray[0], "itemimage");
        }
        if (stringArray[0].indexOf("fgcolor=\"") != -1) {
            this.fgcolor = XML.getValue(stringArray[0], "fgcolor");
        }
        if (stringArray[0].indexOf("playcolor=\"") != -1) {
            this.playcolor = XML.getValue(stringArray[0], "playcolor");
        }
        if (stringArray[0].indexOf("selcolor=\"") != -1) {
            this.selcolor = XML.getValue(stringArray[0], "selcolor");
        }
        if (stringArray[0].indexOf("bgcolor1=\"") != -1) {
            this.bgcolor1 = XML.getValue(stringArray[0], "bgcolor1");
        }
        if (stringArray[0].indexOf("bgcolor2=\"") != -1) {
            this.bgcolor2 = XML.getValue(stringArray[0], "bgcolor2");
        }
        if (stringArray[0].indexOf("flat=\"") != -1) {
            this.flat = XML.getBoolValue(stringArray[0], "flat");
        }
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed playtree #" + this.s.getNewId();
        if (stringArray[0].indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf("ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        int n = 1;
        if (stringArray.length > 1) {
            if (stringArray[n].trim().startsWith("<!--")) {
                while (stringArray[n].trim().indexOf("-->") == -1) {
                    ++n;
                }
            } else if (stringArray[n].trim().startsWith("<Slider")) {
                if (stringArray[n].trim().indexOf("/>") != -1) {
                    this.slider = new Slider(stringArray[n].trim(), this.s, true);
                } else {
                    String string2 = stringArray[n].trim();
                    ++n;
                    while (!stringArray[n].trim().startsWith("</Slider>")) {
                        string2 = string2 + "\n" + stringArray[n];
                        ++n;
                    }
                    string2 = string2 + "\n" + stringArray[n].trim();
                    this.slider = new Slider(string2, this.s, true);
                }
            }
        }
        this.created = true;
    }

    public Playtree(Skin skin) {
        this.type = "Playtree";
        this.s = skin;
        this.font = "defaultfont";
        this.id = "Unnamed playtree #" + this.s.getNewId();
        this.slider = new Slider(this.s, true);
        this.showOptions();
        this.s.updateItems();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.font = this.font_tf.getText();
            this.bgimage = this.bgimage_tf.getText();
            this.itemimage = this.itemimage_tf.getText();
            this.openimage = this.openimage_tf.getText();
            this.closedimage = this.closedimage_tf.getText();
            this.fgcolor = this.fgcolor_tf.getText();
            this.selcolor = this.selcolor_tf.getText();
            this.playcolor = this.playcolor_tf.getText();
            this.bgcolor1 = this.bgcolor1_tf.getText();
            this.bgcolor2 = this.bgcolor2_tf.getText();
            this.flat = (Boolean)this.flat_cb.getSelectedItem();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            PlaytreeEditEvent playtreeEditEvent = new PlaytreeEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.font = this.font_tf.getText();
            this.bgimage = this.bgimage_tf.getText();
            this.itemimage = this.itemimage_tf.getText();
            this.openimage = this.openimage_tf.getText();
            this.closedimage = this.closedimage_tf.getText();
            this.fgcolor = this.fgcolor_tf.getText();
            this.selcolor = this.selcolor_tf.getText();
            this.playcolor = this.playcolor_tf.getText();
            this.bgcolor1 = this.bgcolor1_tf.getText();
            this.bgcolor2 = this.bgcolor2_tf.getText();
            this.flat = (Boolean)this.flat_cb.getSelectedItem();
            this.s.updateItems();
            this.s.expandItem(this.id);
            playtreeEditEvent.setNew();
            this.s.m.hist.addEvent(playtreeEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Playtree settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", this.s.m.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Width:");
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument(false));
            this.width_tf.setToolTipText("Width of the playlist, in pixels. If playlist items are wider, the end of the name will be replaced with '...'");
            JLabel jLabel11 = new JLabel("Height:");
            this.height_tf = new JTextField();
            this.height_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel12 = new JLabel("Font*:");
            this.font_tf = new JTextField();
            JLabel jLabel13 = new JLabel("BG Image:");
            this.bgimage_tf = new JTextField();
            this.bgimage_tf.setToolTipText("ID of a Bitmap, used as the background image. When no bitmap is specified, the background will be filled using the bgcolor1 and bgcolor2 attributes.");
            JLabel jLabel14 = new JLabel("BG color #1:");
            this.bgcolor1_tf = new JTextField();
            this.bgcolor1_tf.setToolTipText("Background color for odd playlist items. This attribute is ignored if the bgimage one is used.");
            this.bgcolor1_btn = new JButton("Choose...");
            this.bgcolor1_btn.addActionListener(this);
            JLabel jLabel15 = new JLabel("BG color #2:");
            this.bgcolor2_tf = new JTextField();
            this.bgcolor2_tf.setToolTipText("Background color for even playlist items. This attribute is ignored if the bgimage one is used.");
            this.bgcolor2_btn = new JButton("Choose...");
            this.bgcolor2_btn.addActionListener(this);
            JLabel jLabel16 = new JLabel("Selection color:");
            this.selcolor_tf = new JTextField();
            this.selcolor_btn = new JButton("Choose...");
            this.selcolor_btn.addActionListener(this);
            JLabel jLabel17 = new JLabel("Text color:");
            this.fgcolor_tf = new JTextField();
            this.fgcolor_btn = new JButton("Choose...");
            this.fgcolor_btn.addActionListener(this);
            JLabel jLabel18 = new JLabel("Now playing text color:");
            this.playcolor_tf = new JTextField();
            this.playcolor_btn = new JButton("Choose...");
            this.playcolor_btn.addActionListener(this);
            JLabel jLabel19 = new JLabel("Flat playlist:");
            this.flat_cb = new JComboBox<Object>(objectArray);
            this.flat_cb.setToolTipText("Boolean to indicate whether the playlist should use the tree structure or be completely \"flat\" (only show the leafs of the tree).");
            JLabel jLabel20 = new JLabel("Item icon:");
            this.itemimage_tf = new JTextField();
            JLabel jLabel21 = new JLabel("Open folder icon:");
            this.openimage_tf = new JTextField();
            JLabel jLabel22 = new JLabel("Closed folder icon:");
            this.closedimage_tf = new JTextField();
            this.slider_btn = new JButton("Edit Playlist's slider (scrollbar)");
            this.slider_btn.addActionListener(this);
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 105, 75, 24);
            this.lefttop_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(5, 135, 75, 24);
            this.rightbottom_cb.setBounds(85, 135, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 165, 75, 24);
            this.xkeepratio_cb.setBounds(85, 165, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(5, 195, 75, 24);
            this.ykeepratio_cb.setBounds(85, 195, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jLabel8.setBounds(5, 225, 75, 24);
            this.visible_tf.setBounds(85, 225, 120, 24);
            this.visible_btn.setBounds(210, 225, 24, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(5, 255, 75, 24);
            this.help_tf.setBounds(85, 255, 150, 24);
            jPanel.add(jLabel10);
            jPanel.add(this.width_tf);
            jLabel10.setBounds(5, 285, 75, 24);
            this.width_tf.setBounds(85, 285, 150, 24);
            jPanel.add(jLabel11);
            jPanel.add(this.height_tf);
            jLabel11.setBounds(5, 315, 75, 24);
            this.height_tf.setBounds(85, 315, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 345));
            jPanel.setPreferredSize(new Dimension(240, 345));
            jPanel.setMaximumSize(new Dimension(240, 345));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel12);
            jPanel2.add(this.font_tf);
            jLabel12.setBounds(5, 15, 75, 24);
            this.font_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel13);
            jPanel2.add(this.bgimage_tf);
            jLabel13.setBounds(5, 45, 75, 24);
            this.bgimage_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel14);
            jPanel2.add(this.bgcolor1_tf);
            jPanel2.add(this.bgcolor1_btn);
            jLabel14.setBounds(5, 75, 75, 24);
            this.bgcolor1_tf.setBounds(85, 75, 75, 24);
            this.bgcolor1_btn.setBounds(165, 75, 70, 24);
            jPanel2.add(jLabel15);
            jPanel2.add(this.bgcolor2_tf);
            jPanel2.add(this.bgcolor2_btn);
            jLabel15.setBounds(5, 105, 75, 24);
            this.bgcolor2_tf.setBounds(85, 105, 75, 24);
            this.bgcolor2_btn.setBounds(165, 105, 70, 24);
            jPanel2.add(jLabel16);
            jPanel2.add(this.selcolor_tf);
            jPanel2.add(this.selcolor_btn);
            jLabel16.setBounds(5, 135, 75, 24);
            this.selcolor_tf.setBounds(85, 135, 75, 24);
            this.selcolor_btn.setBounds(165, 135, 70, 24);
            jPanel2.add(jLabel17);
            jPanel2.add(this.fgcolor_tf);
            jPanel2.add(this.fgcolor_btn);
            jLabel17.setBounds(5, 165, 75, 24);
            this.fgcolor_tf.setBounds(85, 165, 75, 24);
            this.fgcolor_btn.setBounds(165, 165, 70, 24);
            jPanel2.add(jLabel18);
            jPanel2.add(this.playcolor_tf);
            jPanel2.add(this.playcolor_btn);
            jLabel18.setBounds(5, 195, 75, 24);
            this.playcolor_tf.setBounds(85, 195, 75, 24);
            this.playcolor_btn.setBounds(165, 195, 70, 24);
            jPanel2.add(jLabel19);
            jPanel2.add(this.flat_cb);
            jLabel19.setBounds(5, 225, 75, 24);
            this.flat_cb.setBounds(85, 225, 150, 24);
            jPanel2.add(jLabel20);
            jPanel2.add(this.itemimage_tf);
            jLabel20.setBounds(5, 255, 75, 24);
            this.itemimage_tf.setBounds(85, 255, 150, 24);
            jPanel2.add(jLabel21);
            jPanel2.add(this.openimage_tf);
            jLabel21.setBounds(5, 285, 75, 24);
            this.openimage_tf.setBounds(85, 285, 150, 24);
            jPanel2.add(jLabel22);
            jPanel2.add(this.closedimage_tf);
            jLabel22.setBounds(5, 315, 75, 24);
            this.closedimage_tf.setBounds(85, 315, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Playtree Attributes"));
            jPanel2.setMinimumSize(new Dimension(240, 3455));
            jPanel2.setPreferredSize(new Dimension(240, 345));
            jPanel2.setMaximumSize(new Dimension(240, 345));
            this.frame.add(jPanel2);
            this.frame.add(this.slider_btn);
            this.slider_btn.setPreferredSize(new Dimension(490, 24));
            this.slider_btn.setMinimumSize(new Dimension(490, 24));
            this.slider_btn.setMaximumSize(new Dimension(490, 24));
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(500, 470));
            this.frame.setPreferredSize(new Dimension(500, 470));
            this.frame.setMaximumSize(new Dimension(500, 470));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.font_tf.setText(this.font);
        this.bgimage_tf.setText(this.bgimage);
        this.fgcolor_tf.setText(this.fgcolor);
        this.selcolor_tf.setText(this.selcolor);
        this.playcolor_tf.setText(this.playcolor);
        this.bgcolor1_tf.setText(this.bgcolor1);
        this.bgcolor2_tf.setText(this.bgcolor2);
        this.flat_cb.setSelectedItem(this.flat);
        this.openimage_tf.setText(this.openimage);
        this.closedimage_tf.setText(this.closedimage);
        this.itemimage_tf.setText(this.itemimage);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (!this.bgimage_tf.getText().equals("none") && this.s.getResource(this.bgimage_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "Please choose an existing background image!", "Bgimage does not exist", 1);
                return;
            }
            if (!this.itemimage_tf.getText().equals("none") && this.s.getResource(this.itemimage_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "Please choose an existing item icon!", "Itemimage does not exist", 1);
                return;
            }
            if (!this.openimage_tf.getText().equals("none") && this.s.getResource(this.openimage_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "Please choose an existing open folder icon!", "Openimage does not exist", 1);
                return;
            }
            if (!this.closedimage_tf.getText().equals("none") && this.s.getResource(this.closedimage_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "Please choose an existing closed folder icon!", "Closedimage does not exist", 1);
                return;
            }
            if (!this.font_tf.getText().equals("defaultfont") && this.s.getResource(this.font_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "Please choose an existing font!", "Font does not exist", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.bgcolor1_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose Color", Color.decode(this.bgcolor1_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.bgcolor1_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.bgcolor2_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose Color", Color.decode(this.bgcolor2_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.bgcolor2_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.fgcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose Color", Color.decode(this.fgcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.fgcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.selcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose Color", Color.decode(this.selcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.selcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.playcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose Color", Color.decode(this.playcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.playcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.slider_btn)) {
            this.slider.showOptions();
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-playtree.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-playtree.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/boolexpr.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/boolexpr.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Playtree";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        string2 = string2 + " font=\"" + this.font + "\"";
        if (!this.bgcolor1.equals("#FFFFFF")) {
            string2 = string2 + " bgcolor1=\"" + this.bgcolor1 + "\"";
        }
        if (!this.bgcolor2.equals("#FFFFFF")) {
            string2 = string2 + " bgcolor2=\"" + this.bgcolor2 + "\"";
        }
        if (!this.fgcolor.equals("#000000")) {
            string2 = string2 + " fgcolor=\"" + this.fgcolor + "\"";
        }
        if (!this.selcolor.equals("#0000FF")) {
            string2 = string2 + " selcolor=\"" + this.selcolor + "\"";
        }
        if (!this.playcolor.equals("#FF0000")) {
            string2 = string2 + " playcolor=\"" + this.playcolor + "\"";
        }
        if (!this.bgimage.equals("none")) {
            string2 = string2 + " bgimage=\"" + this.bgimage + "\"";
        }
        if (!this.itemimage.equals("none")) {
            string2 = string2 + " itemimage=\"" + this.itemimage + "\"";
        }
        if (!this.openimage.equals("none")) {
            string2 = string2 + " openimage=\"" + this.openimage + "\"";
        }
        if (!this.closedimage.equals("none")) {
            string2 = string2 + " closedimage=\"" + this.closedimage + "\"";
        }
        if (!this.var.equals("playlist")) {
            string2 = string2 + " var=\"" + this.var + "\"";
        }
        if (this.flat) {
            string2 = string2 + " flat=\"" + String.valueOf(this.flat) + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (this.width != 0) {
            string2 = string2 + " width=\"" + String.valueOf(this.width) + "\"";
        }
        if (this.height != 0) {
            string2 = string2 + " height=\"" + String.valueOf(this.height) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + ">\n";
        string2 = string2 + this.slider.returnCode(string + Skin.indentation);
        string2 = string2 + "\n" + string + "</Playtree>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.created) {
            return;
        }
        if (this.s.gvars.parseBoolean(this.visible)) {
            int n4;
            Font font = this.s.getFont(this.font);
            graphics2D2.setFont(font);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            if (!this.bgimage.equals("none")) {
                graphics2D2.drawImage((Image)this.s.getBitmapImage(this.bgimage).getSubimage(0, 0, this.width, this.height), 0, 0, null);
            } else {
                graphics2D2.setColor(Color.decode(this.bgcolor1));
                graphics2D2.fillRect(0, 0, this.width, this.height);
                for (n4 = fontMetrics.getHeight(); n4 < this.height; n4 += fontMetrics.getHeight() * 2) {
                    graphics2D2.setColor(Color.decode(this.bgcolor2));
                    graphics2D2.fillRect(this.x, 0 + n4, this.width, fontMetrics.getHeight());
                }
            }
            n4 = 0;
            BufferedImage bufferedImage2 = this.s.getBitmapImage(this.closedimage);
            BufferedImage bufferedImage3 = this.s.getBitmapImage(this.openimage);
            BufferedImage bufferedImage4 = this.s.getBitmapImage(this.itemimage);
            int n5 = fontMetrics.getHeight();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (bufferedImage2 != null) {
                if (bufferedImage2.getHeight() > n5) {
                    n5 = bufferedImage2.getHeight();
                }
                n6 = (n5 - bufferedImage2.getHeight()) / 2;
            }
            if (bufferedImage3 != null) {
                if (bufferedImage3.getHeight() > n5) {
                    n5 = bufferedImage3.getHeight();
                }
                n7 = (n5 - bufferedImage3.getHeight()) / 2;
            }
            if (bufferedImage4 != null) {
                if (bufferedImage4.getHeight() > n5) {
                    n5 = bufferedImage4.getHeight();
                }
                n8 = (n5 - bufferedImage4.getHeight()) / 2;
            }
            int n9 = (n5 - fontMetrics.getAscent()) / 2;
            graphics2D2.setColor(Color.decode(this.fgcolor));
            if (bufferedImage2 != null && !this.flat) {
                graphics2D2.drawImage((Image)bufferedImage2, 0, n4 + n6, null);
                graphics2D2.drawString("Closed folder", 0 + bufferedImage2.getWidth() + 2, (n4 += n5) - n9);
            }
            if (bufferedImage3 != null && !this.flat) {
                graphics2D2.drawImage((Image)bufferedImage3, 0, n4 + n7, null);
                graphics2D2.drawString("Open folder", 0 + bufferedImage3.getWidth() + 2, (n4 += n5) - n9);
            }
            if (bufferedImage3 != null && bufferedImage4 != null && !this.flat) {
                graphics2D2.drawImage((Image)bufferedImage4, 0 + bufferedImage3.getWidth() + 2, n4 + n8, null);
                graphics2D2.drawString("Normal item", 0 + bufferedImage3.getWidth() + bufferedImage4.getWidth() + 4, (n4 += n5) - n9);
            } else if (bufferedImage4 != null) {
                graphics2D2.drawImage((Image)bufferedImage4, 0, n4 + n8, null);
                graphics2D2.drawString("Normal item", 0 + bufferedImage4.getWidth() + 4, (n4 += fontMetrics.getHeight()) - n9);
            } else {
                graphics2D2.drawString("Normal item", 0, (n4 += fontMetrics.getHeight()) - n9);
            }
            graphics2D2.setColor(Color.decode(this.playcolor));
            if (bufferedImage3 != null && bufferedImage4 != null && !this.flat) {
                graphics2D2.drawImage((Image)bufferedImage4, 0 + bufferedImage3.getWidth() + 2, n4 + n8, null);
                graphics2D2.drawString("Playing item", 0 + bufferedImage3.getWidth() + bufferedImage4.getWidth() + 4, (n4 += n5) - n9);
            } else if (bufferedImage4 != null) {
                graphics2D2.drawImage((Image)bufferedImage4, 0, n4 + n8, null);
                graphics2D2.drawString("Playing item", 0 + bufferedImage4.getWidth() + 2, (n4 += n5) - n9);
            } else {
                graphics2D2.drawString("Playing item", 0, (n4 += n5) - n9);
            }
            graphics2D2.setColor(Color.decode(this.selcolor));
            graphics2D2.fillRect(0, n4, this.width, n5);
            graphics2D2.setColor(Color.decode(this.fgcolor));
            if (bufferedImage3 != null && bufferedImage4 != null && !this.flat) {
                graphics2D2.drawImage((Image)bufferedImage4, 0 + bufferedImage3.getWidth() + 2, n4 + n8, null);
                graphics2D2.drawString("Selected item", 0 + bufferedImage3.getWidth() + bufferedImage4.getWidth() + 4, (n4 += n5) - n9);
            } else if (bufferedImage4 != null) {
                graphics2D2.drawImage((Image)bufferedImage4, 0, n4 + n8, null);
                graphics2D2.drawString("Selected item", 0 + bufferedImage4.getWidth() + 2, (n4 += n5) - n9);
            } else {
                graphics2D2.drawString("Selected item", 0, (n4 += n5) - n9);
            }
            graphics2D.drawImage(bufferedImage, (this.x + n) * n3, (this.y + n2) * n3, this.width * n3, this.height * n3, null);
            this.slider.draw(graphics2D, 1);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3 - 1, this.height * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.height + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Playtree: " + this.id);
        defaultMutableTreeNode.add(this.slider.getTreeNode());
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        return this.slider.getItem(string);
    }

    @Override
    public Item getParentOf(String string) {
        if (this.slider != null) {
            if (this.slider.id.equals(string)) {
                return this;
            }
            return this.slider.getParentOf(string);
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        return this.slider != null && this.slider.uses(string) || this.bgimage.equals(string) || this.openimage.equals(string) || this.closedimage.equals(string) || this.itemimage.equals(string) || this.font.equals(string);
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        this.slider.renameForCopy(string2);
    }
}

