/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.media.session.MediaSessionCompatApi21;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;

public class MediaSessionCompat {
    private final MediaSessionImpl mImpl;
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;

    public MediaSessionCompat(Context context, String tag) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new IllegalArgumentException("tag must not be null or empty");
        }
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaSessionImplApi21(context, tag) : new MediaSessionImplBase();
    }

    private MediaSessionCompat(MediaSessionImpl impl) {
        this.mImpl = impl;
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    public void setCallback(Callback callback, Handler handler) {
        this.mImpl.setCallback(callback, handler != null ? handler : new Handler());
    }

    public void setFlags(int flags) {
        this.mImpl.setFlags(flags);
    }

    public void setPlaybackToLocal(int stream) {
        this.mImpl.setPlaybackToLocal(stream);
    }

    public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        this.mImpl.setPlaybackToRemote(volumeProvider);
    }

    public void setActive(boolean active) {
        this.mImpl.setActive(active);
    }

    public boolean isActive() {
        return this.mImpl.isActive();
    }

    public void sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        this.mImpl.sendSessionEvent(event, extras);
    }

    public void release() {
        this.mImpl.release();
    }

    public Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public void setPlaybackState(PlaybackStateCompat state) {
        this.mImpl.setPlaybackState(state);
    }

    public void setMetadata(MediaMetadataCompat metadata) {
        this.mImpl.setMetadata(metadata);
    }

    public Object getMediaSession() {
        return this.mImpl.getMediaSession();
    }

    public static MediaSessionCompat obtain(Object mediaSession) {
        return new MediaSessionCompat(new MediaSessionImplApi21(mediaSession));
    }

    static class MediaSessionImplApi21
    implements MediaSessionImpl {
        private final Object mSessionObj;
        private final Token mToken;

        public MediaSessionImplApi21(Context context, String tag) {
            this.mSessionObj = MediaSessionCompatApi21.createSession(context, tag);
            this.mToken = new Token(MediaSessionCompatApi21.getSessionToken(this.mSessionObj));
        }

        public MediaSessionImplApi21(Object mediaSession) {
            this.mSessionObj = MediaSessionCompatApi21.verifySession(mediaSession);
            this.mToken = new Token(MediaSessionCompatApi21.getSessionToken(this.mSessionObj));
        }

        @Override
        public void setCallback(Callback callback, Handler handler) {
            MediaSessionCompatApi21.setCallback(this.mSessionObj, callback.mCallbackObj, handler);
        }

        @Override
        public void setFlags(int flags) {
            MediaSessionCompatApi21.setFlags(this.mSessionObj, flags);
        }

        @Override
        public void setPlaybackToLocal(int stream) {
            MediaSessionCompatApi21.setPlaybackToLocal(this.mSessionObj, stream);
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
            MediaSessionCompatApi21.setPlaybackToRemote(this.mSessionObj, volumeProvider.getVolumeProvider());
        }

        @Override
        public void setActive(boolean active) {
            MediaSessionCompatApi21.setActive(this.mSessionObj, active);
        }

        @Override
        public boolean isActive() {
            return MediaSessionCompatApi21.isActive(this.mSessionObj);
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
            MediaSessionCompatApi21.sendSessionEvent(this.mSessionObj, event, extras);
        }

        @Override
        public void release() {
            MediaSessionCompatApi21.release(this.mSessionObj);
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
            MediaSessionCompatApi21.setPlaybackState(this.mSessionObj, state.getPlaybackState());
        }

        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
            MediaSessionCompatApi21.setMetadata(this.mSessionObj, metadata.getMediaMetadata());
        }

        @Override
        public Object getMediaSession() {
            return this.mSessionObj;
        }
    }

    static class MediaSessionImplBase
    implements MediaSessionImpl {
        MediaSessionImplBase() {
        }

        @Override
        public void setCallback(Callback callback, Handler handler) {
        }

        @Override
        public void setFlags(int flags) {
        }

        @Override
        public void setPlaybackToLocal(int stream) {
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
        }

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
        }

        @Override
        public void release() {
        }

        @Override
        public Token getSessionToken() {
            return null;
        }

        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
        }

        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
        }

        @Override
        public Object getMediaSession() {
            return null;
        }
    }

    static interface MediaSessionImpl {
        public void setCallback(Callback var1, Handler var2);

        public void setFlags(int var1);

        public void setPlaybackToLocal(int var1);

        public void setPlaybackToRemote(VolumeProviderCompat var1);

        public void setActive(boolean var1);

        public boolean isActive();

        public void sendSessionEvent(String var1, Bundle var2);

        public void release();

        public Token getSessionToken();

        public void setPlaybackState(PlaybackStateCompat var1);

        public void setMetadata(MediaMetadataCompat var1);

        public Object getMediaSession();
    }

    public static final class Token
    implements Parcelable {
        private final Parcelable mInner;
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            public Token createFromParcel(Parcel in) {
                return new Token(in.readParcelable(null));
            }

            public Token[] newArray(int size) {
                return new Token[size];
            }
        };

        Token(Parcelable inner) {
            this.mInner = inner;
        }

        public int describeContents() {
            return this.mInner.describeContents();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mInner, flags);
        }

        public Object getToken() {
            return this.mInner;
        }
    }

    public static abstract class Callback {
        final Object mCallbackObj = Build.VERSION.SDK_INT >= 21 ? MediaSessionCompatApi21.createCallback(new StubApi21()) : null;

        public void onCommand(String command, Bundle extras, ResultReceiver cb) {
        }

        public boolean onMediaButtonEvent(Intent mediaButtonEvent) {
            return false;
        }

        public void onPlay() {
        }

        public void onPause() {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onFastForward() {
        }

        public void onRewind() {
        }

        public void onStop() {
        }

        public void onSeekTo(long pos) {
        }

        public void onSetRating(RatingCompat rating) {
        }

        private class StubApi21
        implements MediaSessionCompatApi21.Callback {
            private StubApi21() {
            }

            @Override
            public void onCommand(String command, Bundle extras, ResultReceiver cb) {
                Callback.this.onCommand(command, extras, cb);
            }

            @Override
            public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
                return Callback.this.onMediaButtonEvent(mediaButtonIntent);
            }

            @Override
            public void onPlay() {
                Callback.this.onPlay();
            }

            @Override
            public void onPause() {
                Callback.this.onPause();
            }

            @Override
            public void onSkipToNext() {
                Callback.this.onSkipToNext();
            }

            @Override
            public void onSkipToPrevious() {
                Callback.this.onSkipToPrevious();
            }

            @Override
            public void onFastForward() {
                Callback.this.onFastForward();
            }

            @Override
            public void onRewind() {
                Callback.this.onRewind();
            }

            @Override
            public void onStop() {
                Callback.this.onStop();
            }

            @Override
            public void onSeekTo(long pos) {
                Callback.this.onSeekTo(pos);
            }

            @Override
            public void onSetRating(Object ratingObj) {
                Callback.this.onSetRating(RatingCompat.fromRating(ratingObj));
            }
        }
    }
}

