/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Area;
import java.awt.BDGraphics;
import java.awt.BDImage;
import java.awt.BDImageConsumer;
import java.awt.BDOffScreenImageSource;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;

class BDImageBase
extends Image {
    private static Constructor bufferedImageConstructor;
    private Component component;
    protected int width;
    protected int height;
    protected int[] backBuffer;
    protected Area dirty;
    private GraphicsConfiguration gc;
    private Vector observers = new Vector();
    private ImageProducer offscreenSource = null;

    private static BufferedImage createBuffededImage(Image image) {
        try {
            return (BufferedImage)bufferedImageConstructor.newInstance(image);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    BDImageBase(Component component, int width, int height, GraphicsConfiguration gc) {
        this.component = component;
        this.width = width;
        this.height = height;
        this.gc = gc;
        if (width > 0 && height > 0) {
            this.backBuffer = new int[width * height];
        }
        this.dirty = new Area(width, height);
        this.offscreenSource = new BDOffScreenImageSource(this.backBuffer, width, height);
    }

    public void flush() {
    }

    public Graphics getGraphics() {
        return new BDGraphics((BDImage)this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidth(ImageObserver observer) {
        if (this.width < 0) {
            this.addObserver(observer);
        }
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeight(ImageObserver observer) {
        if (this.height < 0) {
            this.addObserver(observer);
        }
        return this.height;
    }

    public Object getProperty(String name) {
        return null;
    }

    public Object getProperty(String name, ImageObserver observer) {
        return null;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public Image getScaledInstance(int width, int height, int hints) {
        BDImageConsumer scaledImage = new BDImageConsumer(null);
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(width, height);
        scaleFilter = (AreaAveragingScaleFilter)scaleFilter.getFilterInstance(scaledImage);
        scaleFilter.setDimensions(this.width, this.height);
        scaleFilter.setPixels(0, 0, this.width, this.height, ColorModel.getRGBdefault(), this.backBuffer, 0, this.width);
        scaleFilter.imageComplete(3);
        return scaledImage;
    }

    public ImageProducer getSource() {
        return this.offscreenSource;
    }

    public Component getComponent() {
        return this.component;
    }

    protected int[] getBdBackBuffer() {
        return this.backBuffer;
    }

    protected int[] getBackBuffer() {
        System.err.println("**** BDIMAGE GETBACKBUFFER ****");
        return this.backBuffer;
    }

    protected Area getDirtyArea() {
        return this.dirty;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.gc;
    }

    protected void addObserver(ImageObserver observer) {
        if (observer != null && !this.isObserver(observer)) {
            this.observers.addElement(observer);
        }
    }

    protected boolean isObserver(ImageObserver observer) {
        return this.observers.contains(observer);
    }

    protected void removeObserver(ImageObserver observer) {
        this.observers.removeElement(observer);
    }

    protected void notifyObservers(Image img, int info, int x, int y, int w, int h) {
        ImageObserver observer;
        Enumeration enumeration = this.observers.elements();
        Vector<ImageObserver> acquired = null;
        while (enumeration.hasMoreElements()) {
            observer = (ImageObserver)enumeration.nextElement();
            if (observer.imageUpdate(img, info, x, y, w, h)) continue;
            if (acquired == null) {
                acquired = new Vector<ImageObserver>();
            }
            acquired.addElement(observer);
        }
        if (acquired != null) {
            enumeration = acquired.elements();
            while (enumeration.hasMoreElements()) {
                observer = (ImageObserver)enumeration.nextElement();
                this.removeObserver(observer);
            }
        }
    }

    public int getType() {
        return 2;
    }

    public ColorModel getColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }

    public int getRGB(int x, int y) {
        return this.backBuffer[y * this.width + x];
    }

    public int[] getRGB(int x, int y, int w, int h, int[] rgbArray, int offset, int scansize) {
        if (rgbArray == null) {
            rgbArray = new int[offset + h * scansize];
        }
        for (int i = 0; i < h; ++i) {
            System.arraycopy(this.backBuffer, (y + i) * this.width + x, rgbArray, i * scansize + offset, w);
        }
        return rgbArray;
    }

    public void setRGB(int x, int y, int rgb) {
        this.backBuffer[y * this.width + x] = rgb;
        this.dirty.add(x, y);
    }

    public void setRGB(int x, int y, int w, int h, int[] rgbArray, int offset, int scansize) {
        for (int i = 0; i < h; ++i) {
            System.arraycopy(rgbArray, i * scansize + offset, this.backBuffer, (y + i) * this.width + x, w);
        }
        this.dirty.add(new Rectangle(x, y, w, h));
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        BDImage image = new BDImage(this.component, w, h, this.gc);
        int[] rgbArray = image.getBdBackBuffer();
        this.getRGB(x, y, w, h, rgbArray, 0, w);
        return BDImageBase.createBuffededImage(image);
    }

    public static BufferedImage getBuffededImage(int w, int h, GraphicsConfiguration gc) {
        BDImage image = new BDImage(null, w, h, gc);
        return BDImageBase.createBuffededImage(image);
    }

    static {
        try {
            final Class<?> c = Class.forName("java.awt.image.BufferedImage");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    bufferedImageConstructor = c.getDeclaredConstructors()[0];
                    bufferedImageConstructor.setAccessible(true);
                    return null;
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new AWTError("java.awt.image.BufferedImage not found");
        }
    }
}

